/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.ldapdriver;

import com.novell.ldap.LDAPDN;
import com.novell.ldap.LDAPEntry;
import com.silverpeas.util.ArrayUtil;
import com.stratelia.silverpeas.domains.ldapdriver.AbstractLDAPGroup;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPUtility;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import java.util.TreeMap;
import java.util.Vector;

public class LDAPGroupSubTree
extends AbstractLDAPGroup {
    protected String[] getMemberGroupIds(String lds, String memberId, boolean isGroup) throws AdminException {
        Vector<String> groupsVector = new Vector<String>();
        LDAPEntry memberEntry = null;
        LDAPEntry groupEntry = null;
        SilverTrace.info("admin", "LDAPGroupSubTree.getMemberGroupIds()", "root.MSG_GEN_ENTER_METHOD", "MemberId=" + memberId + ", isGroup=" + isGroup);
        memberEntry = isGroup ? LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsIdFilter(memberId), this.driverSettings.getGroupAttributes()) : LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(memberId), this.driverSettings.getGroupAttributes());
        if (memberEntry == null) {
            throw new AdminException("LDAPGroupSubTree.getMemberGroupIds", 4, "admin.EX_ERR_LDAP_USER_ENTRY_ISNULL", "Id=" + memberId + " IsGroup=" + isGroup);
        }
        String[] baseGroupDN = LDAPDN.explodeDN((String)this.driverSettings.getGroupsSpecificGroupsBaseDN(), (boolean)false);
        String[] memberDN = LDAPDN.explodeDN((String)memberEntry.getDN(), (boolean)false);
        if (memberDN.length - baseGroupDN.length > 1) {
            StringBuffer newDN = new StringBuffer();
            for (int i = 1; i < memberDN.length; ++i) {
                if (i > 1) {
                    newDN.append(",");
                }
                newDN.append(memberDN[i]);
            }
            groupEntry = LDAPUtility.getFirstEntryFromSearch(lds, newDN.toString(), 0, this.driverSettings.getGroupsFullFilter(), this.driverSettings.getGroupAttributes());
            groupsVector.add(LDAPUtility.getFirstAttributeValue(groupEntry, this.driverSettings.getGroupsIdField()));
        }
        return groupsVector.toArray(new String[groupsVector.size()]);
    }

    @Override
    public String[] getGroupMemberGroupIds(String lds, String groupId) throws AdminException {
        return this.getMemberGroupIds(lds, groupId, true);
    }

    @Override
    public String[] getUserMemberGroupIds(String lds, String userId) throws AdminException {
        return this.getMemberGroupIds(lds, userId, false);
    }

    @Override
    protected String[] getUserIds(String lds, LDAPEntry groupEntry) throws AdminException {
        LDAPEntry[] theEntries = null;
        Vector<String> usersVector = new Vector<String>();
        SilverTrace.info("admin", "LDAPGroupSubTree.getUserIds()", "root.MSG_GEN_ENTER_METHOD", "GroupDN=" + groupEntry.getDN());
        theEntries = LDAPUtility.search1000Plus(lds, groupEntry.getDN(), 1, this.driverSettings.getUsersFullFilter(), this.driverSettings.getUsersLoginField(), this.driverSettings.getGroupAttributes());
        for (int i = 0; i < theEntries.length; ++i) {
            String userSpecificId = LDAPUtility.getFirstAttributeValue(theEntries[i], this.driverSettings.getUsersIdField());
            if (LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), this.driverSettings.getScope(), this.driverSettings.getUsersIdFilter(userSpecificId), this.driverSettings.getGroupAttributes()) == null) continue;
            usersVector.add(userSpecificId);
        }
        return usersVector.toArray(new String[usersVector.size()]);
    }

    @Override
    protected LDAPEntry[] getChildGroupsEntry(String lds, String parentId, String extraFilter) throws AdminException {
        LDAPEntry parentEntry = null;
        try {
            SilverTrace.info("admin", "LDAPGroupSubTree.getChildGroupsEntry()", "root.MSG_GEN_ENTER_METHOD", "parentId=" + parentId);
            if (parentId != null && parentId.length() > 0) {
                String theFilter = extraFilter != null && extraFilter.length() > 0 ? "(&" + extraFilter + this.driverSettings.getGroupsIdFilter(parentId) + ")" : this.driverSettings.getGroupsIdFilter(parentId);
                parentEntry = LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getLDAPUserBaseDN(), 2, theFilter, this.driverSettings.getGroupAttributes());
            }
            return this.getChildGroupsEntryByLDAPEntry(lds, parentEntry);
        }
        catch (AdminException e) {
            if (this.synchroInProcess) {
                SilverTrace.warn("admin", "LDAPGroupSubTree.getChildGroupsEntry()", "admin.EX_ERR_CHILD_GROUPS", "ParentGroupId=" + parentId, e);
                this.append("PB getting Group's subgroups : ").append(parentId).append("\n");
                return ArrayUtil.EMPTY_LDAP_ENTRY_ARRAY;
            }
            throw e;
        }
    }

    private LDAPEntry[] getChildGroupsEntryByLDAPEntry(String lds, LDAPEntry parentEntry) throws AdminException {
        LDAPEntry[] theEntries = null;
        LDAPEntry[] sortResult = null;
        LDAPEntry theFirstEntry = null;
        Vector<LDAPEntry> entryVector = new Vector<LDAPEntry>();
        String previousDN = "";
        String searchDN = null;
        boolean includeGroup = true;
        searchDN = parentEntry == null ? this.driverSettings.getLDAPUserBaseDN() : parentEntry.getDN();
        SilverTrace.info("admin", "LDAPGroupSubTree.getGroupEntry()", "root.MSG_GEN_ENTER_METHOD", "groupDN=" + searchDN);
        theEntries = LDAPUtility.search1000Plus(lds, searchDN, this.driverSettings.getScope(), this.driverSettings.getGroupsFullFilter(), this.driverSettings.getGroupsNameField(), this.driverSettings.getGroupAttributes());
        sortResult = this.sortReversedDN(theEntries);
        for (int i = 0; i < sortResult.length; ++i) {
            SilverTrace.info("admin", "LDAPGroupSubTree.getChildGroupsEntryByLDAPEntry()", "root.MSG_GEN_PARAM_VALUE", "GROUP Found  : " + sortResult[i].getDN());
            if (sortResult[i].getDN().equalsIgnoreCase(searchDN) || sortResult[i].getDN().endsWith(previousDN) && previousDN.length() > 0) continue;
            includeGroup = true;
            if (!this.driverSettings.getGroupsIncludeEmptyGroups()) {
                try {
                    theFirstEntry = LDAPUtility.getFirstEntryFromSearch(lds, sortResult[i].getDN(), this.driverSettings.getScope(), this.driverSettings.getUsersFullFilter(), this.driverSettings.getGroupAttributes());
                    if (theFirstEntry == null) {
                        includeGroup = false;
                    }
                }
                catch (AdminException e) {
                    SilverTrace.error("admin", "LDAPGroupSubTree.getChildGroupsEntryByLDAPEntry()", "admin.MSG_ERR_LDAP_GENERAL", "USERS SEARCH FAILED", e);
                }
            }
            if (!includeGroup) continue;
            SilverTrace.info("admin", "LDAPGroupSubTree.getChildGroupsEntryByLDAPEntry()", "root.MSG_GEN_PARAM_VALUE", "GROUP ADDED !!!");
            entryVector.add(sortResult[i]);
            previousDN = sortResult[i].getDN();
        }
        return entryVector.toArray(new LDAPEntry[entryVector.size()]);
    }

    private LDAPEntry[] sortReversedDN(LDAPEntry[] theEntries) {
        TreeMap<String, LDAPEntry> theMap = new TreeMap<String, LDAPEntry>();
        if (theEntries == null) {
            return ArrayUtil.EMPTY_LDAP_ENTRY_ARRAY;
        }
        for (int i = 0; i < theEntries.length; ++i) {
            LDAPEntry groupEntry = theEntries[i];
            StringBuffer forReversing = new StringBuffer(groupEntry.getDN());
            forReversing.reverse();
            theMap.put(forReversing.toString(), groupEntry);
        }
        return theMap.values().toArray(new LDAPEntry[theMap.size()]);
    }
}

