/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.sqldriver;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.domains.sqldriver.SQLGroupTable;
import com.stratelia.silverpeas.domains.sqldriver.SQLGroupUserRelTable;
import com.stratelia.silverpeas.domains.sqldriver.SQLSettings;
import com.stratelia.silverpeas.domains.sqldriver.SQLUserTable;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AbstractDomainDriver;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.DomainProperty;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.silverpeas.admin.domain.DomainServiceFactory;
import org.silverpeas.admin.domain.quota.UserDomainQuotaKey;
import org.silverpeas.authentication.encryption.PasswordEncryption;
import org.silverpeas.authentication.encryption.PasswordEncryptionFactory;
import org.silverpeas.quota.exception.QuotaException;

public class SQLDriver
extends AbstractDomainDriver {
    protected Connection openedConnection = null;
    protected boolean inTransaction = false;
    protected SQLSettings drvSettings = new SQLSettings();
    protected SQLUserTable localUserMgr = new SQLUserTable(this.drvSettings);
    protected SQLGroupTable localGroupMgr = new SQLGroupTable(this.drvSettings);
    protected SQLGroupUserRelTable localGroupUserRelMgr = new SQLGroupUserRelTable(this.drvSettings);

    @Override
    public String[] getGroupMemberGroupIds(String groupId) throws Exception {
        Group group = this.getGroup(groupId);
        if (group != null && group.getSuperGroupId() != null) {
            return new String[]{group.getSuperGroupId()};
        }
        return null;
    }

    @Override
    public void initFromProperties(ResourceLocator rs) throws Exception {
        this.drvSettings.initFromProperties(rs);
    }

    @Override
    public UserDetail[] getAllChangedUsers(String fromTimeStamp, String toTimeStamp) throws Exception {
        return new UserDetail[0];
    }

    @Override
    public Group[] getAllChangedGroups(String fromTimeStamp, String toTimeStamp) throws Exception {
        return new Group[0];
    }

    @Override
    public UserDetail importUser(String userLogin) throws Exception {
        return null;
    }

    @Override
    public void removeUser(String userId) throws Exception {
    }

    @Override
    public UserDetail synchroUser(String userId) throws Exception {
        return null;
    }

    private void openConnection() throws AdminException {
        if (this.openedConnection == null) {
            SilverTrace.info("admin", "SQLDriver.openConnection()", "root.MSG_GEN_ENTER_METHOD");
            try {
                Class.forName(this.drvSettings.getClassName());
                this.openedConnection = DriverManager.getConnection(this.drvSettings.getJDBCUrl(), this.drvSettings.getAccessLogin(), this.drvSettings.getAccessPasswd());
            }
            catch (Exception e) {
                throw new AdminException("SQLDriver.openConnection", 4, "root.EX_CONNECTION_OPEN_FAILED", e);
            }
        }
    }

    public void closeConnection() throws AdminException {
        if (this.openedConnection != null && !this.inTransaction) {
            try {
                this.openedConnection.close();
            }
            catch (Exception e) {
                throw new AdminException("SQLDriver.closeConnection", 4, "root.EX_CONNECTION_CLOSE_FAILED", e);
            }
            finally {
                this.openedConnection = null;
            }
        }
    }

    @Override
    public String createUser(UserDetail ud) throws Exception {
        try {
            this.openConnection();
            DomainServiceFactory.getUserDomainQuotaService().verify(UserDomainQuotaKey.from(ud));
            int userId = this.localUserMgr.createUser(this.openedConnection, ud);
            this.localUserMgr.updateUserPassword(this.openedConnection, userId, "");
            this.localUserMgr.updateUserPasswordValid(this.openedConnection, userId, false);
            String string = SQLDriver.idAsString(userId);
            return string;
        }
        catch (QuotaException qe) {
            throw qe;
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.createUser", 4, "admin.EX_ERR_ADD_USER", ud.getFirstName() + " " + ud.getLastName(), e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void resetPassword(UserDetail user, String password) throws Exception {
        PasswordEncryptionFactory factory = PasswordEncryptionFactory.getFactory();
        PasswordEncryption encryption = factory.getDefaultPasswordEncryption();
        String encryptedPassword = encryption.encrypt(password);
        this.effectiveResetPassword(user, encryptedPassword);
    }

    @Override
    public void resetEncryptedPassword(UserDetail user, String encryptedPassword) throws Exception {
        this.effectiveResetPassword(user, encryptedPassword);
    }

    private void effectiveResetPassword(UserDetail user, String password) throws Exception {
        try {
            this.openConnection();
            this.localUserMgr.updateUserPassword(this.openedConnection, SQLDriver.idAsInt(user.getSpecificId()), password);
            this.localUserMgr.updateUserPasswordValid(this.openedConnection, SQLDriver.idAsInt(user.getSpecificId()), true);
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.effectiveResetPassword", 4, "admin.EX_ERR_RESET_PASSWORD", "userSpecificId : " + user.getSpecificId(), e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void deleteUser(String userId) throws Exception {
        try {
            this.openConnection();
            this.localGroupUserRelMgr.removeAllUserRel(this.openedConnection, SQLDriver.idAsInt(userId));
            this.localUserMgr.deleteUser(this.openedConnection, SQLDriver.idAsInt(userId));
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.deleteUser", 4, "admin.EX_ERR_DELETE_USER", "userId : " + userId, e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void updateUserFull(UserFull uf) throws Exception {
        try {
            String[] specificProps;
            this.openConnection();
            this.localUserMgr.updateUser(this.openedConnection, uf);
            int userId = SQLDriver.idAsInt(uf.getSpecificId());
            for (String specificProp : specificProps = this.getPropertiesNames()) {
                DomainProperty theProp = this.getProperty(specificProp);
                this.localUserMgr.updateUserSpecificProperty(this.openedConnection, userId, theProp, uf.getValue(theProp.getName()));
            }
            if (this.drvSettings.isUserPasswordAvailable()) {
                String existingPassword;
                if (StringUtil.isDefined(uf.getPassword()) && !(existingPassword = this.localUserMgr.getUserPassword(this.openedConnection, userId)).equals(uf.getPassword())) {
                    PasswordEncryptionFactory factory = PasswordEncryptionFactory.getFactory();
                    PasswordEncryption encryption = factory.getDefaultPasswordEncryption();
                    String encryptedPassword = encryption.encrypt(uf.getPassword());
                    this.localUserMgr.updateUserPassword(this.openedConnection, userId, encryptedPassword);
                }
                this.localUserMgr.updateUserPasswordValid(this.openedConnection, userId, uf.isPasswordValid());
            }
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.updateUserFull", 4, "admin.EX_ERR_UPDATE_USER", uf.getFirstName() + " " + uf.getLastName(), e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void updateUserDetail(UserDetail ud) throws Exception {
        try {
            this.openConnection();
            this.localUserMgr.updateUser(this.openedConnection, ud);
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.updateUserDetail", 4, "admin.EX_ERR_UPDATE_USER", ud.getFirstName() + " " + ud.getLastName(), e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public UserDetail getUser(String userId) throws Exception {
        try {
            this.openConnection();
            UserDetail userDetail = this.localUserMgr.getUser(this.openedConnection, SQLDriver.idAsInt(userId));
            return userDetail;
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.getUser", 4, "admin.EX_ERR_GET_USER", "userId : " + userId, e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public UserFull getUserFull(String id) throws Exception {
        try {
            this.openConnection();
            int userId = SQLDriver.idAsInt(id);
            UserFull uf = null;
            UserDetail ud = this.localUserMgr.getUser(this.openedConnection, userId);
            if (ud != null) {
                String[] specificProps;
                uf = new UserFull(this, ud);
                if (this.drvSettings.isUserPasswordAvailable()) {
                    uf.setPasswordAvailable(true);
                    uf.setPassword(this.localUserMgr.getUserPassword(this.openedConnection, userId));
                    uf.setPasswordValid(this.localUserMgr.getUserPasswordValid(this.openedConnection, userId));
                }
                for (String specificProp : specificProps = this.getPropertiesNames()) {
                    DomainProperty theProp = this.getProperty(specificProp);
                    String value = this.localUserMgr.getUserSpecificProperty(this.openedConnection, userId, theProp);
                    uf.setValue(theProp.getName(), value);
                }
            }
            UserFull userFull = uf;
            return userFull;
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.getUserFull", 4, "admin.EX_ERR_GET_USER", "userId : " + id, e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public String[] getUserMemberGroupIds(String userId) throws Exception {
        return new String[0];
    }

    @Override
    public UserDetail[] getAllUsers() throws Exception {
        try {
            this.openConnection();
            List<UserDetail> users = this.localUserMgr.getAllUsers(this.openedConnection);
            UserDetail[] userDetailArray = users.toArray(new UserDetail[users.size()]);
            return userDetailArray;
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.getAllUsers", 4, "admin.EX_ERR_GET_ALL_USERS", e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public UserDetail[] getUsersBySpecificProperty(String propertyName, String propertyValue) throws Exception {
        DomainProperty property = this.getProperty(propertyName);
        if (property == null) {
            return null;
        }
        try {
            this.openConnection();
            List<UserDetail> users = this.localUserMgr.getUsersBySpecificProperty(this.openedConnection, property.getMapParameter(), propertyValue);
            UserDetail[] userDetailArray = users.toArray(new UserDetail[users.size()]);
            return userDetailArray;
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.getUsersBySpecificProperty", 4, "admin.EX_ERR_GET_USERS", e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public UserDetail[] getUsersByQuery(Map<String, String> query) throws Exception {
        return new UserDetail[0];
    }

    @Override
    public Group importGroup(String groupName) throws Exception {
        return null;
    }

    @Override
    public void removeGroup(String groupId) throws Exception {
    }

    @Override
    public Group synchroGroup(String groupId) throws Exception {
        return null;
    }

    @Override
    public String createGroup(Group group) throws Exception {
        try {
            String[] asUserIds;
            this.openConnection();
            int theGrpId = this.localGroupMgr.createGroup(this.openedConnection, group);
            String theGrpIdStr = Integer.toString(theGrpId);
            for (String asUserId : asUserIds = group.getUserIds()) {
                if (!StringUtil.isDefined(asUserId)) continue;
                this.addUserInGroup(asUserId, theGrpIdStr);
            }
            String string = theGrpIdStr;
            return string;
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.createGroup", 4, "admin.EX_ERR_ADD_GROUP", group.getName(), e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void deleteGroup(String groupId) throws Exception {
        try {
            this.openConnection();
            ArrayList<Group> allSubGroups = new ArrayList<Group>();
            allSubGroups.add(this.localGroupMgr.getGroup(this.openedConnection, SQLDriver.idAsInt(groupId)));
            while (allSubGroups.size() > 0) {
                int gid = SQLDriver.idAsInt(((Group)allSubGroups.remove(0)).getSpecificId());
                allSubGroups.addAll(this.localGroupMgr.getDirectSubGroups(this.openedConnection, gid));
                this.localGroupUserRelMgr.removeAllGroupRel(this.openedConnection, gid);
                this.localGroupMgr.deleteGroup(this.openedConnection, gid);
            }
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.deleteGroup", 4, "admin.EX_ERR_DELETE_GROUP", "groupId : " + groupId, e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void updateGroup(Group group) throws Exception {
        ArrayList<String> alAddUsers = new ArrayList<String>();
        int groupId = SQLDriver.idAsInt(group.getSpecificId());
        try {
            String[] asNewUsersId;
            if (group == null || group.getName().length() == 0 || group.getSpecificId().length() == 0) {
                throw new AdminException("SQLDriver.updateGroup", 4, "admin.EX_ERR_INVALID_GROUP");
            }
            this.openConnection();
            this.localGroupMgr.updateGroup(this.openedConnection, group);
            List<String> asOldUsersId = this.localGroupUserRelMgr.getDirectUserIdsOfGroup(this.openedConnection, groupId);
            for (String anAsNewUsersId : asNewUsersId = group.getUserIds()) {
                if (asOldUsersId.remove(anAsNewUsersId)) continue;
                alAddUsers.add(anAsNewUsersId);
            }
            for (String anAsOldUsersId : asOldUsersId) {
                this.localGroupUserRelMgr.removeGroupUserRel(this.openedConnection, groupId, SQLDriver.idAsInt(anAsOldUsersId));
            }
            for (String alAddUser : alAddUsers) {
                this.localGroupUserRelMgr.createGroupUserRel(this.openedConnection, groupId, SQLDriver.idAsInt(alAddUser));
            }
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.updateGroup", 4, "admin.EX_ERR_UPDATE_GROUP", "groupId : " + group.getSpecificId(), e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public Group getGroup(String groupId) throws Exception {
        try {
            this.openConnection();
            Group valret = this.localGroupMgr.getGroup(this.openedConnection, SQLDriver.idAsInt(groupId));
            if (valret != null) {
                List<String> asUsersId = this.localGroupUserRelMgr.getDirectUserIdsOfGroup(this.openedConnection, SQLDriver.idAsInt(groupId));
                valret.setUserIds(asUsersId.toArray(new String[asUsersId.size()]));
            }
            Group group = valret;
            return group;
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.getGroup", 4, "admin.EX_ERR_GET_GROUP", "groupId : " + groupId, e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public Group getGroupByName(String groupName) throws Exception {
        try {
            Group valret;
            this.openConnection();
            Group group = valret = this.localGroupMgr.getGroupByName(this.openedConnection, groupName);
            return group;
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.getGroupByName", 4, "admin.EX_ERR_GET_GROUP", "groupName : " + groupName, e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public Group[] getGroups(String groupId) throws Exception {
        try {
            this.openConnection();
            List<Group> ar = this.localGroupMgr.getDirectSubGroups(this.openedConnection, SQLDriver.idAsInt(groupId));
            for (Group theGroup : ar) {
                List<String> asUsersId = this.localGroupUserRelMgr.getDirectUserIdsOfGroup(this.openedConnection, SQLDriver.idAsInt(theGroup.getSpecificId()));
                theGroup.setUserIds(asUsersId.toArray(new String[asUsersId.size()]));
            }
            Group[] groupArray = ar.toArray(new Group[ar.size()]);
            return groupArray;
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.getGroups", 4, "admin.EX_ERR_GET_GROUPS", "father group id : " + groupId, e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public Group[] getAllGroups() throws Exception {
        try {
            this.openConnection();
            List<Group> ar = this.localGroupMgr.getAllGroups(this.openedConnection);
            for (Group theGroup : ar) {
                List<String> asUsersId = this.localGroupUserRelMgr.getDirectUserIdsOfGroup(this.openedConnection, SQLDriver.idAsInt(theGroup.getSpecificId()));
                theGroup.setUserIds(asUsersId.toArray(new String[asUsersId.size()]));
            }
            Group[] groupArray = ar.toArray(new Group[ar.size()]);
            return groupArray;
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.getAllGroups", 4, "admin.EX_ERR_GET_ALL_GROUPS", e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public Group[] getAllRootGroups() throws Exception {
        try {
            this.openConnection();
            List<Group> ar = this.localGroupMgr.getDirectSubGroups(this.openedConnection, -1);
            for (Group theGroup : ar) {
                List<String> asUsersId = this.localGroupUserRelMgr.getDirectUserIdsOfGroup(this.openedConnection, SQLDriver.idAsInt(theGroup.getSpecificId()));
                theGroup.setUserIds(asUsersId.toArray(new String[asUsersId.size()]));
            }
            Group[] groupArray = ar.toArray(new Group[ar.size()]);
            return groupArray;
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.getAllRootGroups", 4, "admin.EX_ERR_GET_ALL_ROOT_GROUPS", e);
        }
        finally {
            this.closeConnection();
        }
    }

    public void addUserInGroup(String userId, String groupId) throws Exception {
        try {
            this.openConnection();
            this.localGroupUserRelMgr.createGroupUserRel(this.openedConnection, SQLDriver.idAsInt(groupId), SQLDriver.idAsInt(userId));
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.addUserInGroup", 4, "admin.EX_ERR_ADD_USER_IN_GROUP", "userId : '" + userId + "', groupId : '" + groupId + "'", e);
        }
        finally {
            this.closeConnection();
        }
    }

    public void removeUserFromGroup(String userId, String groupId) throws Exception {
        try {
            this.openConnection();
            this.localGroupUserRelMgr.removeGroupUserRel(this.openedConnection, SQLDriver.idAsInt(groupId), SQLDriver.idAsInt(userId));
        }
        catch (Exception e) {
            throw new AdminException("SQLDriver.removeUserFromGroup", 4, "admin.EX_ERR_REMOVE_USER_FROM_GROUP", "userId : '" + userId + "', groupId : '" + groupId + "'", e);
        }
        finally {
            this.closeConnection();
        }
    }

    @Override
    public void startTransaction(boolean bAutoCommit) {
        try {
            this.inTransaction = true;
            this.openConnection();
            if (this.openedConnection != null) {
                this.openedConnection.setAutoCommit(bAutoCommit);
            }
        }
        catch (AdminException ex) {
            throw new UtilException("SQLDriver", "startTransaction", ex);
        }
        catch (SQLException ex) {
            throw new UtilException("SQLDriver", "startTransaction", ex);
        }
    }

    @Override
    public void commit() throws Exception {
        try {
            if (this.openedConnection != null) {
                this.openedConnection.commit();
            }
            this.inTransaction = false;
            this.closeConnection();
        }
        catch (AdminPersistenceException e) {
            throw new AdminException("SQLDriver.commit", 4, "root.EX_ERR_COMMIT", e);
        }
    }

    @Override
    public void rollback() throws Exception {
        try {
            if (this.openedConnection != null) {
                this.openedConnection.rollback();
            }
            this.inTransaction = false;
            this.closeConnection();
        }
        catch (AdminPersistenceException e) {
            throw new AdminException("SQLDriver.rollback", 4, "admin.EX_ERR_ROLLBACK", e);
        }
    }

    @Override
    public List<String> getUserAttributes() throws Exception {
        return Arrays.asList(this.getPropertiesNames());
    }
}

