/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager;

import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.UserDetail;

public class AbstractNotification {
    public String getApplicationURL() {
        return URLManager.getApplicationURL();
    }

    public String computeURL(Integer userId, String urlBase) {
        return this.computeURL(Integer.toString(userId), urlBase);
    }

    public String computeURL(String userId, String urlBase) {
        return urlBase.startsWith("http") ? urlBase : this.getUserAutoRedirectURL(userId, urlBase);
    }

    public String getUserAutoRedirectURL(String userId, String target) {
        String encodedTarget = URLManager.encodeURL(target);
        try {
            UserDetail ud = UserDetail.getById(userId);
            Domain dom = ud.getDomain();
            String url = URLManager.isPermalink(target) ? dom.getSilverpeasServerURL() + this.getApplicationURL() + target : this.getUserAutoRedirectURL(dom) + encodedTarget;
            return url;
        }
        catch (Exception e) {
            SilverTrace.error("peasCore", "URLManager.getUserAutoRedirectURL(userId, target)", "admin.EX_ERR_GET_USER_DETAILS", "user id: '" + userId + "', target: '" + target + "'", e);
            return "ErrorGettingDomainServer" + encodedTarget;
        }
    }

    public String getUserAutoRedirectURL(Domain dom) {
        return dom.getSilverpeasServerURL() + this.getApplicationURL() + "/autoRedirect.jsp?domainId=" + dom.getId() + "&goto=";
    }

    public String getUserAutoRedirectSilverpeasServerURL(String userId) {
        UserDetail ud = UserDetail.getById(userId);
        Domain dom = ud.getDomain();
        String url = dom.getSilverpeasServerURL() + this.getApplicationURL();
        return url;
    }
}

