/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager;

import com.silverpeas.notification.model.NotificationResourceData;
import com.silverpeas.ui.DisplayI18NHelper;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import com.stratelia.silverpeas.notificationManager.ExternalRecipient;
import com.stratelia.silverpeas.notificationManager.GroupRecipient;
import com.stratelia.silverpeas.notificationManager.NotificationManager;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationManagerSettings;
import com.stratelia.silverpeas.notificationManager.NotificationTemplateKey;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.util.Link;

public class NotificationMetaData
implements Serializable {
    private static final long serialVersionUID = 6004274748540324759L;
    public static final String BEFORE_MESSAGE_FOOTER_TAG = "<!--BEFORE_MESSAGE_FOOTER-->";
    public static final String AFTER_MESSAGE_FOOTER_TAG = "<!--AFTER_MESSAGE_FOOTER-->";
    private int messageType;
    private Date date;
    private String sender;
    private String source;
    private String link;
    private String sessionId;
    private Collection<UserRecipient> userRecipients;
    private Collection<UserRecipient> userRecipientsToExclude;
    private Collection<GroupRecipient> groupRecipients;
    private Collection<ExternalRecipient> externalRecipients;
    private String componentId;
    private boolean isAnswerAllowed = false;
    private String fileName;
    private boolean sendImmediately = false;
    private NotifAction action;
    private Map<String, NotificationResourceData> notificationResourceData = new HashMap<String, NotificationResourceData>();
    private Map<String, String> titles = new HashMap<String, String>();
    private Map<String, String> contents = new HashMap<String, String>();
    private Map<String, String> linkLabels = new HashMap<String, String>();
    private Map<String, SilverpeasTemplate> templates;
    private Map<String, SilverpeasTemplate> templatesMessageFooter;
    private String originalExtraMessage = null;
    private boolean displayReceiversInFooter = false;
    private boolean isManualUserOne = false;
    protected NotificationManager notificationManager = null;

    public NotificationMetaData() {
        this.reset();
    }

    public NotificationMetaData(int messageType, String title, String content) {
        this.reset();
        this.messageType = messageType;
        this.templates = new HashMap<String, SilverpeasTemplate>();
        this.addLanguage(DisplayI18NHelper.getDefaultLanguage(), title, content);
    }

    public NotificationMetaData(int messageType, String title, Map<String, SilverpeasTemplate> templates, String fileName) {
        this(messageType, title, "");
        this.reset();
        this.templates = templates;
        this.fileName = fileName;
    }

    private void reset() {
        this.messageType = 0;
        this.date = new Date();
        this.sender = "";
        this.source = "";
        this.link = "";
        this.sessionId = "";
        this.userRecipients = new ArrayList<UserRecipient>();
        this.userRecipientsToExclude = new ArrayList<UserRecipient>();
        this.groupRecipients = new ArrayList<GroupRecipient>();
        this.externalRecipients = new ArrayList<ExternalRecipient>();
        this.componentId = "";
        this.isAnswerAllowed = false;
        this.fileName = null;
        this.templates = new HashMap<String, SilverpeasTemplate>();
        this.templatesMessageFooter = new HashMap<String, SilverpeasTemplate>();
        this.action = null;
        this.notificationResourceData.clear();
    }

    public final void addLanguage(String language, String title, String content) {
        this.titles.put(language, title);
        this.contents.put(language, content);
    }

    public Set<String> getLanguages() {
        HashSet<String> languages = new HashSet<String>(this.titles.keySet());
        languages.addAll(this.templates.keySet());
        return languages;
    }

    public Map<String, SilverpeasTemplate> getTemplates() {
        return Collections.unmodifiableMap(this.templates);
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDate() {
        return this.date;
    }

    public void setTitle(String title) {
        this.titles.put(DisplayI18NHelper.getDefaultLanguage(), title);
    }

    public void setTitle(String title, String language) {
        this.titles.put(language, title);
    }

    public String getTitle() {
        return this.getTitle(DisplayI18NHelper.getDefaultLanguage());
    }

    public String getTitle(String language) {
        String result = "";
        if (this.templates != null && !this.templates.isEmpty()) {
            SilverpeasTemplate template = this.templates.get(language);
            if (template != null) {
                result = template.applyStringTemplate(this.titles.get(language));
            }
        } else {
            result = this.titles.get(language);
        }
        return result;
    }

    public void setContent(String content) {
        this.contents.put(DisplayI18NHelper.getDefaultLanguage(), content);
    }

    public void setContent(String content, String language) {
        SilverTrace.info("notificationManager", "NotificationMetaData.setContent()", "root.MSG_GEN_ENTER_METHOD", "language = " + language + ", content = " + content);
        this.contents.put(language, content);
    }

    public String getContent() {
        return this.getContent(DisplayI18NHelper.getDefaultLanguage());
    }

    public String getContent(String language) {
        SilverTrace.info("notificationManager", "NotificationMetaData.getContent()", "root.MSG_GEN_ENTER_METHOD", "language = " + language);
        StringBuilder result = new StringBuilder();
        if (this.templates != null && !this.templates.isEmpty()) {
            SilverpeasTemplate template = this.templates.get(language);
            if (template != null) {
                result.append(template.applyFileTemplate(this.fileName + '_' + language));
            }
        } else {
            String content = this.contents.get(language);
            if (content != null) {
                result.append(content);
            }
            if (StringUtil.isDefined(this.getOriginalExtraMessage())) {
                result.append("<div style=\"padding=10px 0 10px 0;\">").append("<div style=\"background-color:#FFF9D7; border:1px solid #E2C822; padding:5px; width:390px;\">").append(this.getOriginalExtraMessage()).append("</div></div>");
            }
        }
        result.append(BEFORE_MESSAGE_FOOTER_TAG);
        SilverpeasTemplate templateMessageFooter = this.getTemplateMessageFooter(language);
        if (templateMessageFooter != null && this.displayReceiversInFooter) {
            try {
                String receiver_groups;
                String receiver_users = this.getUserReceiverFormattedList();
                if (StringUtil.isDefined(receiver_users)) {
                    templateMessageFooter.setAttribute(NotificationTemplateKey.notification_receiver_users.toString(), receiver_users);
                }
                if (StringUtil.isDefined(receiver_groups = this.getGroupReceiverFormattedList())) {
                    templateMessageFooter.setAttribute(NotificationTemplateKey.notification_receiver_groups.toString(), receiver_groups);
                }
            }
            catch (NotificationManagerException e) {
                SilverTrace.warn("notificationManager", "NotificationMetaData.getContent()", "root.EX_ADD_USERS_FAILED", e);
            }
            String messageFooter = templateMessageFooter.applyFileTemplate("messageFooter_" + language).replaceAll("[\\n\\r]", "");
            if (messageFooter.length() > 0) {
                result.append(messageFooter);
            }
        }
        result.append(AFTER_MESSAGE_FOOTER_TAG);
        SilverTrace.info("notificationManager", "NotificationMetaData.getContent()", "root.MSG_GEN_EXIT_METHOD", "result = " + result);
        return EncodeHelper.convertWhiteSpacesForHTMLDisplay(result.toString());
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public void setAnswerAllowed(boolean answerAllowed) {
        this.isAnswerAllowed = answerAllowed;
    }

    public String getSender() {
        return this.sender;
    }

    public boolean isAnswerAllowed() {
        return this.isAnswerAllowed;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(Link link) {
        this.setLink(link, DisplayI18NHelper.getDefaultLanguage());
    }

    public void setLink(Link link, String language) {
        this.link = link.getLinkUrl();
        this.linkLabels.put(language, link.getLinkLabel());
    }

    public String getLinkLabel() {
        return this.getLinkLabel(DisplayI18NHelper.getDefaultLanguage());
    }

    public String getLinkLabel(String language) {
        return this.linkLabels.get(language);
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setUserRecipients(Collection<UserRecipient> users) {
        this.userRecipients = users != null ? new ArrayList<UserRecipient>(users) : new ArrayList<UserRecipient>();
    }

    public Collection<UserRecipient> getUserRecipients() {
        return this.userRecipients;
    }

    public void addUserRecipient(UserRecipient user) {
        if (UserDetail.isActivatedStateFor(user.getUserId())) {
            this.userRecipients.add(user);
        }
    }

    public void addUserRecipients(UserRecipient[] users) {
        if (users != null) {
            for (UserRecipient userRecipient : users) {
                this.addUserRecipient(userRecipient);
            }
        }
    }

    public void addUserRecipients(Collection<UserRecipient> users) {
        if (users != null) {
            for (UserRecipient userRecipient : users) {
                this.addUserRecipient(userRecipient);
            }
        }
    }

    public void setUserRecipientsToExclude(Collection<UserRecipient> users) {
        this.userRecipientsToExclude = users != null ? new ArrayList<UserRecipient>(users) : new ArrayList<UserRecipient>();
    }

    public Collection<UserRecipient> getUserRecipientsToExclude() {
        return this.userRecipientsToExclude;
    }

    public void addUserRecipientToExclude(UserRecipient user) {
        this.userRecipientsToExclude.add(user);
    }

    public void addUserRecipientsToExclude(UserRecipient[] users) {
        if (users != null) {
            this.userRecipientsToExclude.addAll(Arrays.asList(users));
        }
    }

    public void addUserRecipientsToExclude(Collection<UserRecipient> users) {
        if (users != null) {
            this.userRecipientsToExclude.addAll(users);
        }
    }

    public Collection<ExternalRecipient> getExternalRecipients() {
        return this.externalRecipients;
    }

    public void setExternalRecipients(Collection<ExternalRecipient> externalRecipients) {
        if (externalRecipients != null) {
            this.externalRecipients = externalRecipients;
        }
    }

    public void addExternalRecipient(ExternalRecipient externalRecipient) {
        this.externalRecipients.add(externalRecipient);
    }

    public void setGroupRecipients(Collection<GroupRecipient> groups) {
        this.groupRecipients = groups != null ? new ArrayList<GroupRecipient>(groups) : new ArrayList<GroupRecipient>();
    }

    public Collection<GroupRecipient> getGroupRecipients() {
        return Collections.unmodifiableCollection(this.groupRecipients);
    }

    public void addGroupRecipient(GroupRecipient group) {
        this.groupRecipients.add(group);
    }

    public void addGroupRecipients(Collection<GroupRecipient> groups) {
        if (groups != null) {
            this.groupRecipients.addAll(groups);
        }
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    public void addExtraMessage(String message, String language) {
        this.setOriginalExtraMessage(message);
        if (this.templates != null && !this.templates.isEmpty()) {
            this.templates.get(language).setAttribute("senderMessage", message);
        }
    }

    public String getOriginalExtraMessage() {
        return this.originalExtraMessage;
    }

    public void setOriginalExtraMessage(String originalExtraMessage) {
        this.originalExtraMessage = originalExtraMessage;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isSendImmediately() {
        return this.sendImmediately;
    }

    public void setSendImmediately(boolean sendImmediately) {
        this.sendImmediately = sendImmediately;
    }

    public NotifAction getAction() {
        return this.action;
    }

    public void setAction(NotifAction action) {
        this.action = action;
    }

    public void setNotificationResourceData(NotificationResourceData notificationResourceData) {
        this.setNotificationResourceData(DisplayI18NHelper.getDefaultLanguage(), notificationResourceData);
    }

    public void setNotificationResourceData(String lang, NotificationResourceData notificationResourceData) {
        this.notificationResourceData.put(lang, notificationResourceData);
    }

    public NotificationResourceData getNotificationResourceData() {
        return this.getNotificationResourceData(DisplayI18NHelper.getDefaultLanguage());
    }

    public NotificationResourceData getNotificationResourceData(String lang) {
        return this.notificationResourceData.get(lang);
    }

    public boolean isSendByAUser() {
        return StringUtil.isInteger(this.getSender());
    }

    private SilverpeasTemplate createTemplateMessageFooter(String language) {
        SilverpeasTemplate templateFooter = SilverpeasTemplateFactory.createSilverpeasTemplateOnCore("notification");
        this.templatesMessageFooter.put(language, templateFooter);
        return templateFooter;
    }

    public SilverpeasTemplate getTemplateMessageFooter(String language) {
        SilverpeasTemplate templateMessageFooter;
        if (this.templatesMessageFooter == null) {
            this.templatesMessageFooter = new HashMap<String, SilverpeasTemplate>();
        }
        if ((templateMessageFooter = this.templatesMessageFooter.get(language)) == null) {
            templateMessageFooter = this.createTemplateMessageFooter(language);
        }
        return templateMessageFooter;
    }

    public Set<UserRecipient> getAllUserRecipients() throws NotificationManagerException {
        return this.getAllUserRecipients(false);
    }

    public Set<UserRecipient> getAllUserRecipients(boolean updateInternalUserRecipientsToExclude) throws NotificationManagerException {
        HashSet<UserRecipient> allUniqueUserRecipients = new HashSet<UserRecipient>();
        Collection<UserRecipient> userRecipients = this.getUserRecipients();
        Collection<GroupRecipient> groupRecipients = this.getGroupRecipients();
        HashSet<UserRecipient> userRecipientsToExclude = updateInternalUserRecipientsToExclude ? this.getUserRecipientsToExclude() : new HashSet<UserRecipient>(this.getUserRecipientsToExclude());
        allUniqueUserRecipients.addAll(userRecipients);
        for (GroupRecipient group : groupRecipients) {
            allUniqueUserRecipients.addAll(this.getNotificationManager().getUsersFromGroup(group.getGroupId()));
        }
        allUniqueUserRecipients.removeAll(userRecipientsToExclude);
        return allUniqueUserRecipients;
    }

    private Set<UserRecipient> getUsersForReceiverBlock() throws NotificationManagerException {
        HashSet<UserRecipient> usersSet = new HashSet<UserRecipient>();
        usersSet.addAll(this.getUserRecipients());
        for (GroupRecipient group : this.getGroupRecipients()) {
            if (this.displayGroup(group.getGroupId())) continue;
            usersSet.addAll(this.getNotificationManager().getUsersFromGroup(group.getGroupId()));
        }
        usersSet.removeAll(this.getUserRecipientsToExclude());
        return usersSet;
    }

    protected boolean displayGroup(String groupId) {
        int threshold = NotificationManagerSettings.getReceiverThresholdAfterThatReplaceUserNameListByGroupName();
        Group group = OrganisationControllerFactory.getOrganisationController().getGroup(groupId);
        int nbUsers = group.getNbUsers();
        boolean res1 = NotificationManagerSettings.isDisplayingUserNameListInsteadOfGroupEnabled();
        boolean res2 = threshold > 0 && nbUsers > threshold;
        return res1 || res2;
    }

    private String getUserReceiverFormattedList() throws NotificationManagerException {
        StringBuilder users = new StringBuilder();
        if (NotificationManagerSettings.isDisplayingReceiversInNotificationMessageEnabled() && this.displayReceiversInFooter) {
            Set<UserRecipient> usersSet = this.getUsersForReceiverBlock();
            boolean first = true;
            for (UserRecipient anUsersSet : usersSet) {
                if (!first) {
                    users.append(", ");
                }
                users.append(OrganisationControllerFactory.getOrganisationController().getUserDetail(anUsersSet.getUserId()).getDisplayedName());
                first = false;
            }
        }
        return users.toString();
    }

    private Set<GroupRecipient> getGroupsForReceiverBlock() {
        HashSet<GroupRecipient> groupsSet = new HashSet<GroupRecipient>();
        for (GroupRecipient group : this.getGroupRecipients()) {
            if (!this.displayGroup(group.getGroupId())) continue;
            groupsSet.add(group);
        }
        return groupsSet;
    }

    private String getGroupReceiverFormattedList() {
        StringBuilder groups = new StringBuilder();
        if (NotificationManagerSettings.isDisplayingReceiversInNotificationMessageEnabled() && this.displayReceiversInFooter) {
            Set<GroupRecipient> groupsSet = this.getGroupsForReceiverBlock();
            boolean first = true;
            for (GroupRecipient aGroupsSet : groupsSet) {
                if (!first) {
                    groups.append(", ");
                }
                groups.append(OrganisationControllerFactory.getOrganisationController().getGroup(aGroupsSet.getGroupId()).getName());
                first = false;
            }
        }
        return groups.toString();
    }

    public NotificationMetaData displayReceiversInFooter() {
        this.displayReceiversInFooter = true;
        return this;
    }

    public NotificationMetaData manualUserNotification() {
        this.isManualUserOne = true;
        return this;
    }

    public boolean isManualUserOne() {
        return this.isManualUserOne;
    }

    private NotificationManager getNotificationManager() {
        if (this.notificationManager == null) {
            this.notificationManager = new NotificationManager(null);
        }
        return this.notificationManager;
    }
}

