/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationManager.model;

import com.silverpeas.SilverpeasServiceProvider;
import com.silverpeas.accesscontrol.ForbiddenRuntimeException;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.notificationManager.model.SentNotificationDAO;
import com.stratelia.silverpeas.notificationManager.model.SentNotificationDetail;
import com.stratelia.silverpeas.notificationManager.model.SentNotificationInterface;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SentNotificationInterfaceImpl
implements SentNotificationInterface {
    @Override
    public void saveNotifUser(NotificationMetaData metaData, Set<UserRecipient> usersSet) throws NotificationManagerException {
        Connection con = this.initCon();
        try {
            ArrayList<String> users = new ArrayList<String>();
            for (UserRecipient user : usersSet) {
                users.add(user.getUserId());
            }
            String language = SilverpeasServiceProvider.getPersonalizationService().getUserSettings(metaData.getSender()).getLanguage();
            SentNotificationDetail notif = new SentNotificationDetail(Integer.parseInt(metaData.getSender()), metaData.getMessageType(), metaData.getDate(), metaData.getTitle(language), metaData.getSource(), metaData.getLink(), metaData.getSessionId(), metaData.getComponentId(), metaData.getContent(language));
            notif.setUsers(users);
            int id = SentNotificationDAO.saveNotifUser(con, notif);
            notif.setNotifId(id);
        }
        catch (Exception e) {
            throw new NotificationManagerException("SentNotificationInterfaceImpl.saveNotifUser()", 4, "notificationManager.EX_CANT_SAVE_NOTIFICATION", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public List<SentNotificationDetail> getAllNotifByUser(String userId) throws NotificationManagerException {
        Connection con = this.initCon();
        try {
            List<SentNotificationDetail> list = SentNotificationDAO.getAllNotifByUser(con, userId);
            return list;
        }
        catch (Exception e) {
            throw new NotificationManagerException("SentNotificationInterfaceImpl.getAllNotifByUser()", 4, "notificationManager.EX_CANT_GET_NOTIFICATIONS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public SentNotificationDetail getNotification(int notifId) throws NotificationManagerException {
        Connection con = this.initCon();
        try {
            SentNotificationDetail sentNotificationDetail = SentNotificationDAO.getNotif(con, notifId);
            return sentNotificationDetail;
        }
        catch (Exception e) {
            throw new NotificationManagerException("SentNotificationInterfaceImpl.getNotification()", 4, "notificationManager.EX_CANT_GET_NOTIFICATION", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    @Override
    public void deleteNotif(int notifId, String userId) throws NotificationManagerException {
        block6: {
            Connection con = this.initCon();
            try {
                SentNotificationDetail toDel = this.getNotification(notifId);
                if (Integer.parseInt(userId) == toDel.getUserId()) {
                    SentNotificationDAO.deleteNotif(con, notifId);
                    break block6;
                }
                throw new ForbiddenRuntimeException("SentNotificationInterfaceImpl.deleteNotif()", 4, "peasCore.RESOURCE_ACCESS_UNAUTHORIZED", "notifId=" + notifId + ", userId=" + userId);
            }
            catch (Exception e) {
                throw new NotificationManagerException("SentNotificationInterfaceImpl.deleteNotif()", 4, "notificationManager.EX_CANT_DELETE_NOTIFICATION", e);
            }
            finally {
                DBUtil.close(con);
            }
        }
    }

    @Override
    public void deleteNotifByUser(String userId) throws NotificationManagerException {
        Connection con = this.initCon();
        try {
            SentNotificationDAO.deleteNotifByUser(con, userId);
        }
        catch (Exception e) {
            throw new NotificationManagerException("SentNotificationInterfaceImpl.deleteNotifByUser()", 4, "notificationManager.EX_CANT_DELETE_NOTIFICATION", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    private Connection initCon() throws NotificationManagerException {
        try {
            return DBUtil.makeConnection(JNDINames.DATABASE_DATASOURCE);
        }
        catch (Exception e) {
            throw new NotificationManagerException("SentNotificationInterfaceImpl.initCon()", 4, "root.EX_CONNECTION_OPEN_FAILED", e);
        }
    }
}

