/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationserver;

import com.stratelia.silverpeas.notificationserver.NotificationData;
import com.stratelia.silverpeas.notificationserver.NotificationServerException;
import com.stratelia.silverpeas.notificationserver.NotificationServerUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class NotificationServer {
    private String m_JmsFactory = JNDINames.JMS_FACTORY;
    private String m_JmsQueue = JNDINames.JMS_QUEUE;
    private String m_JmsHeaderChannel = JNDINames.JMS_HEADER_CHANNEL;
    private Map<String, String> m_JmsHeaders = new HashMap<String, String>();

    public long addNotification(NotificationData pData) throws NotificationServerException {
        long notificationid = 0L;
        this.m_JmsHeaders.clear();
        this.m_JmsHeaders.put(this.m_JmsHeaderChannel, pData.getTargetChannel());
        pData.setNotificationId(notificationid);
        String notificationAsXML = NotificationServerUtil.convertNotificationDataToXML(pData);
        try {
            NotificationServer.jmsSendToQueue(notificationAsXML, this.m_JmsFactory, this.m_JmsQueue, this.m_JmsHeaders);
        }
        catch (Exception e) {
            throw new NotificationServerException("NotificationServer.addNotification()", 4, "notificationServer.EX_CANT_SEND_TO_JSM_QUEUE", notificationAsXML, e);
        }
        return notificationid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void jmsSendToQueue(String notificationMessage, String jmsFactory, String jmsQueue, Map<String, String> p_JmsHeaders) throws JMSException, NamingException {
        QueueConnection qcon = null;
        QueueSession qsession = null;
        QueueSender qsender = null;
        try {
            InitialContext ic = new InitialContext();
            QueueConnectionFactory qconFactory = (QueueConnectionFactory)ic.lookup(jmsFactory);
            qcon = qconFactory.createQueueConnection();
            qsession = qcon.createQueueSession(false, 1);
            Queue queue = (Queue)ic.lookup(jmsQueue);
            qsender = qsession.createSender(queue);
            TextMessage textMsg = qsession.createTextMessage();
            qcon.start();
            textMsg.setText(notificationMessage);
            for (Map.Entry<String, String> entry : p_JmsHeaders.entrySet()) {
                textMsg.setStringProperty(entry.getKey(), entry.getValue());
            }
            qsender.send((Message)textMsg);
        }
        finally {
            try {
                if (qsender != null) {
                    qsender.close();
                }
            }
            finally {
                try {
                    if (qsession != null) {
                        qsession.close();
                    }
                }
                finally {
                    if (qcon != null) {
                        qcon.close();
                    }
                }
            }
        }
    }
}

