/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.notificationserver.xml;

import com.stratelia.silverpeas.notificationserver.NotificationData;
import com.stratelia.silverpeas.notificationserver.NotificationTag;
import com.stratelia.silverpeas.notificationserver.xml.AnswerAllowedContentHandler;
import com.stratelia.silverpeas.notificationserver.xml.SenderIdContentHandler;
import com.stratelia.silverpeas.notificationserver.xml.SenderNameContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SenderContentHandler
extends DefaultHandler {
    private NotificationData data;
    private ContentHandler parent;
    private XMLReader parser;

    public SenderContentHandler(NotificationData data, ContentHandler parent, XMLReader parser) {
        this.data = data;
        this.parent = parent;
        this.parser = parser;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        NotificationTag tag = NotificationTag.valueOf(qName);
        DefaultHandler child = null;
        switch (tag) {
            case NAME: {
                child = new SenderNameContentHandler(this.data, this, this.parser);
                break;
            }
            case ID: {
                child = new SenderIdContentHandler(this.data, this, this.parser);
                break;
            }
            case ANSWERALLOWED: {
                child = new AnswerAllowedContentHandler(this.data, this, this.parser);
            }
        }
        if (child != null) {
            this.parser.setContentHandler(child);
            child.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        NotificationTag tag = NotificationTag.valueOf(qName);
        if (tag == NotificationTag.SENDER) {
            this.parser.setContentHandler(this.parent);
        }
    }
}

