/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.silvertrace;

import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;

public enum SilverTraceLayout {
    LAYOUT_SHORT("%-5p : %m%n"),
    LAYOUT_HTML(""),
    LAYOUT_DETAILED("%d{dd/MM/yy-HH:mm:ss,SSS} - %-5p : %m%n"),
    LAYOUT_FULL_DEBUG("%-15.15r [%-26.26t] - %d{dd/MM/yy-HH:mm:ss,SSS} - %-5p : %m%n"),
    LAYOUT_SPY("%d{dd/MM/yy-HH:mm:ss,SSS} : %m%n"),
    LAYOUT_CUSTOM("%-5p : %m%n");

    private String pattern;

    private SilverTraceLayout(String pattern) {
        this.pattern = pattern;
    }

    public void updatePattern(String customPattern) {
        if (this == LAYOUT_CUSTOM) {
            this.pattern = customPattern;
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public static SilverTraceLayout findByPattern(String pattern) {
        if (LAYOUT_SHORT.getPattern().equals(pattern)) {
            return LAYOUT_SHORT;
        }
        if (LAYOUT_DETAILED.getPattern().equals(pattern)) {
            return LAYOUT_DETAILED;
        }
        if (LAYOUT_FULL_DEBUG.getPattern().equals(pattern)) {
            return LAYOUT_FULL_DEBUG;
        }
        if (LAYOUT_SPY.getPattern().equals(pattern)) {
            return LAYOUT_SPY;
        }
        return LAYOUT_CUSTOM;
    }

    public static Layout getLayout(String patternLayout) {
        SilverTraceLayout layout;
        try {
            layout = SilverTraceLayout.valueOf(patternLayout);
        }
        catch (IllegalArgumentException e) {
            LAYOUT_CUSTOM.updatePattern(patternLayout);
            layout = LAYOUT_CUSTOM;
        }
        return new PatternLayout(layout.getPattern());
    }

    public static SilverTraceLayout getSilverTraceLayout(String name) {
        SilverTraceLayout layout;
        try {
            layout = SilverTraceLayout.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            LAYOUT_CUSTOM.updatePattern(name);
            layout = LAYOUT_CUSTOM;
        }
        return layout;
    }
}

