/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.domains.DomainDriverFactory;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AbstractDomainDriver;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.DomainDriver;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.beans.admin.indexation.UserIndexation;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.DomainRow;
import com.stratelia.webactiv.organization.GroupRow;
import com.stratelia.webactiv.organization.KeyStoreRow;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.OrganizationSchemaPool;
import com.stratelia.webactiv.organization.UserRow;
import com.stratelia.webactiv.util.exception.UtilException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.admin.user.constant.UserState;
import org.silverpeas.search.indexEngine.model.FullIndexEntry;
import org.silverpeas.search.indexEngine.model.IndexEngineProxy;

public class DomainDriverManager
extends AbstractDomainDriver {
    private UserIndexation userIndexation = null;
    private OrganizationSchema organization = null;
    private Map<String, DomainDriver> domainDriverInstances = new ConcurrentHashMap<String, DomainDriver>();
    private boolean inTransaction = false;
    private int nbConnected = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOrganizationSchema() throws AdminException {
        DomainDriverManager domainDriverManager = this;
        synchronized (domainDriverManager) {
            if (this.getOrganization() == null) {
                try {
                    this.organization = OrganizationSchemaPool.getOrganizationSchema();
                    this.nbConnected = 0;
                }
                catch (AdminPersistenceException e) {
                    throw new AdminException("DomainDriverManager.getOrganizationSchema", 5, "admin.MSG_FATAL_GET_ORGANIZATION", e);
                }
            }
            ++this.nbConnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOrganizationSchema() throws AdminException {
        DomainDriverManager domainDriverManager = this;
        synchronized (domainDriverManager) {
            --this.nbConnected;
            if (this.getOrganization() != null && !this.inTransaction && this.nbConnected <= 0) {
                OrganizationSchemaPool.releaseOrganizationSchema(this.getOrganization());
                this.getOrganization().close();
                this.organization = null;
            }
        }
    }

    public String createUser(UserFull user) throws Exception {
        try {
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(user.getDomainId()));
            String sUserId = domainDriver.createUser(user);
            return sUserId;
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.createUser", 4, "admin.EX_ERR_ADD_USER", user.getFirstName() + " " + user.getLastName(), e);
        }
    }

    @Override
    public UserDetail[] getAllChangedUsers(String fromTimeStamp, String toTimeStamp) throws Exception {
        return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
    }

    @Override
    public Group[] getAllChangedGroups(String fromTimeStamp, String toTimeStamp) throws Exception {
        return ArrayUtil.EMPTY_GROUP_ARRAY;
    }

    @Override
    public UserDetail importUser(String userLogin) throws Exception {
        return null;
    }

    @Override
    public void removeUser(String userId) throws Exception {
    }

    @Override
    public UserDetail synchroUser(String userId) throws Exception {
        return null;
    }

    @Override
    public String createUser(UserDetail user) throws Exception {
        try {
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(user.getDomainId()));
            String sUserId = domainDriver.createUser(user);
            return sUserId;
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.createUser", 4, "admin.EX_ERR_ADD_USER", user.getFirstName() + " " + user.getLastName(), e);
        }
    }

    @Override
    public void deleteUser(String userId) throws Exception {
        try {
            this.getOrganizationSchema();
            UserRow ur = this.getOrganization().user.getUser(DomainDriverManager.idAsInt(userId));
            if (ur == null) {
                throw new AdminException("DomainDriverManager.deleteUser", 4, "admin.EX_ERR_USER_NOT_FOUND", "user Id: '" + userId + "'");
            }
            DomainDriver domainDriver = this.getDomainDriver(ur.domainId);
            domainDriver.deleteUser(ur.specificId);
            this.unindexUser(userId);
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.deleteUser", 4, "admin.EX_ERR_DELETE_USER", "user Id: '" + userId + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
    }

    @Override
    public void updateUserDetail(UserDetail user) throws Exception {
        try {
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(user.getDomainId()));
            domainDriver.updateUserDetail(user);
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.updateUser", 4, "admin.EX_ERR_UPDATE_USER", user.getFirstName() + " " + user.getLastName(), e);
        }
    }

    @Override
    public UserDetail getUser(String userId) throws Exception {
        return null;
    }

    @Override
    public void updateUserFull(UserFull user) throws Exception {
        try {
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(user.getDomainId()));
            domainDriver.updateUserFull(user);
            this.indexUser(user.getId());
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.updateUser", 4, "admin.EX_ERR_UPDATE_USER", user.getFirstName() + " " + user.getLastName(), e);
        }
    }

    public String[] getUserIdsOfDomain(String domainId) throws Exception {
        this.getOrganizationSchema();
        try {
            String[] stringArray = this.getOrganization().user.getUserIdsOfDomain(Integer.parseInt(domainId));
            return stringArray;
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.getUser", 4, "admin.EX_ERR_GET_USERS", "domainId = " + domainId, e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
    }

    private <T extends UserDetail> T loadUserEntity(String userId, Class<T> userModelClass) throws Exception {
        boolean isUserFull = userModelClass == UserFull.class;
        UserDetail userModel = null;
        try {
            this.getOrganizationSchema();
            UserRow ur = this.getOrganization().user.getUser(DomainDriverManager.idAsInt(userId));
            if (ur == null) {
                throw new AdminException("DomainDriverManager.getUser", 4, "admin.EX_ERR_USER_NOT_FOUND", "user Id: '" + userId + "'");
            }
            DomainDriver domainDriver = this.getDomainDriver(ur.domainId);
            try {
                userModel = isUserFull ? domainDriver.getUserFull(ur.specificId) : domainDriver.getUser(ur.specificId);
            }
            catch (AdminException e) {
                SilverTrace.error("admin", "DomainDriverManager.getUser", "admin.MSG_ERR_GET_USER", "user Id: '" + userId + "', domain Id: '" + ur.domainId + "'", e);
                userModel = isUserFull ? new UserFull(domainDriver) : new UserDetail();
                userModel.setFirstName(ur.firstName);
                userModel.setLastName(ur.lastName);
                userModel.seteMail(ur.eMail);
            }
            userModel.setLogin(ur.login);
            userModel.setId(userId);
            userModel.setSpecificId(ur.specificId);
            userModel.setDomainId(DomainDriverManager.idAsString(ur.domainId));
            userModel.setAccessLevel(UserAccessLevel.fromCode(ur.accessLevel));
            userModel.setCreationDate(ur.creationDate);
            userModel.setSaveDate(ur.saveDate);
            userModel.setVersion(ur.version);
            userModel.setTosAcceptanceDate(ur.tosAcceptanceDate);
            userModel.setLastLoginDate(ur.lastLoginDate);
            userModel.setNbSuccessfulLoginAttempts(ur.nbSuccessfulLoginAttempts);
            userModel.setLastLoginCredentialUpdateDate(ur.lastLoginCredentialUpdateDate);
            userModel.setExpirationDate(ur.expirationDate);
            userModel.setState(UserState.from(ur.state));
            userModel.setStateSaveDate(ur.stateSaveDate);
            userModel.setNotifManualReceiverLimit(ur.notifManualReceiverLimit);
            if (isUserFull) {
                userModel.setLoginQuestion(ur.loginQuestion);
                userModel.setLoginAnswer(ur.loginAnswer);
            }
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.getUser", 4, "admin.EX_ERR_GET_USER", "user Id: '" + userId + "', domain Id: '" + userId + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
        return (T)userModel;
    }

    @Override
    public UserFull getUserFull(String userId) throws Exception {
        return this.loadUserEntity(userId, UserFull.class);
    }

    public UserDetail getUserDetail(String userId) throws Exception {
        return this.loadUserEntity(userId, UserDetail.class);
    }

    @Override
    public String[] getUserMemberGroupIds(String userId) throws Exception {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public UserDetail[] getUsers(String[] userIds) throws Exception {
        UserDetail[] uds = new UserDetail[userIds.length];
        try {
            for (int nI = 0; nI < userIds.length; ++nI) {
                uds[nI] = this.getUser(userIds[nI]);
            }
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.getUsers", 4, "admin.EX_ERR_GET_USERS", e);
        }
        return uds;
    }

    @Override
    public UserDetail[] getAllUsers() throws Exception {
        return null;
    }

    @Override
    public UserDetail[] getUsersBySpecificProperty(String propertyName, String value) throws Exception {
        return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
    }

    @Override
    public UserDetail[] getUsersByQuery(Map<String, String> query) throws Exception {
        return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
    }

    @Override
    public Group importGroup(String groupName) throws Exception {
        return null;
    }

    @Override
    public void removeGroup(String groupId) throws Exception {
    }

    @Override
    public Group synchroGroup(String groupId) throws Exception {
        return null;
    }

    public UserDetail[] getAllUsers(String domainId) throws Exception {
        UserDetail[] uds = null;
        try {
            this.getOrganizationSchema();
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(domainId));
            uds = domainDriver.getAllUsers();
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.getAllUsers", 4, "admin.EX_ERR_GET_ALL_USERS", "domain Id: '" + domainId + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
        return uds;
    }

    public void indexAllUsers(String domainId) throws Exception {
        String[] userIds;
        for (String userId : userIds = this.getUserIdsOfDomain(domainId)) {
            this.indexUser(userId);
        }
    }

    public void indexUser(String userId) {
        this.getUserIndexation().indexUser(userId);
    }

    public void unindexUser(String userId) {
        this.getUserIndexation().unindexUser(userId);
    }

    @Override
    public String createGroup(Group group) throws Exception {
        Group specificGroup = new Group(group);
        try {
            if (StringUtil.isDefined(group.getSuperGroupId())) {
                GroupRow gr = this.getOrganization().group.getGroup(DomainDriverManager.idAsInt(group.getSuperGroupId()));
                if (gr == null) {
                    throw new AdminException("DomainDriverManager.createGroup", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group Id: '" + group.getSuperGroupId() + "'");
                }
                specificGroup.setSuperGroupId(gr.specificId);
            }
            specificGroup.setUserIds(this.translateUserIdsToSpecificIds(DomainDriverManager.idAsInt(group.getDomainId()), group.getUserIds()));
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(group.getDomainId()));
            return domainDriver.createGroup(specificGroup);
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.createGroup", 4, "admin.EX_ERR_UPDATE_GROUP", "group Id: '" + group.getId() + "'", e);
        }
    }

    @Override
    public void deleteGroup(String groupId) throws Exception {
        try {
            this.getOrganizationSchema();
            GroupRow gr = this.getOrganization().group.getGroup(DomainDriverManager.idAsInt(groupId));
            if (gr == null) {
                throw new AdminException("DomainDriverManager.deleteGroup", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group Id: '" + groupId + "'");
            }
            DomainDriver domainDriver = this.getDomainDriver(gr.domainId);
            domainDriver.deleteGroup(gr.specificId);
            this.unindexGroup(groupId);
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.deleteGroup", 4, "admin.EX_ERR_DELETE_GROUP", "group Id: '" + groupId + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
    }

    @Override
    public void updateGroup(Group group) throws Exception {
        Group specificGroup = new Group(group);
        try {
            GroupRow gr;
            if (StringUtil.isDefined(group.getSuperGroupId())) {
                gr = this.getOrganization().group.getGroup(DomainDriverManager.idAsInt(group.getSuperGroupId()));
                if (gr == null) {
                    throw new AdminException("DomainDriverManager.updateGroup", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group Id: '" + group.getSuperGroupId() + "'");
                }
                specificGroup.setSuperGroupId(gr.specificId);
            }
            specificGroup.setUserIds(this.translateUserIdsToSpecificIds(DomainDriverManager.idAsInt(group.getDomainId()), group.getUserIds()));
            gr = this.getOrganization().group.getGroup(DomainDriverManager.idAsInt(group.getId()));
            if (gr == null) {
                throw new AdminException("DomainDriverManager.updateGroup", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group Id: '" + group.getId() + "'");
            }
            DomainDriver domainDriver = this.getDomainDriver(gr.domainId);
            specificGroup.setId(gr.specificId);
            domainDriver.updateGroup(specificGroup);
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.updateGroup", 4, "admin.EX_ERR_UPDATE_GROUP", "group Id: '" + group.getId() + "'", e);
        }
    }

    @Override
    public Group getGroup(String groupId) throws Exception {
        Group group = null;
        try {
            this.getOrganizationSchema();
            GroupRow gr = this.getOrganization().group.getGroup(DomainDriverManager.idAsInt(groupId));
            if (gr == null) {
                throw new AdminException("DomainDriverManager.getGroup", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group Id: '" + groupId + "'");
            }
            DomainDriver domainDriver = this.getDomainDriver(gr.domainId);
            group = domainDriver.getGroup(gr.specificId);
            group.setId(groupId);
            group.setSpecificId(gr.specificId);
            group.setDomainId(DomainDriverManager.idAsString(gr.domainId));
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.getGroup", 4, "admin.EX_ERR_GET_GROUP", "group Id: '" + groupId + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
        return group;
    }

    @Override
    public Group getGroupByName(String groupName) throws Exception {
        return null;
    }

    public Group getGroupByNameInDomain(String groupName, String domainId) throws Exception {
        try {
            this.getOrganizationSchema();
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(domainId));
            Group group = domainDriver.getGroupByName(groupName);
            return group;
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.getGroupByNameInDomain", 4, "admin.EX_ERR_GET_GROUP", "group Name: '" + groupName + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
    }

    @Override
    public Group[] getGroups(String groupId) throws Exception {
        Group[] groups = null;
        try {
            this.getOrganizationSchema();
            GroupRow gr = this.getOrganization().group.getGroup(DomainDriverManager.idAsInt(groupId));
            if (gr == null) {
                throw new AdminException("DomainDriverManager.getGroups", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group Id: '" + groupId + "'");
            }
            DomainDriver domainDriver = this.getDomainDriver(gr.domainId);
            groups = domainDriver.getGroups(gr.specificId);
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.getGroups", 4, "admin.EX_ERR_GET_GROUPS", "father group Id: '" + groupId + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
        return groups;
    }

    @Override
    public Group[] getAllGroups() throws Exception {
        return null;
    }

    public Group[] getAllGroups(String domainId) throws Exception {
        Group[] groups = null;
        try {
            this.getOrganizationSchema();
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(domainId));
            groups = domainDriver.getAllGroups();
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.getAllGroups", 4, "admin.EX_ERR_GET_ALL_GROUPS", "domain Id: '" + domainId + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
        return groups;
    }

    @Override
    public Group[] getAllRootGroups() throws Exception {
        return null;
    }

    @Override
    public String[] getGroupMemberGroupIds(String groupId) throws Exception {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String[] getGroupMemberGroupIds(String domainId, String groupId) throws Exception {
        String[] groups = null;
        try {
            this.getOrganizationSchema();
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(domainId));
            groups = domainDriver.getGroupMemberGroupIds(groupId);
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.getAllRootGroups", 4, "admin.EX_ERR_GET_ALL_ROOT_GROUPS", "domain Id: '" + domainId + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
        return groups;
    }

    public Group[] getAllRootGroups(String domainId) throws Exception {
        Group[] groups = null;
        try {
            this.getOrganizationSchema();
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(domainId));
            groups = domainDriver.getAllRootGroups();
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.getAllRootGroups", 4, "admin.EX_ERR_GET_ALL_ROOT_GROUPS", "domain Id: '" + domainId + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
        return groups;
    }

    public GroupRow[] getAllGroupOfDomain(String domainId) throws Exception {
        try {
            this.getOrganizationSchema();
            GroupRow[] groupRowArray = this.getOrganization().group.getAllGroupsOfDomain(Integer.parseInt(domainId));
            return groupRowArray;
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.getGroupIdsOfDomain", 4, "admin.admin.MSG_ERR_GET_ALL_GROUPS", "domainId = " + domainId, e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
    }

    public void indexAllGroups(String domainId) throws Exception {
        GroupRow[] tabGroup;
        for (GroupRow group : tabGroup = this.getAllGroupOfDomain(domainId)) {
            this.indexGroup(group);
        }
    }

    public void indexGroup(GroupRow group) {
        FullIndexEntry indexEntry = new FullIndexEntry("groups", "GroupRow", Integer.toString(group.id));
        indexEntry.setLastModificationDate(new Date());
        indexEntry.setTitle(group.name);
        indexEntry.setPreView(group.description);
        indexEntry.addField("DomainId", Integer.toString(group.domainId));
        indexEntry.addField("SpecificId", group.specificId);
        indexEntry.addField("SuperGroupId", Integer.toString(group.superGroupId));
        indexEntry.addField("SynchroRule", group.rule);
        IndexEngineProxy.addIndexEntry(indexEntry);
    }

    public void unindexGroup(String groupId) {
        FullIndexEntry indexEntry = new FullIndexEntry("groups", "GroupRow", groupId);
        IndexEngineProxy.removeIndexEntry(indexEntry.getPK());
    }

    public Map<String, String> authenticate(String sKey) throws Exception {
        return this.authenticate(sKey, true);
    }

    public Map<String, String> authenticate(String sKey, boolean removeKey) throws Exception {
        HashMap<String, String> loginDomainId = new HashMap<String, String>();
        try {
            this.startTransaction(false);
            KeyStoreRow ksr = this.getOrganization().keyStore.getRecordByKey(DomainDriverManager.idAsInt(sKey));
            if (ksr == null) {
                throw new AdminException("DomainDriverManager.authenticate", 4, "admin.EX_ERR_KEY_NOT_FOUND", "key: '" + sKey + "'");
            }
            loginDomainId.put("login", ksr.login);
            loginDomainId.put("domainId", DomainDriverManager.idAsString(ksr.domainId));
            if (removeKey) {
                this.getOrganization().keyStore.removeKeyStoreRecord(DomainDriverManager.idAsInt(sKey));
            }
            this.commit();
            HashMap<String, String> hashMap = loginDomainId;
            return hashMap;
        }
        catch (AdminPersistenceException e) {
            try {
                this.rollback();
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "DomainDriverManager.authenticate", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("DomainDriverManager.authenticate", 4, "admin.EX_ERR_AUTHENTICATE", "key: '" + sKey + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
    }

    public Domain[] getAllDomains() throws AdminException {
        Domain[] valret = null;
        try {
            this.getOrganizationSchema();
            DomainRow[] drs = this.getOrganization().domain.getAllDomains();
            if (drs == null || drs.length <= 0) {
                throw new AdminException("DomainDriverManager.getAllDomains", 4, "admin.EX_ERR_NO_DOMAIN_FOUND");
            }
            valret = new Domain[drs.length];
            for (int i = 0; i < drs.length; ++i) {
                valret[i] = new Domain();
                valret[i].setId(Integer.toString(drs[i].id));
                valret[i].setName(drs[i].name);
                valret[i].setDescription(drs[i].description);
                valret[i].setDriverClassName(drs[i].className);
                valret[i].setPropFileName(drs[i].propFileName);
                valret[i].setAuthenticationServer(drs[i].authenticationServer);
                valret[i].setTheTimeStamp(drs[i].theTimeStamp);
            }
        }
        catch (AdminPersistenceException e) {
            throw new AdminException("DomainDriverManager.getAllDomains", 4, "admin.EX_ERR_GET_ALL_DOMAINS", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
        return valret;
    }

    public long getDomainActions(String domainId) throws Exception {
        return this.getDomainDriver(DomainDriverManager.idAsInt(domainId)).getDriverActions();
    }

    public String getNextDomainId() throws Exception {
        try {
            this.startTransaction(false);
            int domainId = this.getOrganization().domain.getNextId();
            this.commit();
            String string = DomainDriverManager.idAsString(domainId);
            return string;
        }
        catch (AdminException e) {
            try {
                this.rollback();
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "DomainDriverManager.getNextDomainId", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("DomainDriverManager.getNextDomainId", 4, "admin.EX_ERR_ADD_DOMAIN", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
    }

    public String createDomain(Domain theDomain) throws Exception {
        try {
            this.startTransaction(false);
            DomainRow dr = new DomainRow();
            dr.id = StringUtil.isInteger(theDomain.getId()) ? Integer.valueOf(theDomain.getId()) : -1;
            dr.name = theDomain.getName();
            dr.description = theDomain.getDescription();
            dr.className = theDomain.getDriverClassName();
            dr.propFileName = theDomain.getPropFileName();
            dr.authenticationServer = theDomain.getAuthenticationServer();
            dr.theTimeStamp = theDomain.getTheTimeStamp();
            dr.silverpeasServerURL = theDomain.getSilverpeasServerURL();
            this.getOrganization().domain.createDomain(dr);
            this.commit();
            String string = DomainDriverManager.idAsString(dr.id);
            return string;
        }
        catch (AdminException e) {
            try {
                this.rollback();
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "DomainDriverManager.createDomain", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("DomainDriverManager.createDomain", 4, "admin.EX_ERR_ADD_DOMAIN", "domain name: '" + theDomain.getName() + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
    }

    public String updateDomain(Domain theDomain) throws Exception {
        try {
            this.startTransaction(false);
            DomainRow dr = new DomainRow();
            dr.id = DomainDriverManager.idAsInt(theDomain.getId());
            dr.name = theDomain.getName();
            dr.description = theDomain.getDescription();
            dr.className = theDomain.getDriverClassName();
            dr.propFileName = theDomain.getPropFileName();
            dr.authenticationServer = theDomain.getAuthenticationServer();
            dr.theTimeStamp = theDomain.getTheTimeStamp();
            dr.silverpeasServerURL = theDomain.getSilverpeasServerURL();
            this.getOrganization().domain.updateDomain(dr);
            if (this.domainDriverInstances.get(theDomain.getId()) != null) {
                this.domainDriverInstances.remove(theDomain.getId());
            }
            this.commit();
            String string = theDomain.getId();
            return string;
        }
        catch (AdminException e) {
            try {
                this.rollback();
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "DomainDriverManager.updateDomain", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("DomainDriverManager.updateDomain", 4, "admin.EX_ERR_ADD_DOMAIN", "domain name: '" + theDomain.getName() + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
    }

    public String removeDomain(String domainId) throws Exception {
        try {
            this.startTransaction(false);
            this.getOrganization().domain.removeDomain(DomainDriverManager.idAsInt(domainId));
            if (this.domainDriverInstances.get(domainId) != null) {
                this.domainDriverInstances.remove(domainId);
            }
            this.commit();
            String string = domainId;
            return string;
        }
        catch (AdminException e) {
            try {
                this.rollback();
            }
            catch (Exception e1) {
                SilverTrace.error("admin", "DomainDriverManager.createDomain", "root.EX_ERR_ROLLBACK", e1);
            }
            throw new AdminException("DomainDriverManager.createDomain", 4, "admin.EX_ERR_ADD_DOMAIN", "domain id: '" + domainId + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
    }

    public Domain getDomain(String domainId) throws Exception {
        Domain valret = null;
        try {
            this.getOrganizationSchema();
            DomainRow dr = this.getOrganization().domain.getDomain(DomainDriverManager.idAsInt(domainId));
            if (dr == null) {
                throw new AdminException("DomainDriverManager.getDomain", 4, "admin.EX_ERR_DOMAIN_NOT_FOUND", "domain Id: '" + domainId + "'");
            }
            valret = new Domain();
            valret.setId(Integer.toString(dr.id));
            valret.setName(dr.name);
            valret.setDescription(dr.description);
            valret.setDriverClassName(dr.className);
            valret.setPropFileName(dr.propFileName);
            valret.setAuthenticationServer(dr.authenticationServer);
            valret.setTheTimeStamp(dr.theTimeStamp);
            valret.setSilverpeasServerURL(dr.silverpeasServerURL);
        }
        catch (AdminPersistenceException e) {
            throw new AdminException("DomainDriverManager.getDomain", 4, "admin.EX_ERR_GET_DOMAIN", "domain id: '" + domainId + "'", e);
        }
        finally {
            this.releaseOrganizationSchema();
        }
        return valret;
    }

    public DomainDriver getDomainDriver(int domainId) throws Exception {
        DomainDriver domainDriver;
        block11: {
            domainDriver = null;
            boolean osAllocated = false;
            try {
                domainDriver = this.domainDriverInstances.get(DomainDriverManager.idAsString(domainId));
                if (domainDriver != null) break block11;
                this.getOrganizationSchema();
                osAllocated = true;
                DomainRow dr = this.getOrganization().domain.getDomain(domainId);
                if (dr == null) {
                    throw new AdminException("DomainDriverManager.getDomainDriver", 4, "admin.EX_ERR_DOMAIN_NOT_FOUND", "domain Id: '" + domainId + "'");
                }
                try {
                    domainDriver = DomainDriverFactory.getDriver(dr.className);
                    domainDriver.init(domainId, dr.propFileName, dr.authenticationServer);
                }
                catch (ClassNotFoundException e) {
                    throw new AdminException("DomainDriverManager.getDomainDriver", 4, "root.EX_CLASS_NOT_FOUND", e);
                }
                catch (IllegalAccessException e) {
                    throw new AdminException("DomainDriverManager.getDomainDriver", 4, "root.EX_ILLEGAL_ACCESS", e);
                }
                catch (InstantiationException e) {
                    throw new AdminException("DomainDriverManager.getDomainDriver", 4, "root.EX_INSTANTIATION", e);
                }
                this.domainDriverInstances.put(DomainDriverManager.idAsString(domainId), domainDriver);
            }
            catch (AdminPersistenceException e) {
                throw new AdminException("DomainDriverManager.getDomainDriver", 4, "admin.EX_ERR_GET_DOMAIN_DRIVER", "domain id: '" + domainId + "'", e);
            }
            finally {
                if (osAllocated) {
                    this.releaseOrganizationSchema();
                }
            }
        }
        return domainDriver;
    }

    public void beginSynchronization(String sdomainId) throws Exception {
        DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(sdomainId));
        domainDriver.beginSynchronization();
    }

    public String endSynchronization(String sdomainId, boolean cancelSynchro) throws Exception {
        DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(sdomainId));
        return domainDriver.endSynchronization(cancelSynchro);
    }

    @Override
    public void startTransaction(boolean bAutoCommit) {
        try {
            this.getOrganizationSchema();
            this.inTransaction = !bAutoCommit;
        }
        catch (AdminException ex) {
            throw new UtilException("DomainDriverManager", "startTransaction", ex);
        }
    }

    @Override
    public void commit() throws Exception {
        try {
            this.inTransaction = false;
            this.getOrganization().commit();
        }
        catch (Exception e) {
            throw new AdminException("DomainDriverManager.commit", 4, "root.EX_ERR_COMMIT", e);
        }
    }

    @Override
    public void rollback() throws Exception {
        try {
            this.inTransaction = false;
            this.getOrganization().rollback();
        }
        catch (Exception e) {
            throw new AdminException("DomainDriverManager.rollback", 4, "root.EX_ERR_ROLLBACK", e);
        }
    }

    public void startTransaction(String domainId, boolean bAutoCommit) throws Exception {
        try {
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(domainId));
            domainDriver.startTransaction(bAutoCommit);
        }
        catch (Exception e) {
            throw new AdminException("DomainDriverManager.startTransaction", 4, "admin.EX_ERR_START_TRANSACTION", "domain Id: '" + domainId + "'", e);
        }
    }

    public void commit(String domainId) throws Exception {
        try {
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(domainId));
            domainDriver.commit();
        }
        catch (Exception e) {
            throw new AdminException("DomainDriverManager.commit", 4, "root.EX_ERR_COMMIT", "domain Id: '" + domainId + "'", e);
        }
    }

    public void rollback(String domainId) throws Exception {
        try {
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(domainId));
            domainDriver.rollback();
        }
        catch (Exception e) {
            throw new AdminException("DomainDriverManager.rollback", 4, "root.EX_ERR_ROLLBACK", "domain Id: '" + domainId + "'", e);
        }
    }

    protected String[] translateUserIdsToSpecificIds(int domainId, String[] ids) {
        ArrayList<String> specificIds = new ArrayList<String>();
        if (ids == null) {
            return null;
        }
        for (String id : ids) {
            try {
                UserRow ur = this.getOrganization().user.getUser(DomainDriverManager.idAsInt(id));
                if (ur == null || ur.domainId != domainId) continue;
                specificIds.add(ur.specificId);
            }
            catch (Exception e) {
                SilverTrace.error("admin", "DomainDriverManager.getUser", "admin.MSG_ERR_GET_USER", "user Id: '" + id + "'", e);
            }
        }
        return specificIds.toArray(new String[specificIds.size()]);
    }

    @Override
    public List<String> getUserAttributes() throws Exception {
        return null;
    }

    public OrganizationSchema getOrganization() {
        return this.organization;
    }

    private UserIndexation getUserIndexation() {
        if (this.userIndexation == null) {
            this.userIndexation = new UserIndexation();
        }
        return this.userIndexation;
    }

    @Override
    public void resetPassword(UserDetail user, String password) throws Exception {
        try {
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(user.getDomainId()));
            domainDriver.resetPassword(user, password);
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.resetPassword", 4, "admin.EX_ERR_UPDATE_USER", "userId : " + user.getId(), e);
        }
    }

    @Override
    public void resetEncryptedPassword(UserDetail user, String encryptedPassword) throws Exception {
        try {
            DomainDriver domainDriver = this.getDomainDriver(DomainDriverManager.idAsInt(user.getDomainId()));
            domainDriver.resetEncryptedPassword(user, encryptedPassword);
        }
        catch (AdminException e) {
            throw new AdminException("DomainDriverManager.resetEncryptedPassword", 4, "admin.EX_ERR_UPDATE_USER", "userId : " + user.getId(), e);
        }
    }
}

