/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerFactory;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminReference;
import java.util.ArrayList;
import java.util.List;

public class SynchroDomainScheduler
implements SchedulerEventListener {
    public static final String ADMINSYNCHRODOMAIN_JOB_NAME = "AdminSynchroDomainJob";
    private List<String> domainIds = null;

    public void initialize(String cron, List<String> domainIds) {
        try {
            this.domainIds = domainIds;
            SchedulerFactory schedulerFactory = SchedulerFactory.getFactory();
            Scheduler scheduler = schedulerFactory.getScheduler();
            scheduler.unscheduleJob(ADMINSYNCHRODOMAIN_JOB_NAME);
            JobTrigger trigger = JobTrigger.triggerAt(cron);
            scheduler.scheduleJob(ADMINSYNCHRODOMAIN_JOB_NAME, trigger, (SchedulerEventListener)this);
        }
        catch (Exception e) {
            SilverTrace.error("admin", "SynchroDomainScheduler.initialize()", "admin.CANT_INIT_DOMAINS_SYNCHRO", e);
        }
    }

    public void addDomain(String id) {
        if (this.domainIds == null) {
            this.domainIds = new ArrayList<String>();
        }
        this.domainIds.add(id);
    }

    public void removeDomain(String id) {
        if (this.domainIds != null) {
            this.domainIds.remove(id);
        }
    }

    public void doSynchro() {
        SilverTrace.info("admin", "SynchroDomainScheduler.doSynchro()", "root.MSG_GEN_ENTER_METHOD");
        if (this.domainIds != null) {
            for (String domainId : this.domainIds) {
                try {
                    AdminReference.getAdminService().synchronizeSilverpeasWithDomain(domainId, true);
                }
                catch (Exception e) {
                    SilverTrace.error("admin", "SynchroDomainScheduler.doSynchro()", "admin.MSG_ERR_SYNCHRONIZE_DOMAIN", e);
                }
            }
        }
        SilverTrace.info("admin", "SynchroDomainScheduler.doSynchro()", "root.MSG_GEN_EXIT_METHOD");
    }

    @Override
    public void triggerFired(SchedulerEvent anEvent) {
        String jobName = anEvent.getJobExecutionContext().getJobName();
        SilverTrace.debug("admin", "SynchroDomainScheduler.triggerFired()", "The job '" + jobName + "' is executed");
        this.doSynchro();
    }

    @Override
    public void jobSucceeded(SchedulerEvent anEvent) {
        String jobName = anEvent.getJobExecutionContext().getJobName();
        SilverTrace.debug("admin", "SynchroDomainScheduler.jobSucceeded()", "The job '" + jobName + "' was successfull");
    }

    @Override
    public void jobFailed(SchedulerEvent anEvent) {
        String jobName = anEvent.getJobExecutionContext().getJobName();
        SilverTrace.error("admin", "SynchroDomainScheduler.jobFailed", "The job '" + jobName + "' was not successfull");
    }
}

