/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin;

import com.silverpeas.notification.delayed.delegate.DelayedNotificationDelegate;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.security.X509Factory;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.DomainDriverManager;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.beans.admin.dao.SpaceDAO;
import com.stratelia.webactiv.beans.admin.dao.UserDAO;
import com.stratelia.webactiv.beans.admin.dao.UserSearchCriteriaForDAO;
import com.stratelia.webactiv.organization.UserRow;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.admin.user.constant.UserState;
import org.silverpeas.util.ListSlice;

public class UserManager {
    private static UserManager instance = new UserManager();
    private final UserDAO userDAO = new UserDAO();

    public static UserManager get() {
        return instance;
    }

    private UserManager() {
    }

    public List<String> getDomainsOfUser(String login) throws AdminException {
        Connection connection = null;
        try {
            connection = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<String> list = this.userDAO.getDomainsContainingLogin(connection, login);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getDomainsOfUser", 4, "Couldn't obtain the list of domains for login: " + login, e);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    public int getUsersNumberOfDomain(DomainDriverManager ddManager, String domainId) throws AdminException {
        try {
            SilverTrace.info("admin", "UserManager.getUsersNumberOfDomain()", "root.MSG_GEN_ENTER_METHOD");
            ddManager.getOrganizationSchema();
            int n = ddManager.getOrganization().user.getUserNumberOfDomain(this.idAsInt(domainId));
            return n;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getUsersNumberOfDomain()", 4, "admin.EX_ERR_GET_USERSET_NUMBER", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public int getUserNumber(DomainDriverManager ddManager) throws AdminException {
        try {
            SilverTrace.info("admin", "UserManager.getUserNumber()", "root.MSG_GEN_ENTER_METHOD");
            ddManager.getOrganizationSchema();
            int n = ddManager.getOrganization().user.getUserNumber();
            return n;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getUserNumber()", 4, "admin.EX_ERR_GET_USERSET_NUMBER", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public UserDetail[] getAllUsersOfGroups(List<String> groupIds) throws AdminException {
        if (groupIds == null || groupIds.isEmpty()) {
            return ArrayUtil.EMPTY_USER_DETAIL_ARRAY;
        }
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<UserDetail> users = this.userDAO.getUsersOfGroups(con, groupIds);
            UserDetail[] userDetailArray = users.toArray(new UserDetail[users.size()]);
            return userDetailArray;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getAllUsersOfGroups", 4, "admin.EX_ERR_GET_USER_GROUPS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public ListSlice<UserDetail> getUsersMatchingCriteria(UserSearchCriteriaForDAO criteria) throws AdminException {
        Connection connection = null;
        try {
            connection = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            ListSlice<UserDetail> listSlice = this.userDAO.getUsersByCriteria(connection, criteria);
            return listSlice;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getAllUsersMatching", 4, "admin.EX_ERR_GET_USER_GROUPS", e);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    public List<String> getAllUserIdsOfGroups(List<String> groupIds) throws AdminException {
        if (groupIds == null || groupIds.isEmpty()) {
            return new ArrayList<String>(0);
        }
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<String> list = this.userDAO.getUserIdsOfGroups(con, groupIds);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getAllUsersOfGroups", 4, "admin.EX_ERR_GET_USER_GROUPS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public UserDetail[] getUsersOfDomain(DomainDriverManager ddManager, String sDomainId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            SynchroReport.info("UserManager.getUsersOfDomain()", "Recherche des utilisateurs du domaine LDAP dans la base...", null);
            UserRow[] urs = ddManager.getOrganization().user.getAllUserOfDomain(this.idAsInt(sDomainId));
            UserDetail[] aus = new UserDetail[urs.length];
            for (int nI = 0; nI < urs.length; ++nI) {
                aus[nI] = this.userRow2UserDetail(urs[nI]);
                SynchroReport.debug("UserManager.getUsersOfDomain()", "Utilisateur trouv\u00e9 no : " + Integer.toString(nI) + ", login : " + aus[nI].getLogin() + ", " + aus[nI].getFirstName() + ", " + aus[nI].getLastName() + ", " + aus[nI].geteMail(), null);
            }
            SynchroReport.info("UserManager.getUsersOfDomain()", "R\u00e9cup\u00e9ration de " + urs.length + " utilisateurs du domaine LDAP dans la base", null);
            UserDetail[] userDetailArray = aus;
            return userDetailArray;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getUsersOfDomain", 4, "admin.EX_ERR_GET_USERS_OF_DOMAIN", "domain Id: '" + sDomainId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getUserIdsOfDomain(DomainDriverManager ddManager, String sDomainId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] uids = ddManager.getOrganization().user.getUserIdsOfDomain(this.idAsInt(sDomainId));
            if (uids != null) {
                String[] stringArray = uids;
                return stringArray;
            }
            String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getUserIdsOfDomain", 4, "admin.EX_ERR_GET_USERS_OF_DOMAIN", "domain Id: '" + sDomainId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getUserIdsOfDomainAndAccessLevel(DomainDriverManager ddManager, String sDomainId, UserAccessLevel accessLevel) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] uids = ddManager.getOrganization().user.getUserIdsOfDomainByAccessLevel(this.idAsInt(sDomainId), accessLevel);
            if (uids != null) {
                String[] stringArray = uids;
                return stringArray;
            }
            String[] stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getUserIdsOfDomain", 4, "admin.EX_ERR_GET_USERS_OF_DOMAIN_BY_ACCESSLEVEL", "domain Id: " + sDomainId + ", AccessLevel = " + (Object)((Object)accessLevel), e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getManageableSpaceIds(String sUserId, List<String> groupIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<String> spaceIds = SpaceDAO.getManageableSpaceIds(con, sUserId, groupIds);
            String[] stringArray = spaceIds.toArray(new String[spaceIds.size()]);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getManageableSpaceIds", 4, "admin.EX_ERR_GET_USER_MANAGEABLE_SPACE_IDS", "user Id: '" + sUserId + "'", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public String[] getAllUsersIds(DomainDriverManager ddManager) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] stringArray = ddManager.getOrganization().user.getAllUserIds();
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getAllUsersIds", 4, "admin.EX_ERR_GET_ALL_USER_IDS", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] getAllAdminIds(DomainDriverManager ddManager, UserDetail fromUser) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            String[] stringArray = ddManager.getOrganization().user.getAllAdminIds(fromUser);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getAllAdminIds", 4, "admin.EX_ERR_GET_ALL_ADMIN_IDS", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public UserFull getUserFull(DomainDriverManager ddManager, String sUserId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            UserFull userFull = ddManager.getUserFull(sUserId);
            return userFull;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getUserFull", 4, "admin.EX_ERR_GET_USER_DETAIL", "user Id: '" + sUserId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public UserDetail getUserDetail(DomainDriverManager ddManager, String sUserId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            UserRow ur = ddManager.getOrganization().user.getUser(this.idAsInt(sUserId));
            UserDetail userDetail = this.userRow2UserDetail(ur);
            return userDetail;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getUser", 4, "admin.EX_ERR_GET_USER", "user Id: '" + sUserId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String getUserIdBySpecificIdAndDomainId(DomainDriverManager ddManager, String sSpecificId, String sDomainId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            UserRow ur = ddManager.getOrganization().user.getUserBySpecificId(this.idAsInt(sDomainId), sSpecificId);
            String string = this.idAsString(ur.id);
            return string;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getUserIdBySpecificIdAndDomainId", 4, "admin.EX_ERR_GET_USER_BY_LOGIN_DOMAIN", "user sSpecificId: '" + sSpecificId + "', domain Id: '" + sDomainId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String getUserIdByLoginAndDomain(DomainDriverManager ddManager, String sLogin, String sDomainId) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            UserRow ur = ddManager.getOrganization().user.getUserByLogin(this.idAsInt(sDomainId), sLogin);
            String string = this.idAsString(ur.id);
            return string;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getUserIdByLoginAndDomain", 4, "admin.EX_ERR_GET_USER_BY_LOGIN_DOMAIN", "user login: '" + sLogin + "', domain Id: '" + sDomainId + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public UserDetail[] searchUsers(DomainDriverManager ddManager, UserDetail modelUser, boolean isAnd) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            UserRow model = this.userDetail2UserRow(modelUser);
            if (!StringUtil.isDefined(modelUser.getId())) {
                model.id = -2;
            }
            if (!StringUtil.isDefined(modelUser.getDomainId())) {
                model.domainId = -2;
            }
            UserRow[] urs = ddManager.getOrganization().user.searchUsers(model, isAnd);
            UserDetail[] aus = new UserDetail[urs.length];
            for (int nI = 0; nI < urs.length; ++nI) {
                aus[nI] = this.userRow2UserDetail(urs[nI]);
            }
            UserDetail[] nI = aus;
            return nI;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.searchUsers", 4, "admin.EX_ERR_GET_USERS_OF_DOMAIN", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String[] searchUsersIds(DomainDriverManager ddManager, List<String> userIds, UserDetail modelUser) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            UserRow model = this.userDetail2UserRow(modelUser);
            if (!StringUtil.isDefined(modelUser.getId())) {
                model.id = -2;
            }
            if (!StringUtil.isDefined(modelUser.getDomainId())) {
                model.domainId = -2;
            }
            String[] stringArray = ddManager.getOrganization().user.searchUsersIds(userIds, model);
            return stringArray;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.searchUsersIds", 4, "admin.EX_ERR_GET_USERS", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public void migrateUser(DomainDriverManager ddManager, UserDetail userDetail, String targetDomainId) throws AdminException {
        if (userDetail == null || !StringUtil.isDefined(userDetail.getDomainId())) {
            throw new AdminException("UserManager.migrateUser", 4, "admin.EX_MIGRATE_USER", "User detail : " + userDetail);
        }
        try {
            ddManager.getOrganizationSchema();
            String oldDomainId = userDetail.getDomainId();
            UserFull userFull = this.getUserFull(ddManager, userDetail.getId());
            userFull.setDomainId(targetDomainId);
            String specificId = ddManager.createUser(userFull);
            userFull.setSpecificId(specificId);
            userDetail.setDomainId(targetDomainId);
            userDetail.setSpecificId(specificId);
            ddManager.resetEncryptedPassword(userDetail, userFull.getPassword());
            userFull.setDomainId(oldDomainId);
            ddManager.deleteUser(userFull.getId());
            userFull.setDomainId(targetDomainId);
            userFull.setSpecificId(specificId);
            this.updateUser(ddManager, userFull);
        }
        catch (Exception e) {
            throw new AdminException("UserManager.migrateUser", 4, "admin.EX_ERR_MIGRATE_USER", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String addUser(DomainDriverManager ddManager, UserDetail userDetail, boolean addOnlyInSilverpeas) throws AdminException {
        if (!(userDetail != null && StringUtil.isDefined(userDetail.getLastName()) && StringUtil.isDefined(userDetail.getLogin()) && StringUtil.isDefined(userDetail.getDomainId()))) {
            if (userDetail == null) {
                SynchroReport.error("UserManager.addUser()", "Probl\u00e8me lors de l'ajout de l'utilisateur dans la base, cet utilisateurn'existe pas", null);
            } else if (!StringUtil.isDefined(userDetail.getLastName())) {
                SynchroReport.error("UserManager.addUser()", "Probl\u00e8me lors de l'ajout de l'utilisateur " + userDetail.getSpecificId() + " dans la base, cet utilisateur n'a pas de nom", null);
            } else if (!StringUtil.isDefined(userDetail.getLogin())) {
                SynchroReport.error("UserManager.addUser()", "Probl\u00e8me lors de l'ajout de l'utilisateur " + userDetail.getSpecificId() + " dans la base, login non sp\u00e9cifi\u00e9", null);
            } else if (!StringUtil.isDefined(userDetail.getDomainId())) {
                SynchroReport.error("UserManager.addUser()", "Probl\u00e8me lors de l'ajout de l'utilisateur " + userDetail.getSpecificId() + " dans la base, domaine non sp\u00e9cifi\u00e9", null);
            }
            return "";
        }
        try {
            boolean isX509Enabled;
            ddManager.getOrganizationSchema();
            SynchroReport.info("UserManager.addUser()", "Ajout de l'utilisateur " + userDetail.getSpecificId() + " dans la base...", null);
            UserRow ur = ddManager.getOrganization().user.getUserByLogin(this.idAsInt(userDetail.getDomainId()), userDetail.getLogin());
            if (ur != null) {
                SynchroReport.error("UserManager.addUser()", "Utilisateur " + userDetail.getLogin() + " d\u00e9j\u00e0 pr\u00e9sent dans la base avec ce login. Il n'a pas \u00e9t\u00e9 rajout\u00e9", null);
                throw new AdminException("UserManager.addUser", 4, "admin.EX_ERR_LOGIN_ALREADY_USED", "user login: '" + userDetail.getLogin() + "'");
            }
            if (!addOnlyInSilverpeas) {
                String specificId = ddManager.createUser(userDetail);
                userDetail.setSpecificId(specificId);
            }
            ur = this.userDetail2UserRow(userDetail);
            ddManager.getOrganization().user.createUser(ur);
            String sUserId = this.idAsString(ur.id);
            ddManager.indexUser(sUserId);
            long domainActions = ddManager.getDomainActions(userDetail.getDomainId());
            boolean bl = isX509Enabled = (domainActions & 0x8000L) != 0L;
            if (isX509Enabled) {
                X509Factory.buildP12(sUserId, userDetail.getLogin(), userDetail.getLastName(), userDetail.getFirstName(), userDetail.getDomainId());
            }
            String string = sUserId;
            return string;
        }
        catch (Exception e) {
            SynchroReport.error("UserManager.addUser()", "probl\u00e8me \u00e0 l'ajout de l'utilisateur " + userDetail.getFirstName() + " " + userDetail.getLastName() + "(specificId:" + userDetail.getSpecificId() + ") - " + e.getMessage(), null);
            throw new AdminException("UserManager.addUser", 4, "admin.EX_ERR_ADD_USER", "user login: '" + userDetail.getLogin() + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String deleteUser(DomainDriverManager ddManager, UserDetail user, boolean onlyInSilverpeas) throws AdminException {
        try {
            boolean isX509Enabled;
            ddManager.getOrganizationSchema();
            try {
                DelayedNotificationDelegate.executeUserDeleting(Integer.valueOf(user.getId()));
            }
            catch (Exception e) {
                SynchroReport.warn("UserManager.deleteUser()", "probl\u00e8me d'envoi des notifications journalis\u00e9es " + user.getFirstName() + " " + user.getLastName() + "(specificId:" + user.getSpecificId() + ") - " + e.getMessage(), null);
            }
            if (!onlyInSilverpeas) {
                ddManager.deleteUser(user.getId());
            }
            SynchroReport.info("UserManager.deleteUser()", "Suppression de l'utilisateur " + user.getSpecificId() + " de la base...", null);
            ddManager.getOrganization().user.removeUser(this.idAsInt(user.getId()));
            ddManager.unindexUser(user.getId());
            long domainActions = ddManager.getDomainActions(user.getDomainId());
            boolean bl = isX509Enabled = (domainActions & 0x8000L) != 0L;
            if (isX509Enabled) {
                X509Factory.revocateUserCertificate(user.getId());
            }
            String string = user.getId();
            return string;
        }
        catch (Exception e) {
            SynchroReport.error("UserManager.deleteUser()", "probl\u00e8me \u00e0 la suppression de l'utilisateur " + user.getFirstName() + " " + user.getLastName() + "(specificId:" + user.getSpecificId() + ") - " + e.getMessage(), null);
            throw new AdminException("UserManager.deleteUser", 4, "admin.EX_ERR_DELETE_USER", "user id: '" + user.getId() + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String updateUser(DomainDriverManager ddManager, UserDetail user) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            UserRow ur = this.userDetail2UserRow(user);
            SynchroReport.info("UserManager.updateUser()", "Maj de l'utilisateur " + user.getSpecificId() + " dans la base...", null);
            ddManager.getOrganization().user.updateUser(ur);
            ddManager.indexUser(user.getId());
            String string = user.getId();
            return string;
        }
        catch (Exception e) {
            SynchroReport.error("UserManager.updateUser()", "probl\u00e8me lors de la maj de l'utilisateur " + user.getFirstName() + " " + user.getLastName() + "(specificId:" + user.getSpecificId() + ") - " + e.getMessage(), null);
            throw new AdminException("UserManager.updateUser", 4, "admin.EX_ERR_UPDATE_USER", "user id: '" + user.getId() + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public String updateUserFull(DomainDriverManager ddManager, UserFull userFull) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            ddManager.updateUserFull(userFull);
            UserRow ur = this.userDetail2UserRow(userFull);
            ddManager.getOrganization().user.updateUser(ur);
            String string = userFull.getId();
            return string;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.updateUserDetail", 4, "admin.EX_ERR_UPDATE_USER_DETAIL", "user id: '" + userFull.getId() + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public boolean isEmailExisting(DomainDriverManager ddManager, String email) throws AdminException {
        try {
            ddManager.getOrganizationSchema();
            UserRow[] users = ddManager.getOrganization().user.getUsersByEmail(email);
            boolean bl = users != null && users.length > 0;
            return bl;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.isEmailExisting", 4, "admin.CANT_CHECK_EMAIL", "email: '" + email + "'", e);
        }
        finally {
            ddManager.releaseOrganizationSchema();
        }
    }

    public List<UserDetail> getAllUsers() throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<UserDetail> list = this.userDAO.getAllUsers(con);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getAllUsers", 4, "admin.MSG_ERR_GET_ALL_USERS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public List<UserDetail> getAllUsersFromNewestToOldest() throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<UserDetail> list = this.userDAO.getAllUsersFromNewestToOldest(con);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getAllUsersFromNewestToOldest", 4, "admin.MSG_ERR_GET_ALL_USERS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public List<UserDetail> getUsersOfDomains(List<String> domainIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<UserDetail> list = this.userDAO.getUsersOfDomains(con, domainIds);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getUsersOfDomains", 4, "admin.MSG_ERR_GET_ALL_USERS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    public List<UserDetail> getUsersOfDomainsFromNewestToOldest(List<String> domainIds) throws AdminException {
        Connection con = null;
        try {
            con = DBUtil.makeConnection(JNDINames.ADMIN_DATASOURCE);
            List<UserDetail> list = this.userDAO.getUsersOfDomainsFromNewestToOldest(con, domainIds);
            return list;
        }
        catch (Exception e) {
            throw new AdminException("UserManager.getUsersOfDomains", 4, "admin.MSG_ERR_GET_ALL_USERS", e);
        }
        finally {
            DBUtil.close(con);
        }
    }

    private UserRow userDetail2UserRow(UserDetail user) {
        UserRow ur = new UserRow();
        ur.id = this.idAsInt(user.getId());
        ur.specificId = user.getSpecificId();
        ur.domainId = this.idAsInt(user.getDomainId());
        ur.login = user.getLogin();
        ur.firstName = user.getFirstName();
        ur.lastName = user.getLastName();
        ur.eMail = user.geteMail();
        ur.accessLevel = user.getAccessLevel().code();
        ur.loginQuestion = user.getLoginQuestion();
        ur.loginAnswer = user.getLoginAnswer();
        ur.creationDate = user.getCreationDate();
        ur.saveDate = user.getSaveDate();
        ur.version = user.getVersion();
        ur.tosAcceptanceDate = user.getTosAcceptanceDate();
        ur.lastLoginDate = user.getLastLoginDate();
        ur.nbSuccessfulLoginAttempts = user.getNbSuccessfulLoginAttempts();
        ur.lastLoginCredentialUpdateDate = user.getLastLoginCredentialUpdateDate();
        ur.expirationDate = user.getExpirationDate();
        ur.state = user.getState().name();
        ur.stateSaveDate = user.getStateSaveDate();
        ur.notifManualReceiverLimit = user.getNotifManualReceiverLimit();
        return ur;
    }

    private UserDetail userRow2UserDetail(UserRow ur) {
        UserDetail user = new UserDetail();
        user.setId(this.idAsString(ur.id));
        user.setSpecificId(ur.specificId);
        user.setDomainId(this.idAsString(ur.domainId));
        user.setLogin(ur.login);
        user.setFirstName(ur.firstName);
        user.setLastName(ur.lastName);
        user.seteMail(ur.eMail);
        user.setAccessLevel(UserAccessLevel.fromCode(ur.accessLevel));
        user.setLoginQuestion(ur.loginQuestion);
        user.setLoginAnswer(ur.loginAnswer);
        user.setCreationDate(ur.creationDate);
        user.setSaveDate(ur.saveDate);
        user.setVersion(ur.version);
        user.setTosAcceptanceDate(ur.tosAcceptanceDate);
        user.setLastLoginDate(ur.lastLoginDate);
        user.setNbSuccessfulLoginAttempts(ur.nbSuccessfulLoginAttempts);
        user.setLastLoginCredentialUpdateDate(ur.lastLoginCredentialUpdateDate);
        user.setExpirationDate(ur.expirationDate);
        user.setState(UserState.from(ur.state));
        user.setStateSaveDate(ur.stateSaveDate);
        user.setNotifManualReceiverLimit(ur.notifManualReceiverLimit);
        return user;
    }

    private int idAsInt(String id) {
        if (id == null || id.length() == 0) {
            return -1;
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private String idAsString(int id) {
        return Integer.toString(id);
    }
}

