/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.cache;

import com.stratelia.webactiv.beans.admin.Domain;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DomainCache {
    private static ConcurrentMap<String, Domain> map = new ConcurrentHashMap<String, Domain>();

    public static synchronized void clearCache() {
        map.clear();
    }

    public static Domain getDomain(String id) {
        return (Domain)map.get(id);
    }

    public static void setDomains(List<Domain> domains) {
        DomainCache.clearCache();
        for (Domain domain : domains) {
            DomainCache.addDomain(domain);
        }
    }

    public static void addDomain(Domain domain) {
        map.putIfAbsent(domain.getId(), domain);
    }

    public static void removeDomain(String id) {
        map.remove(id);
    }
}

