/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.cache;

import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Space {
    SpaceInstLight space;
    Map<String, ComponentInstLight> components = new LinkedHashMap<String, ComponentInstLight>();
    List<SpaceInstLight> subspaces = new ArrayList<SpaceInstLight>();

    public SpaceInstLight getSpace() {
        return this.space;
    }

    public void setSpace(SpaceInstLight space) {
        this.space = space;
    }

    public List<ComponentInstLight> getComponents() {
        return new ArrayList<ComponentInstLight>(this.components.values());
    }

    public void clearComponents() {
        this.components.clear();
    }

    public List<String> getComponentIds() {
        ArrayList<String> ids = new ArrayList<String>(this.components.size());
        for (ComponentInstLight component : this.components.values()) {
            ids.add(component.getId());
        }
        return ids;
    }

    public void setComponents(List<ComponentInstLight> components) {
        for (ComponentInstLight component : components) {
            this.components.put(component.getId(), component);
        }
    }

    public List<SpaceInstLight> getSubspaces() {
        return this.subspaces;
    }

    public void setSubspaces(List<SpaceInstLight> subspaces) {
        this.subspaces = subspaces;
    }

    public void addComponent(ComponentInstLight component) {
        this.components.put(component.getId(), component);
    }

    public void removeComponent(ComponentInstLight component) {
        this.components.remove(component.getId());
    }

    public boolean containsComponent(String componentId) {
        return this.components.containsKey(componentId);
    }

    public ComponentInstLight getComponent(String componentId) {
        return this.components.get(componentId);
    }

    public void updateSubspace(SpaceInstLight subspace) {
        int index = this.subspaces.indexOf(subspace);
        if (index != -1) {
            this.subspaces.remove(index);
            this.subspaces.add(index, subspace);
        }
    }
}

