/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.cache;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.ComponentInstLight;
import com.stratelia.webactiv.beans.admin.SpaceInstLight;
import com.stratelia.webactiv.beans.admin.cache.Space;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TreeCache {
    private static final ConcurrentMap<String, Space> map = new ConcurrentHashMap<String, Space>();

    public static synchronized void clearCache() {
        map.clear();
    }

    public static SpaceInstLight getSpaceInstLight(String spaceId) {
        Space space = TreeCache.getSpace(spaceId);
        if (space != null) {
            return space.getSpace();
        }
        return null;
    }

    public static void addSpace(String spaceId, Space space) {
        map.putIfAbsent(spaceId, space);
    }

    public static synchronized void removeSpace(String spaceId) {
        Space space = (Space)map.get(spaceId);
        if (space != null) {
            for (SpaceInstLight subspace : space.getSubspaces()) {
                TreeCache.removeSpace(subspace.getShortId());
            }
            map.remove(spaceId);
        }
    }

    public static void setSubspaces(String spaceId, List<SpaceInstLight> subspaces) {
        Space space = TreeCache.getSpace(spaceId);
        if (space != null) {
            space.getSubspaces().clear();
            space.getSubspaces().addAll(subspaces);
        }
    }

    public static List<ComponentInstLight> getComponents(String spaceId) {
        SilverTrace.debug("admin", "TreeCache.getComponents()", "root.MSG_GEN_ENTER_METHOD", "spaceId = " + spaceId);
        Space space = TreeCache.getSpace(spaceId);
        if (space != null) {
            return space.getComponents();
        }
        SilverTrace.debug("admin", "TreeCache.getComponents()", "root.MSG_GEN_EXIT_METHOD", "spaceId = " + spaceId);
        return new ArrayList<ComponentInstLight>();
    }

    public static List<String> getComponentIds(String spaceId) {
        SilverTrace.debug("admin", "TreeCache.getComponentIds()", "root.MSG_GEN_ENTER_METHOD", "spaceId = " + spaceId);
        Space space = TreeCache.getSpace(spaceId);
        if (space != null) {
            return space.getComponentIds();
        }
        SilverTrace.debug("admin", "TreeCache.getComponentIds()", "root.MSG_GEN_EXIT_METHOD", "spaceId = " + spaceId);
        return new ArrayList<String>();
    }

    public static List<SpaceInstLight> getSubSpaces(String spaceId) {
        Space space = TreeCache.getSpace(spaceId);
        if (space != null) {
            return space.getSubspaces();
        }
        return new ArrayList<SpaceInstLight>();
    }

    public static boolean isSpaceContainsComponent(String spaceId, String componentId) {
        boolean contains = false;
        Space space = TreeCache.getSpace(spaceId);
        if (space != null && !(contains = space.containsComponent(componentId))) {
            List<SpaceInstLight> subspaces = space.getSubspaces();
            for (SpaceInstLight subspace : subspaces) {
                contains = TreeCache.isSpaceContainsComponent(subspace.getShortId(), componentId);
                if (!contains) continue;
                return true;
            }
        }
        return contains;
    }

    public static void addComponent(String componentId, ComponentInstLight component, String spaceId) {
        Space space = TreeCache.getSpace(spaceId);
        if (space != null) {
            space.addComponent(component);
        }
    }

    public static void removeComponent(String spaceId, String componentId) {
        ComponentInstLight component;
        Space space = TreeCache.getSpace(spaceId);
        if (space != null && (component = space.getComponent(componentId)) != null) {
            space.removeComponent(component);
        }
    }

    public static void setComponents(String spaceId, List<ComponentInstLight> components) {
        Space space = TreeCache.getSpace(spaceId);
        if (space != null) {
            space.clearComponents();
            space.setComponents(components);
        }
    }

    public static List<ComponentInstLight> getComponentsInSpaceAndSubspaces(String spaceId) {
        ArrayList<ComponentInstLight> components = new ArrayList<ComponentInstLight>();
        components.addAll(TreeCache.getComponents(spaceId));
        for (SpaceInstLight subspace : TreeCache.getSubSpaces(spaceId)) {
            components.addAll(TreeCache.getComponentsInSpaceAndSubspaces(subspace.getShortId()));
        }
        return components;
    }

    public static List<SpaceInstLight> getSpacePath(String spaceId) {
        ArrayList<SpaceInstLight> path = new ArrayList<SpaceInstLight>();
        String shortSpaceId = TreeCache.getShortSpaceId(spaceId);
        SpaceInstLight space = TreeCache.getSpaceInstLight(shortSpaceId);
        if (space != null) {
            path.add(0, space);
            while (!space.isRoot()) {
                if ((space = TreeCache.getSpaceInstLight(space.getFatherId())) == null) continue;
                path.add(0, space);
            }
        }
        return path;
    }

    public static synchronized ComponentInstLight getComponent(String componentId) {
        ComponentInstLight component = null;
        for (Space space : map.values()) {
            component = space.getComponent(componentId);
            if (component == null) continue;
            return component;
        }
        return component;
    }

    public static synchronized SpaceInstLight getSpaceContainingComponent(String componentId) {
        for (Space space : map.values()) {
            if (!space.containsComponent(componentId)) continue;
            return space.getSpace();
        }
        return null;
    }

    public static List<SpaceInstLight> getComponentPath(String componentId) {
        ComponentInstLight component = TreeCache.getComponent(componentId);
        if (component != null) {
            return TreeCache.getSpacePath(component.getDomainFatherId());
        }
        return new ArrayList<SpaceInstLight>();
    }

    public static synchronized void updateSpace(SpaceInstLight spaceLight) {
        Space space;
        if (spaceLight != null && StringUtil.isDefined(spaceLight.getFullId()) && (space = TreeCache.getSpace(spaceLight.getShortId())) != null) {
            space.setSpace(spaceLight);
            if (!spaceLight.isRoot()) {
                Space parent = TreeCache.getSpace(spaceLight.getFatherId());
                parent.updateSubspace(spaceLight);
            }
        }
    }

    private static synchronized Space getSpace(String spaceId) {
        return (Space)map.get(spaceId);
    }

    public static int getSpaceLevel(String spaceId) {
        return TreeCache.getSpacePath(spaceId).size() - 1;
    }

    public static void addSubSpace(String spaceId, SpaceInstLight subSpace) {
        Space space = TreeCache.getSpace(spaceId);
        if (space != null) {
            Iterator<SpaceInstLight> spaceSubSpaceIterator = space.getSubspaces().iterator();
            while (spaceSubSpaceIterator.hasNext()) {
                SpaceInstLight currentSpaceSubSpace = spaceSubSpaceIterator.next();
                if (!currentSpaceSubSpace.getFullId().equals(subSpace.getFullId())) continue;
                spaceSubSpaceIterator.remove();
                break;
            }
            space.getSubspaces().add(subSpace);
        }
    }

    private static String getShortSpaceId(String id) {
        if (id != null && id.startsWith("WA")) {
            return id.substring("WA".length());
        }
        return id;
    }
}

