/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.beans.admin.dao;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.organization.UserRoleRow;
import com.stratelia.webactiv.util.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class RoleDAO {
    private static final String USERROLE_COLUMNS = "id,instanceId,name,roleName,description,isInherited,objectId,objecttype";
    private static final String queryAllUserRoles = "select id,instanceId,name,roleName,description,isInherited,objectId,objecttype from st_userrole r, st_userrole_user_rel ur where r.id=ur.userroleid and r.objectId is null  and ur.userId = ? ";
    private static final String queryAllUserComponentObjectRoles = "select id,instanceId,name,roleName,description,isInherited,objectId,objecttype from st_userrole r, st_userrole_user_rel ur where r.id=ur.userroleid and r.objectId is not null  and ur.userId = ? ";
    private static final String queryAllUserRolesOnObject = "select id,instanceId,name,roleName,description,isInherited,objectId,objecttype from st_userrole r, st_userrole_user_rel ur where r.id=ur.userroleid and r.objectId = ?  and r.objectType = ?  and r.instanceId = ?  and ur.userId = ? ";
    private static final String queryAllUserRolesOnComponent = "select id,instanceId,name,roleName,description,isInherited,objectId,objecttype from st_userrole r, st_userrole_user_rel ur where r.id=ur.userroleid and r.instanceId = ?  and r.objecttype is null  and ur.userId = ? ";

    private static String list2String(List<String> ids) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            if (i != 0) {
                str.append(",");
            }
            str.append(ids.get(i));
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<UserRoleRow> getRoles(Connection con, int userId) throws SQLException {
        ArrayList<UserRoleRow> arrayList;
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(queryAllUserRoles);
            stmt.setInt(1, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                roles.add(RoleDAO.fetchUserRole(rs));
            }
            arrayList = roles;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    public static List<UserRoleRow> getAllComponentObjectRoles(Connection con, List<String> groupIds, int userId) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        if (groupIds != null && groupIds.size() > 0) {
            roles.addAll(RoleDAO.getAllComponentObjectRolesForGroups(con, groupIds));
        }
        if (userId != -1) {
            roles.addAll(RoleDAO.getAllComponentObjectRolesForUser(con, userId));
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<UserRoleRow> getAllComponentObjectRolesForUser(Connection con, int userId) throws SQLException {
        ArrayList<UserRoleRow> arrayList;
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(queryAllUserComponentObjectRoles);
            stmt.setInt(1, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                roles.add(RoleDAO.fetchUserRole(rs));
            }
            arrayList = roles;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<UserRoleRow> getRoles(Connection con, List<String> groupIds) throws SQLException {
        ArrayList<UserRoleRow> arrayList;
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        String query = "select id,instanceId,name,roleName,description,isInherited,objectId,objecttype from st_userrole r, st_userrole_group_rel gr where r.id=gr.userroleid and r.objectId is null  and gr.groupId IN (" + RoleDAO.list2String(groupIds) + ")";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                roles.add(RoleDAO.fetchUserRole(rs));
            }
            arrayList = roles;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<UserRoleRow> getAllComponentObjectRolesForGroups(Connection con, List<String> groupIds) throws SQLException {
        ArrayList<UserRoleRow> arrayList;
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        String query = "select id,instanceId,name,roleName,description,isInherited,objectId,objecttype from st_userrole r, st_userrole_group_rel gr where r.id=gr.userroleid and r.objectId is not null  and gr.groupId IN (" + RoleDAO.list2String(groupIds) + ")";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                roles.add(RoleDAO.fetchUserRole(rs));
            }
            arrayList = roles;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    public static List<UserRoleRow> getRoles(Connection con, List<String> groupIds, int userId) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        if (groupIds != null && groupIds.size() > 0) {
            roles.addAll(RoleDAO.getRoles(con, groupIds));
        }
        if (userId != -1) {
            roles.addAll(RoleDAO.getRoles(con, userId));
        }
        return roles;
    }

    public static List<UserRoleRow> getRoles(Connection con, List<String> groupIds, int userId, int instanceId) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        if (groupIds != null && groupIds.size() > 0) {
            roles.addAll(RoleDAO.getRoles(con, -1, null, instanceId, groupIds));
        }
        if (userId != -1) {
            roles.addAll(RoleDAO.getRoles(con, instanceId, userId));
        }
        return roles;
    }

    public static List<UserRoleRow> getRoles(Connection con, int objectId, String objectType, int instanceId, List<String> groupIds, int userId) throws SQLException {
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        if (groupIds != null && groupIds.size() > 0) {
            roles.addAll(RoleDAO.getRoles(con, objectId, objectType, instanceId, groupIds));
        }
        if (userId != -1) {
            roles.addAll(RoleDAO.getRoles(con, objectId, objectType, instanceId, userId));
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<UserRoleRow> getRoles(Connection con, int objectId, String objectType, int instanceId, List<String> groupIds) throws SQLException {
        ArrayList<UserRoleRow> arrayList;
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        String queryAllAvailableComponentIds = "select id,instanceId,name,roleName,description,isInherited,objectId,objecttype from st_userrole r, st_userrole_group_rel gr where r.id=gr.userroleid";
        if (objectId != -1) {
            queryAllAvailableComponentIds = queryAllAvailableComponentIds + " and r.objectId = " + objectId;
        }
        queryAllAvailableComponentIds = StringUtil.isDefined(objectType) ? queryAllAvailableComponentIds + " and r.objectType = '" + objectType + "'" : queryAllAvailableComponentIds + " and r.objectType is null";
        queryAllAvailableComponentIds = queryAllAvailableComponentIds + " and r.instanceId = " + instanceId + " and gr.groupId IN (" + RoleDAO.list2String(groupIds) + ")";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(queryAllAvailableComponentIds);
            while (rs.next()) {
                roles.add(RoleDAO.fetchUserRole(rs));
            }
            arrayList = roles;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    private static UserRoleRow fetchUserRole(ResultSet rs) throws SQLException {
        UserRoleRow ur = new UserRoleRow();
        ur.id = rs.getInt(1);
        ur.instanceId = rs.getInt(2);
        ur.name = rs.getString(3);
        ur.roleName = rs.getString(4);
        ur.description = rs.getString(5);
        ur.isInherited = rs.getInt(6);
        ur.objectId = rs.getInt(7);
        ur.objectType = rs.getString(8);
        return ur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<UserRoleRow> getRoles(Connection con, int objectId, String objectType, int instanceId, int userId) throws SQLException {
        ArrayList<UserRoleRow> arrayList;
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sqlQuery = objectId != -1 ? queryAllUserRolesOnObject : queryAllUserRolesOnObject.replace(" and r.objectId = ?", "");
            stmt = con.prepareStatement(sqlQuery);
            int index = 0;
            if (objectId != -1) {
                stmt.setInt(++index, objectId);
            }
            stmt.setString(++index, objectType);
            stmt.setInt(++index, instanceId);
            stmt.setInt(++index, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                roles.add(RoleDAO.fetchUserRole(rs));
            }
            arrayList = roles;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<UserRoleRow> getRoles(Connection con, int instanceId, int userId) throws SQLException {
        ArrayList<UserRoleRow> arrayList;
        ArrayList<UserRoleRow> roles = new ArrayList<UserRoleRow>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement(queryAllUserRolesOnComponent);
            stmt.setInt(1, instanceId);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                roles.add(RoleDAO.fetchUserRole(rs));
            }
            arrayList = roles;
        }
        catch (Throwable throwable) {
            DBUtil.close(rs, stmt);
            throw throwable;
        }
        DBUtil.close(rs, stmt);
        return arrayList;
    }
}

