/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.jaas;

import com.silverpeas.accesscontrol.AccessController;
import com.silverpeas.accesscontrol.AccessControllerProvider;
import java.security.Principal;
import java.util.regex.Pattern;

public class SilverpeasUserPrincipal
implements Principal {
    private String userId;
    private boolean administrator;
    private static final Pattern COMPONENTID_PATTERN = Pattern.compile("^([a-zA-Z]+)([0-9]+)$");

    public SilverpeasUserPrincipal(String userId, boolean administrator) {
        this.userId = userId;
        this.administrator = administrator;
    }

    public boolean canAccess(String componentId) {
        if (COMPONENTID_PATTERN.matcher(componentId).find()) {
            AccessController<String> accessController = AccessControllerProvider.getAccessController("componentAccessController");
            return accessController.isUserAuthorized(this.userId, componentId);
        }
        return false;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isAdministrator() {
        return this.administrator;
    }

    @Override
    public String getName() {
        return this.userId;
    }
}

