/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.ComponentInstanceI18NRow;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.Table;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class ComponentInstanceI18NTable
extends Table<ComponentInstanceI18NRow> {
    private static final String COLUMNS = "id,componentId,lang,name,description";
    private static final String SELECT_TRANSLATIONS = "select id,componentId,lang,name,description from ST_ComponentInstanceI18N where componentId = ?";
    private static final String INSERT_TRANSLATION = "insert into ST_ComponentInstanceI18N(id,componentId,lang,name,description) values  (?, ?, ?, ?, ?)";
    private static final String UPDATE_TRANSLATION = "update ST_ComponentInstanceI18N set name = ?, description = ?  WHERE id = ? ";
    private static final String DELETE_TRANSLATION = "delete from ST_ComponentInstanceI18N where id = ?";
    private static final String DELETE_TRANSLATIONS = "delete from ST_ComponentInstanceI18N where componentId = ?";

    public ComponentInstanceI18NTable(OrganizationSchema organization) {
        super(organization, "ST_ComponentInstanceI18N");
    }

    protected ComponentInstanceI18NRow fetchTranslation(ResultSet rs) throws SQLException {
        ComponentInstanceI18NRow s = new ComponentInstanceI18NRow();
        s.id = rs.getInt(1);
        s.componentId = rs.getInt(2);
        s.lang = rs.getString(3);
        s.name = rs.getString(4);
        s.description = rs.getString(5);
        return s;
    }

    public List<ComponentInstanceI18NRow> getTranslations(int componentId) throws AdminPersistenceException {
        return this.getRows(SELECT_TRANSLATIONS, componentId);
    }

    public void createTranslation(ComponentInstanceI18NRow translation) throws AdminPersistenceException {
        this.insertRow(INSERT_TRANSLATION, translation);
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, ComponentInstanceI18NRow row) throws SQLException {
        row.id = this.getNextId();
        insert.setInt(1, row.id);
        insert.setInt(2, row.componentId);
        insert.setString(3, row.lang);
        insert.setString(4, ComponentInstanceI18NTable.truncate(row.name, 100));
        insert.setString(5, ComponentInstanceI18NTable.truncate(row.description, 400));
    }

    public void updateTranslation(ComponentInstanceI18NRow component) throws AdminPersistenceException {
        this.updateRow(UPDATE_TRANSLATION, component);
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, ComponentInstanceI18NRow row) throws SQLException {
        update.setString(1, ComponentInstanceI18NTable.truncate(row.name, 100));
        update.setString(2, ComponentInstanceI18NTable.truncate(row.description, 400));
        update.setInt(3, row.id);
    }

    public void removeTranslation(int id) throws AdminPersistenceException {
        this.updateRelation(DELETE_TRANSLATION, id);
    }

    public void removeTranslations(int componentId) throws AdminPersistenceException {
        this.updateRelation(DELETE_TRANSLATIONS, componentId);
    }

    @Override
    protected ComponentInstanceI18NRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchTranslation(rs);
    }
}

