/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.KeyStoreRow;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.Table;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class KeyStoreTable
extends Table<KeyStoreRow> {
    private static final String KEYSTORE_COLUMNS = "userKey, login, domainId";
    private static final String SELECT_RECORD_BY_KEY = "select userKey, login, domainId from ST_KeyStore where userKey = ?";
    private static final String DELETE_RECORD = "delete from ST_KeyStore where userKey = ?";

    public KeyStoreTable(OrganizationSchema organization) {
        super(organization, "ST_KeyStore");
    }

    protected KeyStoreRow fetchKeyStore(ResultSet rs) throws SQLException {
        KeyStoreRow k = new KeyStoreRow();
        k.key = rs.getInt("userKey");
        k.login = rs.getString("login");
        k.domainId = rs.getInt("domainId");
        return k;
    }

    public KeyStoreRow getRecordByKey(int nKey) throws AdminPersistenceException {
        return (KeyStoreRow)this.getUniqueRow(SELECT_RECORD_BY_KEY, nKey);
    }

    public void removeKeyStoreRecord(int nKey) throws AdminPersistenceException {
        this.updateRelation(DELETE_RECORD, nKey);
    }

    @Override
    protected KeyStoreRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchKeyStore(rs);
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, KeyStoreRow row) {
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, KeyStoreRow row) {
    }
}

