/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.GroupRow;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.SpaceRow;
import com.stratelia.webactiv.organization.SpaceUserRoleRow;
import com.stratelia.webactiv.organization.Table;
import com.stratelia.webactiv.organization.UserRow;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SpaceUserRoleTable
extends Table<SpaceUserRoleRow> {
    private static final String SPACEUSERROLE_COLUMNS = "id,spaceId,name,RoleName,description,isInherited";
    private static final String SELECT_SPACEUSERROLE_BY_ID = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole where id = ?";
    private static final String SELECT_SPACEUSERROLE_BY_ROLENAME = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole where spaceId = ? and isInherited = ? and rolename = ?";
    private static final String SELECT_ALL_SPACEUSERROLES = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole";
    private static final String SELECT_ALL_SPACE_USERROLES = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole where spaceId = ?";
    private static final String SELECT_ALL_SPACE_USERROLE_IDS = "select id from ST_SpaceUserRole where spaceId = ?";
    private static final String SELECT_USER_SPACEUSERROLES = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole, ST_SpaceUserRole_User_Rel where id = spaceUserRoleId and   userId = ?";
    private static final String SELECT_GROUP_SPACEUSERROLES = "select id,spaceId,name,RoleName,description,isInherited from ST_SpaceUserRole, ST_SpaceUserRole_Group_Rel where id = spaceUserRoleId and   groupId = ?";
    private static final String INSERT_SPACEUSERROLE = "insert into ST_SpaceUserRole(id,spaceId,name,RoleName,description,isInherited) values     (? \t,?       ,?   ,?       ,?\t\t   ,?)";
    private static final String UPDATE_SPACEUSERROLE = "update ST_SpaceUserRole set name = ?, description = ? where id = ?";
    private static final String DELETE_SPACEUSERROLE = "delete from ST_SpaceUserRole where id = ?";
    private static final String SELECT_COUNT_SPACEUSERROLE_USER_REL = "select count(*) from ST_SpaceUserRole_User_Rel where userId = ? and spaceUserRoleId = ?";
    private static final String INSERT_A_SPACEUSERROLE_USER_REL = "insert into ST_SpaceUserRole_User_Rel(spaceUserRoleId, userId) values(?,?)";
    private static final String DELETE_SPACEUSERROLE_USER_REL = "delete from ST_SpaceUserRole_User_Rel where spaceUserRoleId = ? and userId = ?";
    private static final String DELETE_ALL_USERS_FROM_SPACEUSERROLE = "delete from ST_SpaceUserRole_User_Rel where spaceUserRoleId = ? ";
    private static final String SELECT_COUNT_SPACEUSERROLE_GROUP_REL = "select count(*) from ST_SpaceUserRole_Group_Rel where groupId = ? and spaceUserRoleId = ?";
    private static final String INSERT_A_SPACEUSERROLE_GROUP_REL = "insert into ST_SpaceUserRole_Group_Rel(spaceUserRoleId, groupId) values(?,?)";
    private static final String DELETE_SPACEUSERROLE_GROUP_REL = "delete from ST_SpaceUserRole_Group_Rel where spaceUserRoleId = ? and groupId = ?";
    private static final String DELETE_ALL_GROUPS_FROM_SPACEUSERROLE = "delete from ST_SpaceUserRole_Group_Rel where spaceUserRoleId = ?";
    private OrganizationSchema organization = null;

    public SpaceUserRoleTable(OrganizationSchema organization) {
        super(organization, "ST_SpaceUserRole");
        this.organization = organization;
    }

    protected SpaceUserRoleRow fetchSpaceUserRole(ResultSet rs) throws SQLException {
        SpaceUserRoleRow sur = new SpaceUserRoleRow();
        sur.id = rs.getInt(1);
        sur.spaceId = rs.getInt(2);
        sur.name = rs.getString(3);
        sur.roleName = rs.getString(4);
        sur.description = rs.getString(5);
        sur.isInherited = rs.getInt(6);
        return sur;
    }

    public SpaceUserRoleRow getSpaceUserRole(int id) throws AdminPersistenceException {
        return (SpaceUserRoleRow)this.getUniqueRow(SELECT_SPACEUSERROLE_BY_ID, id);
    }

    public SpaceUserRoleRow getSpaceUserRole(int spaceId, String roleName, int inherited) throws AdminPersistenceException {
        ArrayList<Object> params = new ArrayList<Object>(3);
        params.add(spaceId);
        params.add(inherited);
        params.add(roleName);
        List spaceUserRoles = this.getRows(SELECT_SPACEUSERROLE_BY_ROLENAME, params);
        if (spaceUserRoles.isEmpty()) {
            return null;
        }
        if (spaceUserRoles.size() == 1) {
            return (SpaceUserRoleRow)spaceUserRoles.get(0);
        }
        throw new AdminPersistenceException("SpaceUserRoleTable.getSpaceUserRole", 4, "admin.EX_ERR_SPACEUSERROLE_NAME_SPACEID_FOUND_TWICE", "space id : '" + spaceId + "', space userrole name: '" + roleName + "'");
    }

    public SpaceUserRoleRow[] getAllSpaceUserRoles() throws AdminPersistenceException {
        List<SpaceUserRoleRow> rows = this.getRows(SELECT_ALL_SPACEUSERROLES);
        return rows.toArray(new SpaceUserRoleRow[rows.size()]);
    }

    public SpaceUserRoleRow[] getAllSpaceUserRolesOfSpace(int spaceId) throws AdminPersistenceException {
        List<SpaceUserRoleRow> rows = this.getRows(SELECT_ALL_SPACE_USERROLES, spaceId);
        return rows.toArray(new SpaceUserRoleRow[rows.size()]);
    }

    public String[] getAllSpaceUserRoleIdsOfSpace(int spaceId) throws AdminPersistenceException {
        List<String> ids = this.getIds(SELECT_ALL_SPACE_USERROLE_IDS, spaceId);
        return ids.toArray(new String[ids.size()]);
    }

    public SpaceUserRoleRow[] getDirectSpaceUserRolesOfUser(int userId) throws AdminPersistenceException {
        List<SpaceUserRoleRow> rows = this.getRows(SELECT_USER_SPACEUSERROLES, userId);
        return rows.toArray(new SpaceUserRoleRow[rows.size()]);
    }

    public SpaceUserRoleRow[] getDirectSpaceUserRolesOfGroup(int groupId) throws AdminPersistenceException {
        List<SpaceUserRoleRow> rows = this.getRows(SELECT_GROUP_SPACEUSERROLES, groupId);
        return rows.toArray(new SpaceUserRoleRow[rows.size()]);
    }

    public SpaceUserRoleRow[] getAllMatchingSpaceUserRoles(SpaceUserRoleRow sampleSpaceUserRole) throws AdminPersistenceException {
        String[] columns = new String[]{"name", "description"};
        String[] values = new String[]{sampleSpaceUserRole.name, sampleSpaceUserRole.description};
        List<SpaceUserRoleRow> rows = this.getMatchingRows(SPACEUSERROLE_COLUMNS, columns, values);
        return rows.toArray(new SpaceUserRoleRow[rows.size()]);
    }

    public void createSpaceUserRole(SpaceUserRoleRow spaceUserRole) throws AdminPersistenceException {
        SpaceRow space = this.organization.space.getSpace(spaceUserRole.spaceId);
        if (space == null) {
            throw new AdminPersistenceException("SpaceUserRoleTable.createSpaceUserRole", 4, "admin.EX_ERR_SPACE_NOT_FOUND", "space id : '" + spaceUserRole.spaceId + "'");
        }
        this.insertRow(INSERT_SPACEUSERROLE, spaceUserRole);
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, SpaceUserRoleRow row) throws SQLException {
        SilverTrace.debug("admin", "SpaceUserRoleTable.prepareInsert", "root.MSG_GEN_ENTER_METHOD", "usr.id = " + row.id + ", usr.spaceId = " + row.spaceId + ", usr.roleName = " + row.roleName + ", usr.isInherited = " + row.isInherited);
        if (row.id == -1) {
            row.id = this.getNextId();
        }
        insert.setInt(1, row.id);
        insert.setInt(2, row.spaceId);
        insert.setString(3, SpaceUserRoleTable.truncate(row.name, 100));
        insert.setString(4, SpaceUserRoleTable.truncate(row.roleName, 100));
        insert.setString(5, SpaceUserRoleTable.truncate(row.description, 500));
        insert.setInt(6, row.isInherited);
    }

    public void updateSpaceUserRole(SpaceUserRoleRow spaceUserRole) throws AdminPersistenceException {
        this.updateRow(UPDATE_SPACEUSERROLE, spaceUserRole);
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, SpaceUserRoleRow row) throws SQLException {
        update.setString(1, SpaceUserRoleTable.truncate(row.name, 100));
        update.setString(2, SpaceUserRoleTable.truncate(row.description, 500));
        update.setInt(3, row.id);
    }

    public void removeSpaceUserRole(int id) throws AdminPersistenceException {
        SpaceUserRoleRow spaceUserRole = this.getSpaceUserRole(id);
        if (spaceUserRole == null) {
            return;
        }
        this.removeAllUsersFromSpaceUserRole(id);
        this.removeAllGroupsFromSpaceUserRole(id);
        this.updateRelation(DELETE_SPACEUSERROLE, id);
    }

    public boolean isUserDirectlyInRole(int userId, int spaceUserRoleId) throws AdminPersistenceException {
        int[] ids = new int[]{userId, spaceUserRoleId};
        Integer result = this.getInteger(SELECT_COUNT_SPACEUSERROLE_USER_REL, ids);
        return result != null && result >= 1;
    }

    public void addUserInSpaceUserRole(int userId, int spaceUserRoleId) throws AdminPersistenceException {
        if (this.isUserDirectlyInRole(userId, spaceUserRoleId)) {
            return;
        }
        UserRow user = this.organization.user.getUser(userId);
        if (user == null) {
            throw new AdminPersistenceException("SpaceUserRoleTable.addUserInSpaceUserRole", 4, "admin.EX_ERR_USER_NOT_FOUND", "user id : '" + userId + "'");
        }
        SpaceUserRoleRow spaceUserRole = this.getSpaceUserRole(spaceUserRoleId);
        if (spaceUserRole == null) {
            throw new AdminPersistenceException("SpaceUserRoleTable.addUserInSpaceUserRole", 4, "admin.EX_ERR_SPACEUSERROLE_NOT_FOUND", "space user role id : '" + spaceUserRoleId + "'");
        }
        int[] params = new int[]{spaceUserRoleId, userId};
        this.updateRelation(INSERT_A_SPACEUSERROLE_USER_REL, params);
    }

    public void removeUserFromSpaceUserRole(int userId, int spaceUserRoleId) throws AdminPersistenceException {
        if (!this.isUserDirectlyInRole(userId, spaceUserRoleId)) {
            throw new AdminPersistenceException("SpaceUserRoleTable.removeUserFromSpaceUserRole", 4, "admin.EX_ERR_USER_NOT_IN_SPACE_USERROLE", "space userrole id: '" + spaceUserRoleId + "', user id: '" + userId + "'");
        }
        int[] params = new int[]{spaceUserRoleId, userId};
        SynchroReport.debug("SpaceUserRoleTable.removeUserFromSpaceUserRole()", "Retrait de l'utilisateur d'ID " + userId + " de role d'espace d'ID " + spaceUserRoleId + ", requ\u00eate : " + DELETE_SPACEUSERROLE_USER_REL, null);
        this.updateRelation(DELETE_SPACEUSERROLE_USER_REL, params);
    }

    public void removeAllUsersFromSpaceUserRole(int spaceUserRoleId) throws AdminPersistenceException {
        SynchroReport.debug("SpaceUserRoleTable.removeAllUsersFromSpaceUserRole()", "Retrait des utilisateurs du role d'espace d'ID " + spaceUserRoleId + ", requ\u00eate : " + DELETE_SPACEUSERROLE_USER_REL, null);
        this.updateRelation(DELETE_ALL_USERS_FROM_SPACEUSERROLE, spaceUserRoleId);
    }

    public boolean isGroupDirectlyInRole(int groupId, int spaceUserRoleId) throws AdminPersistenceException {
        int[] ids = new int[]{groupId, spaceUserRoleId};
        Integer result = this.getInteger(SELECT_COUNT_SPACEUSERROLE_GROUP_REL, ids);
        return result != null && result >= 1;
    }

    public void addGroupInSpaceUserRole(int groupId, int spaceUserRoleId) throws AdminPersistenceException {
        if (this.isGroupDirectlyInRole(groupId, spaceUserRoleId)) {
            return;
        }
        GroupRow group = this.organization.group.getGroup(groupId);
        if (group == null) {
            throw new AdminPersistenceException("SpaceUserRoleTable.addGroupInSpaceUserRole", 4, "admin.EX_ERR_GROUP_NOT_FOUND", "group id : '" + groupId + "'");
        }
        SpaceUserRoleRow spaceUserRole = this.getSpaceUserRole(spaceUserRoleId);
        if (spaceUserRole == null) {
            throw new AdminPersistenceException("SpaceUserRoleTable.addGroupInSpaceUserRole", 4, "admin.EX_ERR_SPACEUSERROLE_NOT_FOUND", "space userrole id : '" + spaceUserRoleId + "'");
        }
        int[] params = new int[]{spaceUserRoleId, groupId};
        this.updateRelation(INSERT_A_SPACEUSERROLE_GROUP_REL, params);
    }

    public void removeGroupFromSpaceUserRole(int groupId, int spaceUserRoleId) throws AdminPersistenceException {
        if (!this.isGroupDirectlyInRole(groupId, spaceUserRoleId)) {
            throw new AdminPersistenceException("SpaceUserRoleTable.removeGroupFromSpaceUserRole", 4, "admin.EX_ERR_GROUP_NOT_IN_SPACE_USERROLE", "space userrole id: '" + spaceUserRoleId + "', group id: '" + groupId + "'");
        }
        int[] params = new int[]{spaceUserRoleId, groupId};
        SynchroReport.debug("SpaceUserRoleTable.removeGroupFromSpaceUserRole()", "Retrait du groupe d'ID " + groupId + " de l'espace d'ID " + spaceUserRoleId + ", requ\u00eate : " + DELETE_SPACEUSERROLE_GROUP_REL, null);
        this.updateRelation(DELETE_SPACEUSERROLE_GROUP_REL, params);
    }

    public void removeAllGroupsFromSpaceUserRole(int spaceUserRoleId) throws AdminPersistenceException {
        SynchroReport.debug("SpaceUserRoleTable.removeAllGroupsFromSpaceUserRole()", "Retrait des groupes du r\u00f4le de l'espace d'ID " + spaceUserRoleId + ", requ\u00eate : " + DELETE_SPACEUSERROLE_GROUP_REL, null);
        this.updateRelation(DELETE_ALL_GROUPS_FROM_SPACEUSERROLE, spaceUserRoleId);
    }

    @Override
    protected SpaceUserRoleRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchSpaceUserRole(rs);
    }
}

