/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.Schema;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public abstract class Table<T> {
    private Schema schema = null;
    private String tableName = null;

    public Table(Schema schema, String tableName) {
        this.schema = schema;
        this.tableName = tableName;
    }

    static String getNotNullString(String sn) {
        if (!StringUtil.isDefined(sn)) {
            return "";
        }
        return sn;
    }

    static Timestamp getSqlTimestamp(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static String aliasColumns(String rowAlias, String columnList) {
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(columnList, ",");
        String separator = "";
        while (st.hasMoreTokens()) {
            String column = st.nextToken();
            result.append(separator);
            result.append(rowAlias);
            result.append('.');
            result.append(column);
            separator = ",";
        }
        return result.toString();
    }

    public static String truncate(String value, int maxSize) {
        if (value != null && value.length() > maxSize) {
            return value.substring(0, maxSize - 1);
        }
        return value;
    }

    public int getNextId() throws SQLException {
        int nextId;
        try {
            nextId = DBUtil.getNextId(this.tableName, "id");
        }
        catch (Exception e) {
            throw new SQLException(e.toString(), e);
        }
        if (nextId == 0) {
            return 1;
        }
        return nextId;
    }

    protected abstract T fetchRow(ResultSet var1) throws SQLException;

    protected abstract void prepareInsert(String var1, PreparedStatement var2, T var3) throws SQLException;

    protected abstract void prepareUpdate(String var1, PreparedStatement var2, T var3) throws SQLException;

    protected synchronized T getUniqueRow(String query, int id) throws AdminPersistenceException {
        T t;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            SilverTrace.debug("admin", "Table.getUniqueRow", "root.MSG_QUERY", query + " id: " + id);
            select = this.schema.getStatement(query);
            select.setInt(1, id);
            rs = select.executeQuery();
            t = this.getUniqueRow(rs);
        }
        catch (SQLException e) {
            try {
                throw new AdminPersistenceException("Table.getUniqueRow", 4, "root.EX_SQL_QUERY_FAILED", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, select);
                throw throwable;
            }
        }
        DBUtil.close(rs, select);
        return t;
    }

    protected synchronized T getUniqueRow(String query, String id) throws AdminPersistenceException {
        T t;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            SilverTrace.debug("admin", "Table.getUniqueRow", "root.MSG_QUERY", query + " id String: " + id);
            select = this.schema.getStatement(query);
            select.setString(1, id);
            rs = select.executeQuery();
            t = this.getUniqueRow(rs);
        }
        catch (SQLException e) {
            try {
                throw new AdminPersistenceException("Table.getUniqueRow", 4, "root.EX_SQL_QUERY_FAILED", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, select);
                throw throwable;
            }
        }
        DBUtil.close(rs, select);
        return t;
    }

    protected synchronized List<String> getIds(String query) throws AdminPersistenceException {
        return this.getIdsUnsynchronized(query, null);
    }

    protected synchronized List<String> getIds(String query, int id) throws AdminPersistenceException {
        return this.getIdsUnsynchronized(query, Collections.singletonList(id));
    }

    protected synchronized List<String> getIds(String query, List<?> params) throws AdminPersistenceException {
        return this.getIdsUnsynchronized(query, params);
    }

    private List<String> getIdsUnsynchronized(String query, List<?> params) throws AdminPersistenceException {
        List<String> list;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            this.logQuery("getIds", query, params);
            select = this.schema.getStatement(query);
            this.performPrepareStatementParams(select, params);
            rs = select.executeQuery();
            list = this.getIds(rs);
        }
        catch (SQLException e) {
            try {
                throw new AdminPersistenceException("Table.getIds", 4, "root.EX_SQL_QUERY_FAILED", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, select);
                throw throwable;
            }
        }
        DBUtil.close(rs, select);
        return list;
    }

    protected synchronized List<T> getRows(String query) throws AdminPersistenceException {
        return this.getRowsUnsynchronized(query, null);
    }

    protected synchronized List<T> getRows(String query, int id) throws AdminPersistenceException {
        return this.getRowsUnsynchronized(query, Collections.singletonList(id));
    }

    protected synchronized List<T> getRows(String query, List<?> params) throws AdminPersistenceException {
        return this.getRowsUnsynchronized(query, params);
    }

    private List<T> getRowsUnsynchronized(String query, List<?> params) throws AdminPersistenceException {
        List<T> list;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            this.logQuery("getRows", query, params);
            select = this.schema.getStatement(query);
            this.performPrepareStatementParams(select, params);
            rs = select.executeQuery();
            list = this.getRows(rs);
        }
        catch (SQLException e) {
            try {
                throw new AdminPersistenceException("Table.getRows", 4, "root.EX_SQL_QUERY_FAILED", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, select);
                throw throwable;
            }
        }
        DBUtil.close(rs, select);
        return list;
    }

    private void logQuery(String fromMethodName, String query, List<?> params) {
        StringBuilder message = new StringBuilder(query);
        if (params != null && !params.isEmpty()) {
            message.append(" params[]: ");
            message.append(Arrays.toString(params.toArray()));
        }
        SilverTrace.debug("admin", "Table." + fromMethodName, "root.MSG_QUERY", message.toString());
    }

    protected void performPrepareStatementParams(PreparedStatement ps, List<?> params) throws SQLException {
        int i = 1;
        if (params != null) {
            for (Object param : params) {
                if (param instanceof Integer) {
                    ps.setInt(i++, (Integer)param);
                    continue;
                }
                if (param instanceof String) {
                    ps.setString(i++, (String)param);
                    continue;
                }
                if (param instanceof Long) {
                    ps.setLong(i++, (Long)param);
                    continue;
                }
                if (param instanceof Date) {
                    ps.setDate(i++, (Date)param);
                    continue;
                }
                if (param instanceof Timestamp) {
                    ps.setTimestamp(i++, (Timestamp)param);
                    continue;
                }
                if (!(param instanceof java.util.Date)) continue;
                ps.setDate(i++, new Date(((java.util.Date)param).getTime()));
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getCount(String tableName, String whereClause, String param) throws AdminPersistenceException {
        int n;
        PreparedStatement select;
        ResultSet rs;
        block6: {
            rs = null;
            String query = "select count(*) as nbResult from " + tableName + " where " + whereClause;
            select = null;
            SilverTrace.debug("admin", "Table.getCount", "root.MSG_QUERY", query + " param: " + param);
            select = this.schema.getStatement(query);
            select.setString(1, param);
            rs = select.executeQuery();
            if (!rs.next()) break block6;
            int n2 = rs.getInt(1);
            DBUtil.close(rs, select);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new AdminPersistenceException("Table.getCount", 4, "root.EX_SQL_QUERY_FAILED", e);
                catch (Exception e2) {
                    throw new AdminPersistenceException("Table.getCount", 4, "root.EX_SQL_QUERY_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, select);
                throw throwable;
            }
        }
        DBUtil.close(rs, select);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getCount(String tableName, String whereClause, int id, String param) throws AdminPersistenceException {
        int n;
        PreparedStatement select;
        ResultSet rs;
        block6: {
            rs = null;
            String query = "select count(*) as nbResult from " + tableName + " where " + whereClause;
            select = null;
            SilverTrace.debug("admin", "Table.getCount", "root.MSG_QUERY", query + " id: " + Integer.toString(id) + " param: " + param);
            select = this.schema.getStatement(query);
            select.setInt(1, id);
            select.setString(2, param);
            rs = select.executeQuery();
            if (!rs.next()) break block6;
            int n2 = rs.getInt(1);
            DBUtil.close(rs, select);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new AdminPersistenceException("Table.getCount", 4, "root.EX_SQL_QUERY_FAILED", e);
                catch (Exception e2) {
                    throw new AdminPersistenceException("Table.getCount", 4, "root.EX_SQL_QUERY_FAILED", e2);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, select);
                throw throwable;
            }
        }
        DBUtil.close(rs, select);
        return n;
    }

    protected List<T> getMatchingRows(String returnedColumns, String[] matchColumns, String[] matchValues) throws AdminPersistenceException {
        String query = "select " + returnedColumns + " from " + this.tableName;
        ArrayList<String> notNullValues = new ArrayList<String>();
        String sep = " where ";
        for (int i = 0; i < matchColumns.length; ++i) {
            if (matchValues[i] == null) continue;
            query = query + sep + matchColumns[i] + " like ?";
            sep = " , ";
            notNullValues.add(matchValues[i]);
        }
        return this.getRows(query, notNullValues);
    }

    protected Integer getInteger(String query, int[] ids) throws AdminPersistenceException {
        Integer i2;
        ResultSet rs = null;
        PreparedStatement select = null;
        try {
            SilverTrace.debug("admin", "Table.getInteger", "root.MSG_QUERY", query + " ids[]: " + Arrays.toString(ids));
            select = this.schema.getStatement(query);
            for (int i2 = 0; i2 < ids.length; ++i2) {
                select.setInt(i2 + 1, ids[i2]);
            }
            rs = select.executeQuery();
            i2 = this.getInteger(rs);
        }
        catch (SQLException e) {
            try {
                throw new AdminPersistenceException("Table.getInteger", 4, "root.EX_SQL_QUERY_FAILED", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(rs, select);
                throw throwable;
            }
        }
        DBUtil.close(rs, select);
        return i2;
    }

    protected T getUniqueRow(ResultSet rs) throws SQLException, AdminPersistenceException {
        if (!rs.next()) {
            return null;
        }
        T result = this.fetchRow(rs);
        if (rs.next()) {
            throw new AdminPersistenceException("Table.getUniqueRow", 4, "admin.EX_ERR_NOT_UNIQUE_ROW");
        }
        return result;
    }

    protected List<T> getRows(ResultSet rs) throws SQLException {
        ArrayList<T> result = new ArrayList<T>();
        while (rs.next()) {
            result.add(this.fetchRow(rs));
        }
        return result;
    }

    protected List<String> getIds(ResultSet rs) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        while (rs.next()) {
            result.add(String.valueOf(rs.getInt(1)));
        }
        return result;
    }

    protected Integer getInteger(ResultSet rs) throws SQLException, AdminPersistenceException {
        if (!rs.next()) {
            return null;
        }
        int result = rs.getInt(1);
        if (rs.next()) {
            throw new AdminPersistenceException("Table.getInteger", 4, "admin.EX_ERR_NOT_UNIQUE_ROW");
        }
        return result;
    }

    protected int insertRow(String insertQuery, T row) throws AdminPersistenceException {
        int n;
        PreparedStatement statement = null;
        try {
            int rowsCount;
            statement = this.schema.getStatement(insertQuery);
            this.prepareInsert(insertQuery, statement, row);
            n = rowsCount = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                SynchroReport.error("Table.insertRow()", "Exception SQL : " + e.getMessage(), null);
                throw new AdminPersistenceException("Table.insertRow", 4, "root.EX_RECORD_INSERTION_FAILED", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }

    protected int updateRow(String updateQuery, T row) throws AdminPersistenceException {
        int n;
        PreparedStatement statement = null;
        try {
            int rowsCount;
            statement = this.schema.getStatement(updateQuery);
            this.prepareUpdate(updateQuery, statement, row);
            n = rowsCount = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                SynchroReport.error("Table.updateRow()", "Exception SQL : " + e.getMessage(), null);
                throw new AdminPersistenceException("Table.updateRow", 4, "admin.EX_ERR_UPDATE", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }

    protected int updateRelation(String query) throws AdminPersistenceException {
        int n;
        PreparedStatement statement = null;
        try {
            int rowsCount;
            statement = this.schema.getStatement(query);
            n = rowsCount = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new AdminPersistenceException("Table.updateRelation", 4, "admin.EX_ERR_UPDATE", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }

    protected int updateRelation(String query, int param) throws AdminPersistenceException {
        int n;
        PreparedStatement statement = null;
        try {
            int rowsCount;
            statement = this.schema.getStatement(query);
            if (param == -1) {
                statement.setNull(1, 4);
            } else {
                statement.setInt(1, param);
            }
            n = rowsCount = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                SynchroReport.error("Table.updateRelation()", "Exception SQL : " + e.getMessage(), null);
                throw new AdminPersistenceException("Table.updateRelation", 4, "admin.EX_ERR_UPDATE", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return n;
    }

    protected int updateRelation(String query, int[] ids) throws AdminPersistenceException {
        int i;
        PreparedStatement statement = null;
        try {
            int rowsCount;
            statement = this.schema.getStatement(query);
            for (i = 0; i < ids.length; ++i) {
                if (ids[i] == -1) {
                    statement.setNull(i + 1, 4);
                    continue;
                }
                statement.setInt(i + 1, ids[i]);
            }
            i = rowsCount = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                SynchroReport.error("Table.updateRelation()", "Exception SQL : " + e.getMessage(), null);
                throw new AdminPersistenceException("Table.updateRelation", 4, "admin.EX_ERR_UPDATE", e);
            }
            catch (Throwable throwable) {
                DBUtil.close(statement);
                throw throwable;
            }
        }
        DBUtil.close(statement);
        return i;
    }

    protected boolean addParamToQuery(Collection<Object> theVect, StringBuilder theQuery, String value, String column, boolean concatAndOr, String andOr) {
        if (value != null && value.length() > 0) {
            return this.addParamToQuery(theVect, theQuery, (Object)value, column, concatAndOr, andOr);
        }
        return concatAndOr;
    }

    protected boolean addParamToQuery(Collection<Object> theVect, StringBuilder theQuery, Timestamp value, String column, boolean concatAndOr, String andOr) {
        if (value != null) {
            return this.addParamToQuery(theVect, theQuery, (Object)value, column, concatAndOr, andOr);
        }
        return concatAndOr;
    }

    protected boolean addParamToQuery(Collection<Object> theVect, StringBuilder theQuery, int value, String column, boolean concatAndOr, String andOr) {
        return this.addParamToQuery(theVect, theQuery, (Object)value, column, concatAndOr, andOr);
    }

    protected boolean addIdToQuery(Collection<Object> theVect, StringBuilder theQuery, int value, String column, boolean concatAndOr, String andOr) {
        if (value != -2) {
            return this.addParamToQuery(theVect, theQuery, value, column, concatAndOr, andOr);
        }
        return concatAndOr;
    }

    private boolean addParamToQuery(Collection<Object> theVect, StringBuilder theQuery, Object value, String column, boolean concatAndOr, String andOr) {
        boolean valret = concatAndOr;
        if (valret) {
            theQuery.append(andOr);
        } else {
            theQuery.append(" where (");
            valret = true;
        }
        if (value instanceof String) {
            theQuery.append("LOWER(").append(column).append(") LIKE LOWER(?)");
        } else {
            theQuery.append(column).append(" = ?");
        }
        theVect.add(value);
        return valret;
    }
}

