/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.organization;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silverpeasinitialize.CallBackManager;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.organization.AdminPersistenceException;
import com.stratelia.webactiv.organization.DAOFactory;
import com.stratelia.webactiv.organization.GroupRow;
import com.stratelia.webactiv.organization.OrganizationSchema;
import com.stratelia.webactiv.organization.SpaceUserRoleRow;
import com.stratelia.webactiv.organization.Table;
import com.stratelia.webactiv.organization.UserFavoriteSpaceDAO;
import com.stratelia.webactiv.organization.UserFavoriteSpaceVO;
import com.stratelia.webactiv.organization.UserRoleRow;
import com.stratelia.webactiv.organization.UserRow;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.silverpeas.admin.user.constant.UserAccessLevel;
import org.silverpeas.admin.user.constant.UserState;

public class UserTable
extends Table<UserRow> {
    private static final String USER_COLUMNS = "id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit";
    private static final String SELECT_USER_BY_ID = "SELECT id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit FROM ST_User WHERE id = ?";
    private static final String SELECT_USER_BY_SPECIFICID_AND_LOGIN = "SELECT id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit FROM ST_User WHERE domainId = ? AND specificId = ?";
    private static final String SELECT_USERS_BY_SPECIFICIDS = "select id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit from ST_User where domainId = ? and specificId IN ";
    private static final String SELECT_USER_BY_DOMAINID_AND_LOGIN = "select id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit from ST_User where domainId = ? and lower(login) = lower(?) and state <> 'DELETED'";
    private static final String SELECT_ALL_USERS = "select id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit from ST_User where state <> 'DELETED' order by lastName";
    private static final String SELECT_ALL_USER_IDS = "select id from ST_User where state <> 'DELETED' order by lastName";
    private static final String SELECT_ALL_ADMIN_IDS_TRUE = "select id from ST_User where accessLevel='A' and state <> 'DELETED' order by lastName";
    private static final String SELECT_ALL_ADMIN_IDS_DOMAIN = "select id from ST_User where ((accessLevel='A') or (accessLevel='D')) and (domainId = ?) and state <> 'DELETED' order by lastName";
    private static final String SELECT_USER_IDS_BY_ACCESS_LEVEL = "select id from ST_User where accessLevel=? and state <> 'DELETED' order by lastName";
    private static final String SELECT_USER_IDS_BY_ACCESS_LEVEL_AND_DOMAIN = "select id from ST_User where domainId = ? AND accessLevel=? and state <> 'DELETED' order by lastName";
    private static final String SELECT_USERS_IN_GROUP = "select id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit from ST_User,ST_Group_User_Rel where id = userId and groupId = ? and state <> 'DELETED' order by lastName";
    private static final String SELECT_USER_IDS_IN_GROUP = "select id from ST_User,ST_Group_User_Rel where id = userId and groupId = ? and state <> 'DELETED' order by lastName";
    private static final String SELECT_USER_IDS_IN_USERROLE = "select id from ST_User,ST_UserRole_User_Rel where id = userId and userRoleId = ? and state <> 'DELETED' order by lastName";
    private static final String SELECT_ALL_USERS_IN_DOMAIN = "select id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit from ST_User where domainId=? and state <> 'DELETED' order by lastName";
    private static final String SELECT_ALL_USER_IDS_IN_DOMAIN = "select id from ST_User where domainId=? and state <> 'DELETED' order by lastName";
    private static final String SELECT_USER_IDS_IN_SPACEUSERROLE = "select id from ST_User, ST_SpaceUserRole_User_Rel where id = userId and spaceUserRoleId = ? and state <> 'DELETED'";
    private static final String SELECT_USERS_IN_GROUPUSERROLE = "select id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit from ST_User, ST_GroupUserRole_User_Rel where id = userId and groupUserRoleId = ? and state <> 'DELETED'";
    private static final String SELECT_USER_IDS_IN_GROUPUSERROLE = "select id from ST_User, ST_GroupUserRole_User_Rel where id = userId and groupUserRoleId = ? and state <> 'DELETED'";
    private static final String SELECT_SEARCH_USERSID = "select DISTINCT id, UPPER(lastName) from ST_User";
    private static final String SELECT_SEARCH_USERS = "select id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit, UPPER(lastName) from ST_User";
    private static final String SELECT_SEARCH_BY_EMAIL = "select id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit, UPPER(lastName) from ST_User where state <> 'DELETED' AND email = ?";
    private static final String INSERT_USER = "insert into ST_User (id, specificId, domainId, login, firstName, lastName, loginMail, email, accessLevel, loginQuestion, loginAnswer, creationDate, saveDate, version, tosAcceptanceDate, lastLoginDate, nbSuccessfulLoginAttempts, lastLoginCredentialUpdateDate, expirationDate, state, stateSaveDate, notifManualReceiverLimit) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_USER = "update ST_User set specificId = ?, domainId = ?, login = ?, firstName = ?, lastName = ?, loginMail = ?, email = ?, accessLevel = ?, loginQuestion = ?, loginAnswer = ?, saveDate = ?, version = ?, tosAcceptanceDate = ?, lastLoginDate = ?, nbSuccessfulLoginAttempts = ?, lastLoginCredentialUpdateDate = ?, expirationDate = ?, state = ?, stateSaveDate = ?, notifManualReceiverLimit = ? where id = ?";
    private static final String DELETE_USER = "delete from ST_User where id = ?";
    private OrganizationSchema organization = null;

    public UserTable(OrganizationSchema schema) {
        super(schema, "ST_User");
        this.organization = schema;
    }

    protected UserRow fetchUser(ResultSet rs) throws SQLException {
        UserRow u = new UserRow();
        u.id = rs.getInt("id");
        u.specificId = rs.getString("specificId");
        u.domainId = rs.getInt("domainId");
        u.login = rs.getString("login");
        u.firstName = rs.getString("firstName");
        u.lastName = rs.getString("lastName");
        u.loginMail = rs.getString("loginMail");
        u.eMail = rs.getString("email");
        u.accessLevel = rs.getString("accessLevel");
        u.loginQuestion = rs.getString("loginQuestion");
        u.loginAnswer = rs.getString("loginAnswer");
        u.creationDate = rs.getTimestamp("creationDate");
        u.saveDate = rs.getTimestamp("saveDate");
        u.version = rs.getInt("version");
        u.tosAcceptanceDate = rs.getTimestamp("tosAcceptanceDate");
        u.lastLoginDate = rs.getTimestamp("lastLoginDate");
        u.nbSuccessfulLoginAttempts = rs.getInt("nbSuccessfulLoginAttempts");
        u.lastLoginCredentialUpdateDate = rs.getTimestamp("lastLoginCredentialUpdateDate");
        u.expirationDate = rs.getTimestamp("expirationDate");
        u.state = rs.getString("state");
        u.stateSaveDate = rs.getTimestamp("stateSaveDate");
        if (StringUtil.isInteger(rs.getString("notifManualReceiverLimit"))) {
            u.notifManualReceiverLimit = rs.getInt("notifManualReceiverLimit");
        }
        return u;
    }

    public int getUserNumberOfDomain(int domainId) throws AdminPersistenceException {
        return this.getCount("ST_User", "domainId = ? AND state <> ?", domainId, "DELETED");
    }

    public int getUserNumber() throws AdminPersistenceException {
        return this.getCount("ST_User", "state <> ?", "DELETED");
    }

    public UserRow getUser(int id) throws AdminPersistenceException {
        return (UserRow)this.getUniqueRow(SELECT_USER_BY_ID, id);
    }

    public UserRow getUserBySpecificId(int domainId, String specificId) throws AdminPersistenceException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(domainId);
        params.add(specificId);
        List users = this.getRows(SELECT_USER_BY_SPECIFICID_AND_LOGIN, params);
        if (users.isEmpty()) {
            return null;
        }
        if (users.size() == 1) {
            return (UserRow)users.get(0);
        }
        throw new AdminPersistenceException("Usertable.getUserBySpecificId", 4, "admin.EX_ERR_LOGIN_FOUND_TWICE", "domain id : '" + domainId + "', user specific Id: '" + specificId + "'");
    }

    public UserRow[] getUsersBySpecificIds(int domainId, List<String> specificIds) throws AdminPersistenceException {
        if (specificIds == null || specificIds.isEmpty()) {
            return null;
        }
        StringBuilder clauseIN = new StringBuilder("(");
        for (int s = 0; s < specificIds.size(); ++s) {
            if (s != 0) {
                clauseIN.append(", ");
            }
            String specificId = specificIds.get(s);
            clauseIN.append("'").append(specificId).append("'");
        }
        clauseIN.append(")");
        String query = SELECT_USERS_BY_SPECIFICIDS + clauseIN;
        List<UserRow> rows = this.getRows(query, domainId);
        return rows.toArray(new UserRow[rows.size()]);
    }

    public UserRow getUserByLogin(int domainId, String login) throws AdminPersistenceException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(domainId);
        params.add(login);
        List users = this.getRows(SELECT_USER_BY_DOMAINID_AND_LOGIN, params);
        SynchroReport.debug("UserTable.getUserByLogin()", "V\u00e9rification que le login" + login + " du domaine no " + domainId + " n'est pas pr\u00e9sent dans la base, requ\u00eate : " + SELECT_USER_BY_DOMAINID_AND_LOGIN, null);
        if (users.isEmpty()) {
            return null;
        }
        if (users.size() == 1) {
            return (UserRow)users.get(0);
        }
        throw new AdminPersistenceException("Usertable.getUserByLogin", 4, "admin.EX_ERR_LOGIN_FOUND_TWICE", "domain id : '" + domainId + "', user login: '" + login + "'");
    }

    public UserRow[] getAllUsers() throws AdminPersistenceException {
        List<UserRow> rows = this.getRows(SELECT_ALL_USERS);
        return rows.toArray(new UserRow[rows.size()]);
    }

    public String[] getAllUserIds() throws AdminPersistenceException {
        List<String> rows = this.getIds(SELECT_ALL_USER_IDS);
        return rows.toArray(new String[rows.size()]);
    }

    public String[] getAllAdminIds(UserDetail fromUser) throws AdminPersistenceException {
        if (fromUser.isAccessAdmin() || fromUser.isAccessDomainManager()) {
            List<String> rows = this.getIds(SELECT_ALL_ADMIN_IDS_TRUE);
            return rows.toArray(new String[rows.size()]);
        }
        List<String> rows = this.getIds(SELECT_ALL_ADMIN_IDS_DOMAIN, Integer.parseInt(fromUser.getDomainId()));
        if (rows.isEmpty()) {
            rows = this.getIds(SELECT_ALL_ADMIN_IDS_TRUE);
        }
        return rows.toArray(new String[rows.size()]);
    }

    public String[] getUserIdsByAccessLevel(UserAccessLevel accessLevel) throws AdminPersistenceException {
        List<String> rows = this.getIds(SELECT_USER_IDS_BY_ACCESS_LEVEL, Collections.singletonList(accessLevel.code()));
        return rows.toArray(new String[rows.size()]);
    }

    public String[] getUserIdsOfDomainByAccessLevel(int domainId, UserAccessLevel accessLevel) throws AdminPersistenceException {
        ArrayList<Object> params = new ArrayList<Object>(2);
        params.add(domainId);
        params.add(accessLevel.code());
        List<String> rows = this.getIds(SELECT_USER_IDS_BY_ACCESS_LEVEL_AND_DOMAIN, params);
        return rows.toArray(new String[rows.size()]);
    }

    public UserRow[] getDirectUsersOfGroup(int groupId) throws AdminPersistenceException {
        List<UserRow> rows = this.getRows(SELECT_USERS_IN_GROUP, groupId);
        return rows.toArray(new UserRow[rows.size()]);
    }

    public String[] getDirectUserIdsOfGroup(int groupId) throws AdminPersistenceException {
        SynchroReport.debug("UserTable.getDirectUserIdsOfGroup()", "Recherche des utilisateurs inclus directement dans le groupe d'ID " + groupId + ", requ\u00eate : " + SELECT_USER_IDS_IN_GROUP, null);
        List<String> rows = this.getIds(SELECT_USER_IDS_IN_GROUP, groupId);
        return rows.toArray(new String[rows.size()]);
    }

    public String[] getDirectUserIdsOfUserRole(int userRoleId) throws AdminPersistenceException {
        List<String> rows = this.getIds(SELECT_USER_IDS_IN_USERROLE, userRoleId);
        return rows.toArray(new String[rows.size()]);
    }

    public UserRow[] getAllUserOfDomain(int domainId) throws AdminPersistenceException {
        SynchroReport.debug("UserTable.getAllUserOfDomain()", "Recherche de l'ensemble des utilisateurs du domaine LDAP dans la base (ID " + domainId + "), requ\u00eate : " + SELECT_ALL_USERS_IN_DOMAIN, null);
        List<UserRow> rows = this.getRows(SELECT_ALL_USERS_IN_DOMAIN, domainId);
        return rows.toArray(new UserRow[rows.size()]);
    }

    public String[] getUserIdsOfDomain(int domainId) throws AdminPersistenceException {
        List<String> rows = this.getIds(SELECT_ALL_USER_IDS_IN_DOMAIN, domainId);
        return rows.toArray(new String[rows.size()]);
    }

    public String[] getDirectUserIdsOfSpaceUserRole(int spaceUserRoleId) throws AdminPersistenceException {
        List<String> rows = this.getIds(SELECT_USER_IDS_IN_SPACEUSERROLE, spaceUserRoleId);
        return rows.toArray(new String[rows.size()]);
    }

    public UserRow[] getDirectUsersOfGroupUserRole(int groupUserRoleId) throws AdminPersistenceException {
        List<UserRow> rows = this.getRows(SELECT_USERS_IN_GROUPUSERROLE, groupUserRoleId);
        return rows.toArray(new UserRow[rows.size()]);
    }

    public String[] getDirectUserIdsOfGroupUserRole(int groupUserRoleId) throws AdminPersistenceException {
        List<String> rows = this.getIds(SELECT_USER_IDS_IN_GROUPUSERROLE, groupUserRoleId);
        return rows.toArray(new String[rows.size()]);
    }

    private boolean addCommonUserParamToQuery(Collection<Object> params, StringBuilder query, UserRow userModel, boolean concatAndOr, String andOr) {
        concatAndOr = this.addIdToQuery(params, query, userModel.id, "id", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, userModel.specificId, "specificId", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, userModel.login, "login", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, userModel.firstName, "firstName", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, userModel.lastName, "lastName", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, userModel.eMail, "email", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, userModel.accessLevel, "accessLevel", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, userModel.loginQuestion, "loginQuestion", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, userModel.loginAnswer, "loginAnswer", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, UserTable.getSqlTimestamp(userModel.creationDate), "creationDate", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, UserTable.getSqlTimestamp(userModel.saveDate), "saveDate", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, UserTable.getSqlTimestamp(userModel.tosAcceptanceDate), "tosAcceptanceDate", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, UserTable.getSqlTimestamp(userModel.lastLoginDate), "lastLoginDate", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, UserTable.getSqlTimestamp(userModel.lastLoginCredentialUpdateDate), "lastLoginCredentialUpdateDate", concatAndOr, andOr);
        concatAndOr = this.addParamToQuery(params, query, UserTable.getSqlTimestamp(userModel.expirationDate), "expirationDate", concatAndOr, andOr);
        if (!UserState.UNKNOWN.equals((Object)UserState.from(userModel.state))) {
            concatAndOr = this.addParamToQuery(params, query, userModel.state, "state", concatAndOr, andOr);
        }
        concatAndOr = this.addParamToQuery(params, query, UserTable.getSqlTimestamp(userModel.stateSaveDate), "stateSaveDate", concatAndOr, andOr);
        if (userModel.notifManualReceiverLimit != null) {
            concatAndOr = this.addParamToQuery(params, query, userModel.notifManualReceiverLimit, "notifManualReceiverLimit", concatAndOr, andOr);
        }
        if (concatAndOr) {
            query.append(") AND (state <> 'DELETED')");
        } else {
            query.append(" WHERE (state <> 'DELETED')");
        }
        query.append(" order by UPPER(lastName)");
        return concatAndOr;
    }

    public String[] searchUsersIds(List<String> userIds, UserRow userModel) throws AdminPersistenceException {
        boolean concatAndOr = false;
        String andOr = ") AND (";
        ArrayList<Object> params = new ArrayList<Object>();
        boolean manualFiltering = userIds != null && !userIds.isEmpty() && userIds.size() > 100;
        StringBuilder query = new StringBuilder(SELECT_SEARCH_USERSID);
        if (userIds != null && !userIds.isEmpty() && userIds.size() <= 100) {
            query.append(" WHERE (id IN (").append(UserTable.list2String(userIds)).append(") ");
            concatAndOr = true;
        }
        if (userModel.domainId >= 0) {
            concatAndOr = this.addIdToQuery(params, query, userModel.domainId, "domainId", concatAndOr, andOr);
        }
        this.addCommonUserParamToQuery(params, query, userModel, concatAndOr, andOr);
        List<String> result = this.getIds(query.toString(), params);
        if (manualFiltering) {
            result.retainAll(userIds);
        }
        return result.toArray(new String[result.size()]);
    }

    public UserRow[] searchUsers(UserRow userModel, boolean isAnd) throws AdminPersistenceException {
        boolean concatAndOr = false;
        String andOr = isAnd ? ") AND (" : ") OR (";
        StringBuilder query = new StringBuilder(SELECT_SEARCH_USERS);
        ArrayList<Object> params = new ArrayList<Object>();
        concatAndOr = this.addIdToQuery(params, query, userModel.domainId, "domainId", concatAndOr, andOr);
        this.addCommonUserParamToQuery(params, query, userModel, concatAndOr, andOr);
        List<UserRow> rows = this.getRows(query.toString(), params);
        return rows.toArray(new UserRow[rows.size()]);
    }

    public UserRow[] getUsersByEmail(String email) throws AdminPersistenceException {
        List<UserRow> users = this.getRows(SELECT_SEARCH_BY_EMAIL, Collections.singletonList(email));
        return users.toArray(new UserRow[users.size()]);
    }

    public void createUser(UserRow user) throws AdminPersistenceException {
        SynchroReport.debug("UserTable.createUser()", "Ajout de " + user.login + ", requ\u00eate : " + INSERT_USER, null);
        this.insertRow(INSERT_USER, user);
        CallBackManager callBackManager = CallBackManager.get();
        callBackManager.invoke(0, user.id, null, null);
    }

    @Override
    protected void prepareInsert(String insertQuery, PreparedStatement insert, UserRow row) throws SQLException {
        if (row.id == -1) {
            row.id = this.getNextId();
        }
        insert.setInt(1, row.id);
        insert.setString(2, UserTable.truncate(row.specificId, 500));
        insert.setInt(3, row.domainId);
        insert.setString(4, UserTable.truncate(row.login, 50));
        insert.setString(5, UserTable.truncate(row.firstName, 100));
        insert.setString(6, UserTable.truncate(row.lastName, 100));
        insert.setString(7, UserTable.truncate(row.loginMail, 100));
        insert.setString(8, UserTable.truncate(row.eMail, 100));
        insert.setString(9, UserTable.truncate(row.accessLevel, 1));
        insert.setString(10, UserTable.truncate(row.loginQuestion, 200));
        insert.setString(11, UserTable.truncate(row.loginAnswer, 200));
        Timestamp now = UserTable.getSqlTimestamp(new Date());
        insert.setTimestamp(12, now);
        insert.setTimestamp(13, now);
        insert.setInt(14, 0);
        insert.setTimestamp(15, UserTable.getSqlTimestamp(row.tosAcceptanceDate));
        insert.setTimestamp(16, UserTable.getSqlTimestamp(row.lastLoginDate));
        insert.setInt(17, row.nbSuccessfulLoginAttempts);
        insert.setTimestamp(18, UserTable.getSqlTimestamp(row.lastLoginCredentialUpdateDate));
        insert.setTimestamp(19, UserTable.getSqlTimestamp(row.expirationDate));
        insert.setString(20, !UserState.UNKNOWN.equals((Object)UserState.from(row.state)) ? row.state : UserState.VALID.name());
        insert.setTimestamp(21, now);
        insert.setObject(22, row.notifManualReceiverLimit);
    }

    public void updateUser(UserRow user) throws AdminPersistenceException {
        SynchroReport.debug("UserTable.updateUser()", "Maj de " + user.login + ", Id=" + user.id + ", requ\u00eate : " + UPDATE_USER, null);
        this.updateRow(UPDATE_USER, user);
    }

    @Override
    protected void prepareUpdate(String updateQuery, PreparedStatement update, UserRow row) throws SQLException {
        update.setString(1, UserTable.truncate(row.specificId, 500));
        update.setInt(2, row.domainId);
        update.setString(3, UserTable.truncate(row.login, 50));
        update.setString(4, UserTable.truncate(row.firstName, 100));
        update.setString(5, UserTable.truncate(row.lastName, 100));
        update.setString(6, UserTable.truncate(row.loginMail, 100));
        update.setString(7, UserTable.truncate(row.eMail, 100));
        update.setString(8, UserTable.truncate(row.accessLevel, 1));
        update.setString(9, UserTable.truncate(row.loginQuestion, 200));
        update.setString(10, UserTable.truncate(row.loginAnswer, 200));
        update.setTimestamp(11, UserTable.getSqlTimestamp(new Date()));
        update.setInt(12, row.version + 1);
        update.setTimestamp(13, UserTable.getSqlTimestamp(row.tosAcceptanceDate));
        update.setTimestamp(14, UserTable.getSqlTimestamp(row.lastLoginDate));
        update.setInt(15, row.nbSuccessfulLoginAttempts);
        update.setTimestamp(16, UserTable.getSqlTimestamp(row.lastLoginCredentialUpdateDate));
        update.setTimestamp(17, UserTable.getSqlTimestamp(row.expirationDate));
        update.setString(18, row.state);
        update.setTimestamp(19, UserTable.getSqlTimestamp(row.stateSaveDate));
        update.setObject(20, row.notifManualReceiverLimit);
        update.setInt(21, row.id);
    }

    public void removeUser(int id) throws AdminPersistenceException {
        SpaceUserRoleRow[] spaceRoles;
        UserRoleRow[] roles;
        GroupRow[] groups;
        CallBackManager callBackManager = CallBackManager.get();
        callBackManager.invoke(1, id, null, null);
        UserRow user = this.getUser(id);
        if (user == null) {
            return;
        }
        SynchroReport.info("UserTable.removeUser()", "Suppression de " + user.login + " des groupes dans la base", null);
        for (GroupRow group : groups = this.organization.group.getDirectGroupsOfUser(id)) {
            this.organization.group.removeUserFromGroup(id, group.id);
        }
        SynchroReport.info("UserTable.removeUser()", "Suppression de " + user.login + " des r\u00f4les dans la base", null);
        for (UserRoleRow role : roles = this.organization.userRole.getDirectUserRolesOfUser(id)) {
            this.organization.userRole.removeUserFromUserRole(id, role.id);
        }
        SynchroReport.info("UserTable.removeUser()", "Suppression de " + user.login + " en tant que manager d'espace dans la base", null);
        for (SpaceUserRoleRow spaceRole : spaceRoles = this.organization.spaceUserRole.getDirectSpaceUserRolesOfUser(id)) {
            this.organization.spaceUserRole.removeUserFromSpaceUserRole(id, spaceRole.id);
        }
        SynchroReport.info("UserTable.removeUser()", "Delete " + user.login + " from user favorite space table", null);
        UserFavoriteSpaceDAO ufsDAO = DAOFactory.getUserFavoriteSpaceDAO();
        if (!ufsDAO.removeUserFavoriteSpace(new UserFavoriteSpaceVO(id, -1))) {
            throw new AdminPersistenceException("UserTable.removeUser()", 4, "admin.EX_ERR_DELETE_USER");
        }
        SynchroReport.debug("UserTable.removeUser()", "Suppression de " + user.login + " (ID=" + id + "), requ\u00eate : " + DELETE_USER, null);
        user.login = "???REM???" + Integer.toString(id);
        user.specificId = "???REM???" + Integer.toString(id);
        if (!UserState.DELETED.name().equals(user.state)) {
            user.state = UserState.DELETED.name();
            user.stateSaveDate = new Date();
        }
        this.updateRow(UPDATE_USER, user);
    }

    private static String list2String(List<String> ids) {
        StringBuilder str = new StringBuilder(ids.size() * 3);
        for (int i = 0; i < ids.size(); ++i) {
            if (i != 0) {
                str.append(",");
            }
            str.append(ids.get(i));
        }
        return str.toString();
    }

    @Override
    protected UserRow fetchRow(ResultSet rs) throws SQLException {
        return this.fetchUser(rs);
    }
}

