/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util;

import com.silverpeas.util.EncodeHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class ClientBrowserUtil {
    public static final Pattern MOZILLA = Pattern.compile("(?i).*gecko.*");
    public static final Pattern MOZILLA_LIKE = Pattern.compile("(?i).*like.gecko.*");
    public static final Pattern CHROME = Pattern.compile(".*[C,c][H,h][R,r][O,o][M,m][E,e].*");
    public static final Pattern MSIE = Pattern.compile(".*[M,m][S,s][I,i][E,e].*");
    public static final Pattern MICROSOFT = Pattern.compile(".*[M,m][I,i][C,c][R,r][O,o][S,s][O,o][F,f][T,t].*");
    public static final Pattern OPERA = Pattern.compile(".*[O,o][P,p][E,e][R,r][A,a].*");
    public static final Pattern SAFARI = Pattern.compile(".*[S,s][A,a][F,f][A,a][R,r][I,i].*");
    public static final Pattern KONQUEROR = Pattern.compile(".*[K,k][O,o][N,n][Q,q][U,u][E,e][R,r][O,o][R,r].*");
    public static final Pattern LINUX = Pattern.compile(".*[L,l][I,i][N,n][U,u][X,x].*");
    public static final Pattern WINDOWS = Pattern.compile(".*[W,w][I,ia][N,n].*");
    public static final Pattern MAC = Pattern.compile(".*[M,m][A,a][C,c].*");
    public static final Pattern FREEBSD = Pattern.compile(".*[F,f][R,r][E,e][E,e][B,b][S,s][D,d].*");
    public static final Pattern UNIX = Pattern.compile(".*[X,x][11].*");

    public static boolean isWindows(HttpServletRequest request) {
        return ClientBrowserUtil.isWindows(ClientBrowserUtil.getUserAgent(request));
    }

    public static boolean isWindows(String userAgent) {
        Matcher match = WINDOWS.matcher(userAgent);
        return match.matches();
    }

    public static boolean isMacintosh(HttpServletRequest request) {
        return ClientBrowserUtil.isMacintosh(ClientBrowserUtil.getUserAgent(request));
    }

    public static boolean isMacintosh(String userAgent) {
        Matcher match = MAC.matcher(userAgent);
        return match.matches();
    }

    public static boolean isUnix(HttpServletRequest request) {
        return ClientBrowserUtil.isUnix(ClientBrowserUtil.getUserAgent(request));
    }

    public static boolean isUnix(String userAgent) {
        Matcher matchBsd = FREEBSD.matcher(userAgent);
        Matcher matchLinux = LINUX.matcher(userAgent);
        Matcher matchUnix = UNIX.matcher(userAgent);
        return matchLinux.matches() || matchBsd.matches() || matchUnix.matches();
    }

    public static boolean isFirefox(HttpServletRequest request) {
        return ClientBrowserUtil.isFirefox(ClientBrowserUtil.getUserAgent(request));
    }

    public static boolean isFirefox(String userAgent) {
        Matcher matchMoz = MOZILLA.matcher(userAgent);
        Matcher matchMozLike = MOZILLA_LIKE.matcher(userAgent);
        Matcher matchChrome = CHROME.matcher(userAgent);
        return matchMoz.matches() && !matchMozLike.matches() && !matchChrome.matches();
    }

    public static boolean isSafari(HttpServletRequest request) {
        return ClientBrowserUtil.isSafari(ClientBrowserUtil.getUserAgent(request));
    }

    public static boolean isSafari(String userAgent) {
        Matcher matchSafari = SAFARI.matcher(userAgent);
        Matcher matchChrome = CHROME.matcher(userAgent);
        return matchSafari.matches() && !matchChrome.matches();
    }

    public static boolean isChrome(HttpServletRequest request) {
        return ClientBrowserUtil.isChrome(ClientBrowserUtil.getUserAgent(request));
    }

    public static boolean isChrome(String userAgent) {
        Matcher matchChrome = CHROME.matcher(userAgent);
        return matchChrome.matches();
    }

    public static boolean isOpera(HttpServletRequest request) {
        return ClientBrowserUtil.isOpera(ClientBrowserUtil.getUserAgent(request));
    }

    public static boolean isOpera(String userAgent) {
        Matcher match = OPERA.matcher(userAgent);
        return match.matches();
    }

    public static boolean isInternetExplorer(HttpServletRequest request) {
        return ClientBrowserUtil.isInternetExplorer(ClientBrowserUtil.getUserAgent(request));
    }

    public static boolean isInternetExplorer(String userAgent) {
        Matcher matchIe = MSIE.matcher(userAgent);
        Matcher matchMs = MICROSOFT.matcher(userAgent);
        return matchIe.matches() || matchMs.matches();
    }

    public static boolean isKonqueror(HttpServletRequest request) {
        return ClientBrowserUtil.isKonqueror(ClientBrowserUtil.getUserAgent(request));
    }

    public static boolean isKonqueror(String userAgent) {
        Matcher match = KONQUEROR.matcher(userAgent);
        return match.matches();
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader("User-Agent");
    }

    public static String rfc2047EncodeFilename(HttpServletRequest request, String filename) {
        if (ClientBrowserUtil.isFirefox(request) || ClientBrowserUtil.isChrome(request) || ClientBrowserUtil.isSafari(request)) {
            return EncodeHelper.encodeFilename(filename);
        }
        return filename;
    }

    public static String rfc2047EncodeFilename(String userAgent, String filename) {
        if (ClientBrowserUtil.isFirefox(userAgent) || ClientBrowserUtil.isChrome(userAgent) || ClientBrowserUtil.isSafari(userAgent)) {
            return EncodeHelper.encodeFilename(filename);
        }
        return filename;
    }

    private ClientBrowserUtil() {
    }
}

