/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.webactiv.util.annotation;

import com.silverpeas.SilverpeasContent;
import com.silverpeas.admin.components.PasteDetailFromToPK;
import com.silverpeas.util.ForeignPK;
import com.silverpeas.util.MapUtil;
import com.stratelia.silverpeas.contentManager.SilverContentInterface;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.annotation.Language;
import com.stratelia.webactiv.util.annotation.SourcePK;
import com.stratelia.webactiv.util.annotation.TargetObject;
import com.stratelia.webactiv.util.annotation.TargetPK;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.interceptor.InvocationContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.silverpeas.attachment.model.SimpleDocument;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class AnnotationUtil {
    public static <A extends Annotation> Map<Class<A>, A> extractMethodAnnotations(InvocationContext invocationContext) throws Exception {
        return AnnotationUtil.extractMethodAnnotations(AnnotationUtil.getMethodFromContext(invocationContext));
    }

    public static <A extends Annotation> Map<Class<A>, A> extractMethodAnnotations(ProceedingJoinPoint invocationContext) throws Exception {
        return AnnotationUtil.extractMethodAnnotations(AnnotationUtil.getMethodFromContext(invocationContext));
    }

    private static <A extends Annotation> Map<Class<A>, A> extractMethodAnnotations(Method method) throws Exception {
        LinkedHashMap<Class<? extends Annotation>, Annotation> results = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : method.getAnnotations()) {
            results.put(annotation.annotationType(), annotation);
        }
        return results;
    }

    public static Map<Class<Annotation>, List<Object>> extractMethodAnnotedParameterValues(InvocationContext invocationContext) throws Exception {
        return AnnotationUtil.extractMethodAnnotedParameterValues(AnnotationUtil.getMethodFromContext(invocationContext), invocationContext.getParameters());
    }

    public static Map<Class<Annotation>, List<Object>> extractMethodAnnotedParameterValues(ProceedingJoinPoint invocationContext) throws Exception {
        return AnnotationUtil.extractMethodAnnotedParameterValues(AnnotationUtil.getMethodFromContext(invocationContext), invocationContext.getArgs());
    }

    private static Map<Class<Annotation>, List<Object>> extractMethodAnnotedParameterValues(Method method, Object[] parameterValues) throws Exception {
        LinkedHashMap<Class<? extends Annotation>, List<Object>> results = new LinkedHashMap<Class<? extends Annotation>, List<Object>>();
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            Annotation[] parameterAnnotations = annotations[i];
            if (parameterAnnotations.length <= 0) continue;
            for (Annotation parameterAnnotation : parameterAnnotations) {
                Object parameterValue = parameterValues[i];
                if (parameterValue == null) continue;
                if (parameterAnnotation.annotationType().isAssignableFrom(SourcePK.class) || parameterAnnotation.annotationType().isAssignableFrom(TargetPK.class)) {
                    if (parameterValue instanceof Collection) {
                        for (Object value : (Collection)parameterValue) {
                            AnnotationUtil.addPKParameterValue(results, parameterAnnotation.annotationType(), value);
                        }
                        continue;
                    }
                    AnnotationUtil.addPKParameterValue(results, parameterAnnotation.annotationType(), parameterValue);
                    continue;
                }
                if (parameterAnnotation.annotationType().isAssignableFrom(TargetObject.class)) {
                    MapUtil.putAddList(results, parameterAnnotation.annotationType(), parameterValue);
                    continue;
                }
                if (!parameterAnnotation.annotationType().isAssignableFrom(Language.class)) continue;
                String language = null;
                if (parameterValue instanceof String) {
                    language = (String)parameterValue;
                } else if (parameterValue instanceof Locale) {
                    language = ((Locale)parameterValue).getLanguage();
                }
                MapUtil.putAddList(results, parameterAnnotation.annotationType(), language);
            }
        }
        return results;
    }

    private static void addPKParameterValue(Map<Class<? extends Annotation>, List<Object>> parameterValues, Class<? extends Annotation> annotationClass, Object object) {
        WAPrimaryKey waPrimaryKey = null;
        if (object instanceof SilverpeasContent) {
            SilverpeasContent silverpeasContent = (SilverpeasContent)object;
            waPrimaryKey = new ForeignPK(silverpeasContent.getId(), silverpeasContent.getComponentInstanceId());
        } else if (object instanceof SilverContentInterface) {
            SilverContentInterface silverContentInterface = (SilverContentInterface)object;
            waPrimaryKey = new ForeignPK(silverContentInterface.getId(), silverContentInterface.getInstanceId());
        } else if (object instanceof PasteDetailFromToPK) {
            PasteDetailFromToPK pasteDetail = (PasteDetailFromToPK)object;
            waPrimaryKey = SourcePK.class.equals(annotationClass) ? pasteDetail.getFromPK() : pasteDetail.getToPK();
        } else if (object instanceof WAPrimaryKey) {
            waPrimaryKey = (WAPrimaryKey)object;
        } else if (object instanceof SimpleDocument) {
            waPrimaryKey = ((SimpleDocument)object).getPk();
        } else if (object != null) {
            throw new NotImplementedException();
        }
        if (waPrimaryKey != null) {
            MapUtil.putAddList(parameterValues, annotationClass, waPrimaryKey);
        }
    }

    public static List<Object> getAnnotedValues(Map<Class<Annotation>, List<Object>> annotedValues, Class<? extends Annotation> annotationClass) {
        List<Object> result = null;
        if (annotedValues != null) {
            result = annotedValues.get(annotationClass);
        }
        if (result == null) {
            result = new ArrayList<Object>(0);
        }
        return result;
    }

    private static Method getMethodFromContext(Object invocationContext) throws Exception {
        if (invocationContext instanceof ProceedingJoinPoint) {
            ProceedingJoinPoint context = (ProceedingJoinPoint)invocationContext;
            String methodName = context.getSignature().getName();
            MethodSignature methodSignature = (MethodSignature)context.getSignature();
            Method method = methodSignature.getMethod();
            if (method.getDeclaringClass().isInterface()) {
                method = context.getTarget().getClass().getDeclaredMethod(methodName, method.getParameterTypes());
            }
            return method;
        }
        if (invocationContext instanceof InvocationContext) {
            return ((InvocationContext)invocationContext).getMethod();
        }
        throw new NotImplementedException();
    }
}

