/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.domain;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.Admin;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.Domain;
import org.silverpeas.admin.domain.DomainService;
import org.silverpeas.admin.domain.exception.DomainCreationException;
import org.silverpeas.admin.domain.exception.DomainDeletionException;
import org.silverpeas.admin.domain.exception.NameAlreadyExistsInDatabaseException;

public abstract class AbstractDomainService
implements DomainService {
    protected void checkDomainName(String domainName) throws AdminException, NameAlreadyExistsInDatabaseException {
        Domain[] tabDomain;
        Admin adminService = AdminReference.getAdminService();
        for (Domain domain : tabDomain = adminService.getAllDomains()) {
            if (!domain.getName().equalsIgnoreCase(domainName)) continue;
            throw new NameAlreadyExistsInDatabaseException(domainName);
        }
    }

    protected String getNextDomainId() throws DomainCreationException {
        SilverTrace.info("admin", "AbstractDomainService.getNextDomainId()", "root.MSG_GEN_ENTER_METHOD");
        Admin adminService = AdminReference.getAdminService();
        try {
            return adminService.getNextDomainId();
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "AAbstractDomainService.getNextDomainId()", "admin.EX_ADD_DOMAIN", e);
            throw new DomainCreationException("AbstractDomainService.getNextDomainId()", e);
        }
    }

    protected String registerDomain(Domain domainToCreate) throws DomainCreationException {
        SilverTrace.info("admin", "AbstractDomainService.registerDomain()", "root.MSG_GEN_ENTER_METHOD");
        if (StringUtil.isNotDefined(domainToCreate.getId())) {
            domainToCreate.setId("-1");
        }
        Admin adminService = AdminReference.getAdminService();
        try {
            return adminService.addDomain(domainToCreate);
        }
        catch (AdminException e) {
            SilverTrace.error("admin", "AAbstractDomainService.registerDomain()", "admin.EX_ADD_DOMAIN", e);
            throw new DomainCreationException("AbstractDomainService.registerDomain()", e);
        }
    }

    protected String unRegisterDomain(Domain domainToRemove) throws DomainDeletionException {
        SilverTrace.info("admin", "AbstractDomainService.unRegisterDomain()", "root.MSG_GEN_ENTER_METHOD");
        Admin adminService = AdminReference.getAdminService();
        try {
            return adminService.removeDomain(domainToRemove.getId());
        }
        catch (AdminException e) {
            throw new DomainDeletionException("AbstractDomainService.unRegisterDomain()", e);
        }
    }
}

