/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.domain;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.admin.domain.DomainService;
import org.silverpeas.admin.domain.DomainType;
import org.silverpeas.admin.domain.quota.UserDomainQuotaKey;
import org.silverpeas.quota.service.QuotaService;

public class DomainServiceFactory {
    private static final DomainServiceFactory instance = new DomainServiceFactory();
    @Inject
    @Named(value="externalDomainService")
    private DomainService externalDomainService;
    @Inject
    @Named(value="sqlDomainService")
    private DomainService sqlDomainService;
    @Inject
    @Named(value="userDomainQuotaService")
    private QuotaService<UserDomainQuotaKey> userDomainQuotaService;

    public static DomainServiceFactory getFactory() {
        return instance;
    }

    public static DomainService getDomainService(DomainType type) {
        switch (type) {
            case EXTERNAL: {
                if (DomainServiceFactory.getFactory().externalDomainService == null) {
                    SilverTrace.error("admin", DomainServiceFactory.getFactory().getClass().getSimpleName() + ".getDomainService()", "EX_NO_MESSAGES", "IoC container not bootstrapped or no DomainService named 'silverpeasDomainService' bean found!");
                }
                return DomainServiceFactory.getFactory().externalDomainService;
            }
            case SQL: {
                if (DomainServiceFactory.getFactory().sqlDomainService == null) {
                    SilverTrace.error("admin", DomainServiceFactory.getFactory().getClass().getSimpleName() + ".getDomainService()", "EX_NO_MESSAGES", "IoC container not bootstrapped or no DomainService named 'sqlDomainService' bean found!");
                }
                return DomainServiceFactory.getFactory().sqlDomainService;
            }
        }
        SilverTrace.error("admin", DomainServiceFactory.getFactory().getClass().getSimpleName() + ".getDomainService()", "EX_NO_MESSAGES", "Only SQL and SILVERPEAS Domain Services are implemented");
        return null;
    }

    public static QuotaService<UserDomainQuotaKey> getUserDomainQuotaService() {
        return DomainServiceFactory.getFactory().userDomainQuotaService;
    }

    private DomainServiceFactory() {
    }
}

