/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.admin.domain;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.FileServerUtils;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.Normalizer;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.silverpeas.admin.domain.AbstractDomainService;
import org.silverpeas.admin.domain.exception.DomainAuthenticationPropertiesAlreadyExistsException;
import org.silverpeas.admin.domain.exception.DomainConflictException;
import org.silverpeas.admin.domain.exception.DomainCreationException;
import org.silverpeas.admin.domain.exception.DomainDeletionException;
import org.silverpeas.admin.domain.exception.DomainPropertiesAlreadyExistsException;
import org.silverpeas.admin.domain.repository.SQLDomainRepository;

@Named(value="sqlDomainService")
public class SQLDomainService
extends AbstractDomainService {
    ResourceLocator templateSettings;
    ResourceLocator adminSettings;
    private static final String DATABASE_TABLE_NAME_DOMAIN_PREFIX = "Domain";
    private static final String DATABASE_TABLE_NAME_DOMAIN_USER_SUFFIX = "_User";
    private static final String DATABASE_TABLE_NAME_DOMAIN_GROUP_SUFFIX = "_Group";
    private static final String DATABASE_TABLE_NAME_DOMAIN_USER_GROUP_SUFFIX = "_Group_User_Rel";
    @Inject
    @Named(value="sqlInternalDomainRepository")
    SQLDomainRepository dao;

    @PostConstruct
    void init() {
        this.templateSettings = new ResourceLocator("org.silverpeas.domains.templateDomainSQL", "");
        this.adminSettings = new ResourceLocator("org.silverpeas.beans.admin.admin", "");
    }

    private void checkFileName(String fileDomainName) throws DomainAuthenticationPropertiesAlreadyExistsException, DomainPropertiesAlreadyExistsException {
        String authenticationPropertiesPath = FileRepositoryManager.getDomainAuthenticationPropertiesPath(fileDomainName);
        String domainPropertiesPath = FileRepositoryManager.getDomainPropertiesPath(fileDomainName);
        if (new File(authenticationPropertiesPath).exists()) {
            SilverTrace.error("admin", "SQLDomainService.checkFileName", "admin.MSG_ERR_DOMAIN_ALREADY_EXIST_DOMAIN_PROPERTIES", fileDomainName);
            throw new DomainAuthenticationPropertiesAlreadyExistsException(fileDomainName);
        }
        if (new File(domainPropertiesPath).exists()) {
            SilverTrace.error("admin", "SQLDomainService.checkFileName", "admin.MSG_ERR_DOMAIN_ALREADY_EXIST_DOMAIN_PROPERTIES", fileDomainName);
            throw new DomainPropertiesAlreadyExistsException(fileDomainName);
        }
    }

    protected String getTechnicalDomainName(Domain domain) {
        String fileDomainName = FileServerUtils.replaceAccentChars(domain.getName());
        fileDomainName = Normalizer.normalize(fileDomainName, Normalizer.Form.NFKD);
        fileDomainName = fileDomainName.replaceAll("[^\\p{Alnum}]+", "");
        int maxTableNameSuffixLength = Math.max(DATABASE_TABLE_NAME_DOMAIN_USER_SUFFIX.length(), DATABASE_TABLE_NAME_DOMAIN_GROUP_SUFFIX.length());
        maxTableNameSuffixLength = Math.max(maxTableNameSuffixLength, DATABASE_TABLE_NAME_DOMAIN_USER_GROUP_SUFFIX.length());
        int maxLength = 30 - DATABASE_TABLE_NAME_DOMAIN_PREFIX.length() - maxTableNameSuffixLength - domain.getId().length();
        return domain.getId() + StringUtil.left((String)fileDomainName, (int)maxLength);
    }

    @Override
    public String createDomain(Domain domainToCreate) throws DomainConflictException, DomainCreationException {
        String initialDomainName = domainToCreate.getName();
        try {
            this.checkDomainName(initialDomainName);
        }
        catch (AdminException e) {
            throw new DomainConflictException("SQLDomainService.createDomain", domainToCreate.toString(), e);
        }
        String domainId = this.getNextDomainId();
        domainToCreate.setId(domainId);
        String technicalDomainName = this.getTechnicalDomainName(domainToCreate);
        this.checkFileName(technicalDomainName);
        try {
            domainToCreate.setName(technicalDomainName);
            this.generateDomainPropertiesFile(domainToCreate);
            this.generateDomainAuthenticationPropertiesFile(domainToCreate);
            this.dao.createDomainStorage(domainToCreate);
            if (!StringUtil.isDefined(domainToCreate.getDriverClassName())) {
                domainToCreate.setDriverClassName("com.stratelia.silverpeas.domains.sqldriver.SQLDriver");
            }
            domainToCreate.setPropFileName("org.silverpeas.domains.domain" + technicalDomainName);
            domainToCreate.setAuthenticationServer("autDomain" + technicalDomainName);
            domainToCreate.setTheTimeStamp("0");
            domainToCreate.setName(initialDomainName);
            this.registerDomain(domainToCreate);
        }
        catch (Exception e) {
            try {
                this.removePropertiesFiles(technicalDomainName);
            }
            catch (Exception anyE) {
                // empty catch block
            }
            try {
                domainToCreate.setName(technicalDomainName);
                this.dao.deleteDomainStorage(domainToCreate);
            }
            catch (Exception anyE) {
                // empty catch block
            }
            try {
                domainToCreate.setName(initialDomainName);
                this.unRegisterDomain(domainToCreate);
            }
            catch (Exception anyE) {
                // empty catch block
            }
            if (e instanceof DomainCreationException) {
                throw (DomainCreationException)e;
            }
            throw new DomainCreationException("SQLDomainService.createDomain", domainToCreate.toString(), e);
        }
        return domainId;
    }

    @Override
    public String deleteDomain(Domain domainToRemove) throws DomainDeletionException {
        String separator = "#@#@#@#@#";
        String domainPropertyPrefix = new File(FileRepositoryManager.getDomainPropertiesPath(separator).replaceAll(separator + ".*$", "")).getName();
        String domainPropertyFileName = domainToRemove.getPropFileName().replaceAll("[\\p{Alnum}]+\\.+", "");
        String fileDomainName = domainPropertyFileName.replaceFirst(domainPropertyPrefix, "");
        domainToRemove.setName(fileDomainName);
        String domainId = this.unRegisterDomain(domainToRemove);
        if (!StringUtil.isDefined(domainId)) {
            throw new DomainDeletionException("SQLDomainService.deleteDomain");
        }
        try {
            this.dao.deleteDomainStorage(domainToRemove);
        }
        catch (Exception e) {
            throw new DomainDeletionException("SQLDomainService.deleteDomain", e);
        }
        this.removeDomainPropertiesFile(domainToRemove);
        return domainId;
    }

    private void removePropertiesFiles(String domainName) {
        String authenticationPropertiesPath = FileRepositoryManager.getDomainAuthenticationPropertiesPath(domainName);
        String domainPropertiesPath = FileRepositoryManager.getDomainPropertiesPath(domainName);
        new File(authenticationPropertiesPath).delete();
        new File(domainPropertiesPath).delete();
    }

    private void generateDomainPropertiesFile(Domain domainToCreate) throws DomainCreationException {
        SilverTrace.info("admin", "SQLDomainService.generateDomainPropertiesFile()", "root.MSG_GEN_ENTER_METHOD");
        String domainName = domainToCreate.getName();
        String domainPropertiesPath = FileRepositoryManager.getDomainPropertiesPath(domainName);
        SilverpeasTemplate template = this.getNewTemplate();
        template.setAttribute("SQLClassName", this.adminSettings.getString("AdminDBDriver"));
        template.setAttribute("SQLJDBCUrl", this.adminSettings.getString("WaProductionDb"));
        template.setAttribute("SQLAccessLogin", this.adminSettings.getString("WaProductionUser"));
        template.setAttribute("SQLAccessPasswd", this.adminSettings.getString("WaProductionPswd"));
        template.setAttribute("SQLUserTableName", DATABASE_TABLE_NAME_DOMAIN_PREFIX + domainName + DATABASE_TABLE_NAME_DOMAIN_USER_SUFFIX);
        template.setAttribute("SQLGroupTableName", DATABASE_TABLE_NAME_DOMAIN_PREFIX + domainName + DATABASE_TABLE_NAME_DOMAIN_GROUP_SUFFIX);
        template.setAttribute("SQLUserGroupTableName", DATABASE_TABLE_NAME_DOMAIN_PREFIX + domainName + DATABASE_TABLE_NAME_DOMAIN_USER_GROUP_SUFFIX);
        File domainPropertiesFile = new File(domainPropertiesPath);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(domainPropertiesFile));
            out.print(template.applyFileTemplate("templateDomainSQL"));
        }
        catch (IOException e) {
            domainPropertiesFile.delete();
            throw new DomainCreationException("SQLDomainService.generateDomainPropertiesFile()", domainToCreate.toString(), e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void generateDomainAuthenticationPropertiesFile(Domain domainToCreate) throws DomainCreationException {
        SilverTrace.info("admin", "SQLDomainService.generateDomainAuthenticationPropertiesFile()", "root.MSG_GEN_ENTER_METHOD");
        String domainName = domainToCreate.getName();
        String domainPropertiesPath = FileRepositoryManager.getDomainPropertiesPath(domainName);
        String authenticationPropertiesPath = FileRepositoryManager.getDomainAuthenticationPropertiesPath(domainName);
        boolean allowPasswordChange = this.templateSettings.getBoolean("allowPasswordChange", true);
        SilverpeasTemplate template = this.getNewTemplate();
        template.setAttribute("allowPasswordChange", allowPasswordChange);
        template.setAttribute("SQLDriverClass", this.adminSettings.getString("AdminDBDriver"));
        template.setAttribute("SQLJDBCUrl", this.adminSettings.getString("WaProductionDb"));
        template.setAttribute("SQLAccessLogin", this.adminSettings.getString("WaProductionUser"));
        template.setAttribute("SQLAccessPasswd", this.adminSettings.getString("WaProductionPswd"));
        template.setAttribute("SQLUserTableName", DATABASE_TABLE_NAME_DOMAIN_PREFIX + domainName + DATABASE_TABLE_NAME_DOMAIN_USER_SUFFIX);
        File domainPropertiesFile = new File(domainPropertiesPath);
        File authenticationPropertiesFile = new File(authenticationPropertiesPath);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(authenticationPropertiesFile));
            out.print(template.applyFileTemplate("templateDomainAuthenticationSQL"));
        }
        catch (IOException e) {
            domainPropertiesFile.delete();
            authenticationPropertiesFile.delete();
            throw new DomainCreationException("SQLDomainService.generateDomainAuthenticationPropertiesFile()", domainToCreate.toString(), e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void removeDomainPropertiesFile(Domain domainToRemove) {
        SilverTrace.info("admin", "SQLDomainService.removeDomainAuthenticationPropertiesFile()", "root.MSG_GEN_ENTER_METHOD");
        String domainName = domainToRemove.getName();
        String domainPropertiesPath = FileRepositoryManager.getDomainPropertiesPath(domainName);
        String authenticationPropertiesPath = FileRepositoryManager.getDomainAuthenticationPropertiesPath(domainName);
        File domainPropertiesFile = new File(domainPropertiesPath);
        File authenticationPropertiesFile = new File(authenticationPropertiesPath);
        boolean domainPropertiesFileDeleted = domainPropertiesFile.delete();
        boolean authenticationPropertiesFileDeleted = authenticationPropertiesFile.delete();
        if (!domainPropertiesFileDeleted || !authenticationPropertiesFileDeleted) {
            SilverTrace.warn("admin", "SQLDomainService.removeDomainAuthenticationPropertiesFile()", "admin.EX_DELETE_DOMAIN_PROPERTIES", "domainPropertiesFileDeleted:" + domainPropertiesFileDeleted + ", authenticationPropertiesFileDeleted:" + authenticationPropertiesFileDeleted);
        }
    }

    private SilverpeasTemplate getNewTemplate() {
        return SilverpeasTemplateFactory.createSilverpeasTemplateOnCore("admin/sqlDomain");
    }
}

