/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment;

import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.attachment.ActifyDocumentProcessScheduler;
import org.silverpeas.attachment.model.SimpleDocument;

public class ActifyDocumentProcessor {
    private static final ResourceLocator settings = new ResourceLocator("org.silverpeas.util.attachment.Attachment", "");
    private static final Logger logger = Logger.getLogger(ActifyDocumentProcessScheduler.class.getSimpleName());
    private static final ActifyDocumentProcessor instance = new ActifyDocumentProcessor();

    public static boolean isActifySupportEnabled() {
        return settings.getBoolean("ActifyPublisherEnable", false);
    }

    public static String getCRONForActifyImport() {
        return settings.getString("ScheduledProcessActify");
    }

    public static String getCRONForActifyPurge() {
        return settings.getString("ScheduledPurgeActify");
    }

    public static String getActifySourcePath() {
        return FileRepositoryManager.getTemporaryPath() + settings.getString("ActifyPathSource");
    }

    public static String getActifyResultPath() {
        return FileRepositoryManager.getTemporaryPath() + settings.getString("ActifyPathResult");
    }

    public static String[] getSupportedCADExtensions() {
        String extensions = settings.getString("Actify3dFiles");
        if (StringUtil.isDefined(extensions)) {
            return extensions.split(",");
        }
        return new String[0];
    }

    public static int getDelayBeforeImport() {
        return Integer.parseInt(settings.getString("DelayBeforeProcess"));
    }

    public static int getDelayBeforePurge() {
        return Integer.parseInt(settings.getString("DelayBeforePurge"));
    }

    public static boolean isCADDocumentSupported(String fileName) {
        String[] extensions = ActifyDocumentProcessor.getSupportedCADExtensions();
        String type = FileRepositoryManager.getFileExtension(fileName);
        boolean fileForActify = false;
        for (int i = 0; i < extensions.length && !fileForActify; ++i) {
            fileForActify = type.equalsIgnoreCase(extensions[i]);
        }
        return fileForActify;
    }

    public static ActifyDocumentProcessor getProcessor() {
        return instance;
    }

    public void process(SimpleDocument document) throws IOException {
        if (ActifyDocumentProcessor.isActifySupportEnabled()) {
            String componentId = document.getPk().getInstanceId();
            String id = document.getForeignId();
            String fileName = document.getFilename();
            if (ActifyDocumentProcessor.isCADDocumentSupported(fileName)) {
                String normalizedFileName;
                logger.log(Level.INFO, "CAD document supported by Actify detected: {0}", fileName);
                String dirPrefix = document.isVersioned() ? "v_" : "a_";
                String dirDestName = dirPrefix + componentId + "_" + id;
                String actifyWorkingPath = ActifyDocumentProcessor.getActifySourcePath() + File.separatorChar + dirDestName;
                File destDir = new File(actifyWorkingPath);
                if (!destDir.exists()) {
                    FileUtils.forceMkdir((File)destDir);
                }
                if ((normalizedFileName = FilenameUtils.normalize((String)fileName)) == null) {
                    normalizedFileName = FilenameUtils.getName((String)fileName);
                }
                String destFile = actifyWorkingPath + File.separatorChar + normalizedFileName;
                FileRepositoryManager.copyFile(document.getAttachmentPath(), destFile);
            }
        }
    }

    private ActifyDocumentProcessor() {
        this.prepareActifyDirectories();
    }

    private void prepareActifyDirectories() {
        try {
            if (ActifyDocumentProcessor.isActifySupportEnabled()) {
                File dir = new File(ActifyDocumentProcessor.getActifySourcePath());
                if (!dir.exists()) {
                    FileUtils.forceMkdir((File)dir);
                }
                if (!(dir = new File(ActifyDocumentProcessor.getActifyResultPath())).exists()) {
                    FileUtils.forceMkdir((File)dir);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

