/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.model;

public enum DocumentType {
    attachment("attachments"),
    form("forms"),
    wysiwyg("wysiwyg"),
    image("images"),
    video("video"),
    node("node");

    private String folderName;

    private DocumentType(String folder) {
        this.folderName = folder;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public static DocumentType fromFolderName(String folder) {
        if (DocumentType.attachment.folderName.equals(folder)) {
            return attachment;
        }
        if (DocumentType.form.folderName.equals(folder)) {
            return form;
        }
        if (DocumentType.wysiwyg.folderName.equals(folder)) {
            return wysiwyg;
        }
        if (DocumentType.image.folderName.equals(folder)) {
            return image;
        }
        if (DocumentType.video.folderName.equals(folder)) {
            return video;
        }
        return attachment;
    }

    public String getName() {
        return this.name();
    }

    public static DocumentType decode(String name) {
        if (name != null) {
            for (DocumentType documentType : DocumentType.values()) {
                if (!documentType.name().equals(name)) continue;
                return documentType;
            }
        }
        return null;
    }
}

