/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.process;

import com.stratelia.webactiv.util.WAPrimaryKey;
import java.util.EnumSet;
import org.silverpeas.attachment.model.DocumentType;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.process.io.file.AbstractDummyHandledFile;

public class SimpleDocumentDummyHandledFile
extends AbstractDummyHandledFile {
    private static final EnumSet<DocumentType> technicalDocumentTypes = EnumSet.of(DocumentType.wysiwyg);
    private final SimpleDocument document;
    private boolean deleted = false;
    private WAPrimaryKey targetPK = null;

    public SimpleDocumentDummyHandledFile(SimpleDocument document) {
        this(document, false);
    }

    public SimpleDocumentDummyHandledFile(SimpleDocument document, WAPrimaryKey targetPK) {
        this(document);
        this.targetPK = targetPK;
    }

    public SimpleDocumentDummyHandledFile(SimpleDocument document, boolean deleted) {
        this.document = document;
        this.deleted = deleted;
    }

    @Override
    public String getComponentInstanceId() {
        if (this.targetPK != null) {
            return this.targetPK.getInstanceId();
        }
        return this.document.getInstanceId();
    }

    @Override
    public String getPath() {
        return this.document.getAttachmentPath();
    }

    @Override
    public String getName() {
        return this.document.getFilename();
    }

    @Override
    public long getSize() {
        return this.document.getSize();
    }

    @Override
    public String getMimeType() {
        if (technicalDocumentTypes.contains((Object)this.document.getDocumentType())) {
            return this.document.getDocumentType().getName();
        }
        return this.document.getAttachment().getContentType();
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }
}

