/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.attachment.webdav.impl;

import com.silverpeas.jcrutil.BasicDaoFactory;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.silverpeas.attachment.AttachmentException;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.attachment.webdav.WebdavRepository;
import org.silverpeas.attachment.webdav.WebdavService;

@Named(value="webdavService")
public class WebDavDocumentService
implements WebdavService {
    @Inject
    @Named(value="webdavRepository")
    private WebdavRepository webdavRepository;

    @Override
    public void updateDocumentContent(SimpleDocument document) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            this.webdavRepository.updateAttachmentBinaryContent(session, document);
            session.save();
        }
        catch (RepositoryException ex) {
            SilverTrace.error("attachment", "WebDavDocumentService", "attachment.jcr.create.exception", ex);
            throw new AttachmentException("WebDavDocumentService", 4, "attachment.jcr.create.exception", (Exception)((Object)ex));
        }
        catch (IOException ex) {
            SilverTrace.error("attachment", "WebDavDocumentService", "attachment.jcr.create.exception", ex);
            throw new AttachmentException("WebDavDocumentService", 4, "attachment.jcr.create.exception", ex);
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public String getContentEditionLanguage(SimpleDocument document) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            String string = this.webdavRepository.getContentEditionLanguage(session, document);
            return string;
        }
        catch (RepositoryException ex) {
            SilverTrace.error("attachment", "WebDavDocumentService", "attachment.jcr.node.notFound.exception", ex);
            throw new AttachmentException("WebDavDocumentService", 4, "attachment.jcr.node.notFound.exception", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }

    @Override
    public long getContentEditionSize(SimpleDocument document) {
        Session session = null;
        try {
            session = BasicDaoFactory.getSystemSession();
            long l = this.webdavRepository.getContentEditionSize(session, document);
            return l;
        }
        catch (RepositoryException ex) {
            SilverTrace.error("attachment", "WebDavDocumentService", "attachment.jcr.node.notFound.exception", ex);
            throw new AttachmentException("WebDavDocumentService", 4, "attachment.jcr.node.notFound.exception", (Exception)((Object)ex));
        }
        finally {
            BasicDaoFactory.logout(session);
        }
    }
}

