/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPJSSESecureSocketFactory;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import org.silverpeas.authentication.Authentication;
import org.silverpeas.authentication.AuthenticationConnection;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.exception.AuthenticationHostException;
import org.silverpeas.authentication.exception.AuthenticationPasswordAboutToExpireException;
import org.silverpeas.authentication.exception.AuthenticationPasswordExpired;
import org.silverpeas.authentication.exception.AuthenticationPasswordMustBeChangedAtNextLogon;
import org.silverpeas.util.Charsets;
import org.silverpeas.util.LdapConfiguration;

public class AuthenticationLDAP
extends Authentication {
    private static final int INTERVALS_PER_MILLISECOND = 10000;
    private static final long MILLISECONDS_BETWEEN_1601_AND_1970 = Long.parseLong("11644473600000");
    private static final String BASEDN_SEPARATOR = ";;";
    private static final int FORMAT_NANOSECOND = 0;
    private static final int FORMAT_TIMESTAMP = 1;
    protected boolean m_MustAlertPasswordExpiration = false;
    protected String m_PwdLastSetFieldName;
    protected int m_PwdLastSetFieldFormat;
    protected int m_PwdMaxAge;
    protected int m_PwdExpirationReminderDelay;
    protected String ldapImpl;
    protected String m_UserBaseDN;
    protected String m_UserLoginFieldName;
    protected LdapConfiguration configuration = new LdapConfiguration();

    @Override
    public void loadProperties(ResourceLocator settings) {
        String serverName = this.getServerName();
        this.configuration.setSecure(settings.getBoolean(serverName + ".LDAPSecured", false));
        this.configuration.setLdapHost(settings.getString(serverName + ".LDAPHost"));
        if (this.configuration.isSecure()) {
            this.configuration.setLdapPort(settings.getInteger(serverName + ".LDAPSecuredPort", 636));
        } else {
            this.configuration.setLdapPort(settings.getInteger(serverName + ".LDAPPort", 389));
        }
        this.configuration.setTimeout(settings.getInteger(serverName + ".Timeout", 0));
        this.ldapImpl = settings.getString(serverName + ".LDAPImpl");
        this.configuration.setUsername(settings.getString(serverName + ".LDAPAccessLogin"));
        this.configuration.setPassword(settings.getString(serverName + ".LDAPAccessPasswd").getBytes(Charsets.UTF_8));
        this.m_UserBaseDN = settings.getString(serverName + ".LDAPUserBaseDN");
        this.m_UserLoginFieldName = settings.getString(serverName + ".LDAPUserLoginFieldName");
        this.m_MustAlertPasswordExpiration = settings.getBoolean(serverName + ".MustAlertPasswordExpiration", false);
        if (this.m_MustAlertPasswordExpiration) {
            this.m_PwdLastSetFieldName = settings.getString(serverName + ".LDAPPwdLastSetFieldName");
            String propValue = settings.getString(serverName + ".LDAPPwdMaxAge");
            this.m_PwdMaxAge = propValue == null ? Integer.MAX_VALUE : Integer.parseInt(propValue);
            propValue = settings.getString(serverName + ".LDAPPwdLastSetFieldFormat");
            this.m_PwdLastSetFieldFormat = propValue == null || propValue.equals("nanoseconds") ? 0 : 1;
            propValue = settings.getString(serverName + ".PwdExpirationReminderDelay");
            int n = this.m_PwdExpirationReminderDelay = propValue == null ? 5 : Integer.parseInt(propValue);
            if (this.m_PwdLastSetFieldName == null) {
                this.m_MustAlertPasswordExpiration = false;
            }
        }
        SilverTrace.info("authentication", "AuthenticationLDAP.doAuthentication()", "root.MSG_GEN_PARAM_VALUE", "javax.net.ssl.trustStore = " + System.getProperty("javax.net.ssl.trustStore"));
    }

    protected AuthenticationConnection<LDAPConnection> openConnection() throws AuthenticationException {
        LDAPConnection ldapConnection = this.configuration.isSecure() ? new LDAPConnection((LDAPSocketFactory)new LDAPJSSESecureSocketFactory()) : new LDAPConnection();
        if (this.configuration.getTimeout() > 0) {
            ldapConnection.setSocketTimeOut(this.configuration.getTimeout());
        }
        try {
            ldapConnection.connect(this.configuration.getLdapHost(), this.configuration.getLdapPort());
        }
        catch (LDAPException ex) {
            throw new AuthenticationHostException("AuthenticationLDAP.openConnection()", 4, "root.EX_CONNECTION_OPEN_FAILED", "Configuration=" + this.configuration, (Exception)((Object)ex));
        }
        return new AuthenticationConnection<LDAPConnection>(ldapConnection);
    }

    protected void closeConnection(AuthenticationConnection connection) throws AuthenticationException {
        try {
            LDAPConnection ldapConnection = AuthenticationLDAP.getLDAPConnection(connection);
            if (ldapConnection != null && ldapConnection.isConnected()) {
                ldapConnection.disconnect();
            }
        }
        catch (Exception ex) {
            throw new AuthenticationHostException("AuthenticationLDAP.closeConnection()", 4, "root.EX_CONNECTION_CLOSE_FAILED", "Configuration=" + this.configuration, ex);
        }
    }

    protected void doAuthentication(AuthenticationConnection connection, AuthenticationCredential credential) throws AuthenticationException {
        String[] baseDNs;
        String searchString = this.m_UserLoginFieldName + "=" + credential.getLogin();
        int nbDaysBeforeExpiration = 0;
        String[] attrNames = this.m_MustAlertPasswordExpiration ? new String[]{"uid", this.m_PwdLastSetFieldName} : new String[]{"uid"};
        LDAPConnection ldapConnection = AuthenticationLDAP.getLDAPConnection(connection);
        String login = credential.getLogin();
        String password = credential.getPassword();
        try {
            ldapConnection.bind(3, this.configuration.getUsername(), this.configuration.getPassword());
        }
        catch (LDAPException e) {
            throw new AuthenticationHostException("AuthenticationLDAP.doAuthentication()", 4, "authentication.EX_LDAP_ACCESS_ERROR", (Exception)((Object)e));
        }
        LDAPEntry fe = null;
        for (String baseDN : baseDNs = AuthenticationLDAP.extractBaseDNs(this.m_UserBaseDN)) {
            try {
                SilverTrace.info("authentication", "AuthenticationLDAP.doAuthentication()", "root.MSG_GEN_PARAM_VALUE", "UserFilter=" + searchString + ", baseDN = " + baseDN);
                LDAPSearchResults res = ldapConnection.search(baseDN, 2, searchString, attrNames, false);
                if (!res.hasMore()) continue;
                fe = res.next();
                break;
            }
            catch (LDAPException ex) {
                throw new AuthenticationHostException("AuthenticationLDAP.doAuthentication()", 4, "authentication.EX_LDAP_ACCESS_ERROR", (Exception)((Object)ex));
            }
        }
        if (fe == null) {
            throw new AuthenticationBadCredentialException("AuthenticationLDAP.doAuthentication()", 4, "authentication.EX_USER_NOT_FOUND", "User=" + login + ";LoginField=" + this.m_UserLoginFieldName);
        }
        SilverTrace.debug("authentication", "AuthenticationLDAP.doAuthentication()", "root.MSG_GEN_PARAM_VALUE", "m_MustAlertPasswordExpiration=" + this.m_MustAlertPasswordExpiration);
        if (this.m_MustAlertPasswordExpiration && (nbDaysBeforeExpiration = this.calculateDaysBeforeExpiration(fe)) < 0) {
            throw new AuthenticationPasswordExpired("User=" + login);
        }
        String userFullDN = fe.getDN();
        if (!StringUtil.isDefined(password)) {
            throw new AuthenticationBadCredentialException("AuthenticationLDAP.doAuthentication()", 4, "authentication.EX_PWD_EMPTY", "User=" + login);
        }
        try {
            SilverTrace.info("authentication", "AuthenticationLDAP.doAuthentication()", "authentication.MSG_TRY_TO_AUTHENTICATE_USER", "UserDN=" + userFullDN);
            ldapConnection.bind(3, userFullDN, password.getBytes(Charsets.UTF_8));
            SilverTrace.info("authentication", "AuthenticationLDAP.doAuthentication()", "authentication.MSG_USER_AUTHENTIFIED", "User=" + login);
        }
        catch (LDAPException ex) {
            throw new AuthenticationBadCredentialException("AuthenticationLDAP.doAuthentication()", 4, "authentication.EX_AUTHENTICATION_BAD_CREDENTIAL", "User=" + login, (Exception)((Object)ex));
        }
        if (this.m_MustAlertPasswordExpiration && nbDaysBeforeExpiration < this.m_PwdExpirationReminderDelay) {
            throw new AuthenticationPasswordAboutToExpireException("AuthenticationLDAP.doAuthentication()", 3, "authentication.EX_AUTHENTICATION_PASSWORD_ABOUT_TO_EXPIRE", "User=" + login);
        }
    }

    private int calculateDaysBeforeExpiration(LDAPEntry fe) throws AuthenticationPasswordMustBeChangedAtNextLogon {
        SilverTrace.debug("authentication", "AuthenticationLDAP.calculateDaysBeforeExpiration()", "root.MSG_GEN_ENTER_METHOD");
        LDAPAttribute pwdLastSetAttr = fe.getAttribute(this.m_PwdLastSetFieldName);
        SilverTrace.debug("authentication", "AuthenticationLDAP.calculateDaysBeforeExpiration()", "root.MSG_GEN_PARAM_VALUE", "pwdLastSetAttr is null ? " + (pwdLastSetAttr == null));
        if (pwdLastSetAttr == null) {
            return Integer.MAX_VALUE;
        }
        Date pwdLastSet = null;
        switch (this.m_PwdLastSetFieldFormat) {
            case 0: {
                long lastSetValue = Long.parseLong(pwdLastSetAttr.getStringValue());
                if (lastSetValue == 0L) {
                    throw new AuthenticationPasswordMustBeChangedAtNextLogon("user=" + fe.getDN());
                }
                SilverTrace.debug("authentication", "AuthenticationLDAP.calculateDaysBeforeExpiration()", "root.MSG_GEN_PARAM_VALUE", "lastSetValue = " + lastSetValue);
                SilverTrace.debug("authentication", "AuthenticationLDAP.calculateDaysBeforeExpiration()", "root.MSG_GEN_PARAM_VALUE", "lastSetValue = " + (lastSetValue /= 10000L));
                SilverTrace.debug("authentication", "AuthenticationLDAP.calculateDaysBeforeExpiration()", "root.MSG_GEN_PARAM_VALUE", "lastSetValue = " + (lastSetValue -= MILLISECONDS_BETWEEN_1601_AND_1970));
                pwdLastSet = new Date(lastSetValue);
                break;
            }
            case 1: {
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                    String ldapValue = pwdLastSetAttr.getStringValue();
                    if (ldapValue == null) {
                        SilverTrace.error("authentication", "AuthenticationLDAP.calculateDaysBeforeExpiration()", "authentication.NO_VALUE", "m_PwdLastSetField=" + this.m_PwdLastSetFieldName);
                        return Integer.MAX_VALUE;
                    }
                    if (ldapValue.length() < 14) {
                        SilverTrace.error("authentication", "AuthenticationLDAP.calculateDaysBeforeExpiration()", "authentication.EX_BAD_DATE_FORMAT", "ldapValue=" + ldapValue);
                        return Integer.MAX_VALUE;
                    }
                    ldapValue = ldapValue.substring(0, 14);
                    pwdLastSet = format.parse(pwdLastSetAttr.getStringValue());
                    break;
                }
                catch (ParseException e) {
                    SilverTrace.error("authentication", "AuthenticationLDAP.calculateDaysBeforeExpiration()", "authentication.EX_BAD_DATE_FORMAT", e);
                }
            }
        }
        SilverTrace.debug("authentication", "AuthenticationLDAP.calculateDaysBeforeExpiration()", "root.MSG_GEN_PARAM_VALUE", "pwdLastSet = " + DateUtil.getOutputDateAndHour(pwdLastSet, "fr"));
        Date now = new Date();
        long delayInMilliseconds = pwdLastSet.getTime() - now.getTime();
        SilverTrace.debug("authentication", "AuthenticationLDAP.calculateDaysBeforeExpiration()", "root.MSG_GEN_PARAM_VALUE", "delayInMilliseconds = " + delayInMilliseconds);
        int delayInDays = Math.round(delayInMilliseconds / 86400000L + (long)this.m_PwdMaxAge);
        SilverTrace.debug("authentication", "AuthenticationLDAP.calculateDaysBeforeExpiration()", "root.MSG_GEN_EXIT_METHOD", "delayInDays = " + delayInDays);
        return delayInDays;
    }

    protected void doChangePassword(AuthenticationConnection connection, AuthenticationCredential credential, String newPassword) throws AuthenticationException {
        String login = credential.getLogin();
        String oldPassword = credential.getPassword();
        String searchString = this.m_UserLoginFieldName + "=" + login;
        String[] strAttributes = new String[]{"sAMAccountName", "memberOf"};
        LDAPConnection ldapConnection = AuthenticationLDAP.getLDAPConnection(connection);
        try {
            LDAPModification[] mod;
            ldapConnection.bind(3, this.configuration.getUsername(), this.configuration.getPassword());
            SilverTrace.info("authentication", "AuthenticationLDAP.changePassword()", "root.MSG_GEN_PARAM_VALUE", "UserFilter=" + searchString);
            LDAPSearchResults res = ldapConnection.search(this.m_UserBaseDN, 2, searchString, strAttributes, false);
            if (!res.hasMore()) {
                throw new AuthenticationBadCredentialException("AuthenticationLDAP.changePassword()", 4, "authentication.EX_USER_NOT_FOUND", "User=" + login + ";LoginField=" + this.m_UserLoginFieldName);
            }
            LDAPEntry fe = res.next();
            String userFullDN = fe.getDN();
            if ("opends".equalsIgnoreCase(this.ldapImpl) || "openldap".equalsIgnoreCase(this.ldapImpl)) {
                ldapConnection.bind(3, userFullDN, oldPassword.getBytes(Charsets.UTF_8));
                mod = this.changeOpenDSPassword(newPassword);
            } else {
                if (!this.configuration.isSecure()) {
                    UnsupportedOperationException e = new UnsupportedOperationException("LDAP connection must be secured to allow password update");
                    throw new AuthenticationException("AuthenticationLDAP.changePassword", 4, "authentication.EX_CANT_CHANGE_USERPASSWORD", e);
                }
                mod = this.getActiveDirectoryPasswordChange(oldPassword, newPassword);
            }
            ldapConnection.modify(userFullDN, mod);
        }
        catch (Exception ex) {
            throw new AuthenticationHostException("AuthenticationLDAP.doChangePassword()", 4, "authentication.EX_LDAP_ACCESS_ERROR", ex);
        }
    }

    private LDAPModification[] getActiveDirectoryPasswordChange(String oldPassword, String newPassword) {
        byte[] oldUnicodePassword = this.getActiveDirectoryUnicodePwd(oldPassword);
        byte[] newUnicodePassword = this.getActiveDirectoryUnicodePwd(newPassword);
        LDAPModification[] res = new LDAPModification[]{new LDAPModification(1, new LDAPAttribute("unicodePwd", oldUnicodePassword)), new LDAPModification(0, new LDAPAttribute("unicodePwd", newUnicodePassword))};
        return res;
    }

    private LDAPModification[] getActiveDirectoryPasswordReset(String newPassword) {
        byte[] newUnicodePassword = this.getActiveDirectoryUnicodePwd(newPassword);
        return new LDAPModification[]{new LDAPModification(2, new LDAPAttribute("unicodePwd", newUnicodePassword))};
    }

    private byte[] getActiveDirectoryUnicodePwd(String password) {
        String newQuotedPassword = "\"" + password + "\"";
        return newQuotedPassword.getBytes(Charsets.UTF_16LE);
    }

    private LDAPModification[] changeOpenDSPassword(String newPassword) {
        return new LDAPModification[]{new LDAPModification(2, new LDAPAttribute("userPassword", newPassword))};
    }

    private static String[] extractBaseDNs(String baseDN) {
        if (!baseDN.contains(BASEDN_SEPARATOR)) {
            String[] baseDNs = new String[]{baseDN};
            return baseDNs;
        }
        StringTokenizer st = new StringTokenizer(baseDN, BASEDN_SEPARATOR);
        ArrayList<String> baseDNs = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            baseDNs.add(st.nextToken());
        }
        return baseDNs.toArray(new String[baseDNs.size()]);
    }

    protected void doResetPassword(AuthenticationConnection connection, String login, String newPassword) throws AuthenticationException {
        String searchString = this.m_UserLoginFieldName + "=" + login;
        String[] strAttributes = new String[]{"sAMAccountName", "memberOf"};
        LDAPConnection ldapConnection = AuthenticationLDAP.getLDAPConnection(connection);
        try {
            ldapConnection.bind(3, this.configuration.getUsername(), this.configuration.getPassword());
            SilverTrace.info("authentication", "AuthenticationLDAP.changePassword()", "root.MSG_GEN_PARAM_VALUE", "UserFilter=" + searchString);
            LDAPSearchResults res = ldapConnection.search(this.m_UserBaseDN, 2, searchString, strAttributes, false);
            if (!res.hasMore()) {
                throw new AuthenticationBadCredentialException("AuthenticationLDAP.doResetPassword()", 4, "authentication.EX_USER_NOT_FOUND", "User=" + login + ";LoginField=" + this.m_UserLoginFieldName);
            }
            LDAPEntry fe = res.next();
            String userFullDN = fe.getDN();
            LDAPModification[] mod = null;
            if (!StringUtil.isDefined(this.ldapImpl) || "ad".equalsIgnoreCase(this.ldapImpl)) {
                mod = this.getActiveDirectoryPasswordReset(newPassword);
            } else if ("opends".equalsIgnoreCase(this.ldapImpl) || "openldap".equalsIgnoreCase(this.ldapImpl)) {
                mod = this.changeOpenDSPassword(newPassword);
            }
            ldapConnection.modify(userFullDN, mod);
        }
        catch (Exception ex) {
            throw new AuthenticationHostException("AuthenticationLDAP.doResetPassword()", 4, "authentication.EX_LDAP_ACCESS_ERROR", ex);
        }
    }

    private static LDAPConnection getLDAPConnection(AuthenticationConnection connection) {
        return (LDAPConnection)connection.getConnector();
    }
}

