/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.List;
import org.silverpeas.authentication.Authentication;
import org.silverpeas.authentication.AuthenticationCredential;
import org.silverpeas.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.exception.AuthenticationExceptionVisitor;
import org.silverpeas.authentication.exception.AuthenticationHostException;
import org.silverpeas.authentication.exception.AuthenticationPasswordAboutToExpireException;
import org.silverpeas.authentication.exception.AuthenticationPwdChangeNotAvailException;
import org.silverpeas.authentication.exception.AuthenticationPwdNotAvailException;

public class AuthenticationServer {
    private static final String module = "authentication";
    protected String fallbackMode;
    protected List<Authentication> authServers;
    protected boolean passwordChangeAllowed;

    public static AuthenticationServer getAuthenticationServer(String serverName) {
        return new AuthenticationServer(serverName);
    }

    private AuthenticationServer(String authServerName) {
        try {
            ResourceLocator serverSettings = new ResourceLocator("com.stratelia.silverpeas.authentication." + authServerName, "");
            this.fallbackMode = serverSettings.getString("fallbackType");
            this.passwordChangeAllowed = serverSettings.getBoolean("allowPasswordChange", false);
            int nbServers = Integer.parseInt(serverSettings.getString("autServersCount"));
            this.authServers = new ArrayList<Authentication>(nbServers);
            for (int i = 0; i < nbServers; ++i) {
                String serverName = "autServer" + i;
                if (!serverSettings.getBoolean(serverName + ".enabled", true)) continue;
                try {
                    Authentication authenticationWithAServer = (Authentication)Class.forName(serverSettings.getString(serverName + ".type")).newInstance();
                    authenticationWithAServer.init(serverName, serverSettings);
                    this.authServers.add(authenticationWithAServer);
                    continue;
                }
                catch (Exception ex) {
                    SilverTrace.error(module, "AuthenticationServer.AuthenticationServer", "authentication.EX_CANT_INSTANCIATE_SERVER_CLASS", authServerName + " / " + serverName, ex);
                }
            }
        }
        catch (Exception e) {
            SilverTrace.error(module, "AuthenticationServer.AuthenticationServer", "authentication.EX_DOMAIN_INFO_ERROR", "Server=" + authServerName, e);
        }
    }

    public void authenticate(final AuthenticationCredential credential) throws AuthenticationException {
        this.doSecurityOperation(new SecurityOperation("authenticate", credential){

            @Override
            public void performWith(Authentication authentication) throws AuthenticationException {
                authentication.authenticate(credential);
            }
        });
    }

    public void changePassword(final AuthenticationCredential credential, final String newPassword) throws AuthenticationException {
        if (!this.passwordChangeAllowed) {
            throw new AuthenticationPwdChangeNotAvailException("AuthenticationServer.changePassword", 4, "authentication.EX_PASSWD_CHANGE_NOTAVAILABLE");
        }
        this.doSecurityOperation(new SecurityOperation("changePassword", credential){

            @Override
            public void performWith(Authentication authentication) throws AuthenticationException {
                authentication.changePassword(credential, newPassword);
            }
        });
    }

    public boolean isPasswordChangeAllowed() {
        return this.passwordChangeAllowed;
    }

    public void resetPassword(final String login, final String newPassword) throws AuthenticationException {
        if (!this.passwordChangeAllowed) {
            throw new AuthenticationPwdChangeNotAvailException("AuthenticationServer.resetPassword", 4, "authentication.EX_PASSWD_CHANGE_NOTAVAILABLE");
        }
        this.doSecurityOperation(new SecurityOperation("resetPassword", AuthenticationCredential.newWithAsLogin(login)){

            @Override
            public void performWith(Authentication authentication) throws AuthenticationException {
                authentication.resetPassword(login, newPassword);
            }
        });
    }

    private void doSecurityOperation(SecurityOperation op) throws AuthenticationException {
        if (!StringUtil.isDefined(op.getAuthenticationCredential().getLogin())) {
            throw new AuthenticationException("AuthenticationServer." + op.getName(), 4, "authentication.EX_LOGIN_EMPTY");
        }
        boolean serverNotFound = true;
        AuthenticationException lastException = null;
        for (Authentication authServer : this.authServers) {
            if (authServer.isEnabled()) {
                try {
                    op.performWith(authServer);
                    serverNotFound = false;
                }
                catch (AuthenticationException ex) {
                    AuthenticationExceptionProcessor processor = new AuthenticationExceptionProcessor(op.getName(), authServer, op.getAuthenticationCredential());
                    serverNotFound = processor.processAuthenticationException(ex);
                    lastException = ex;
                }
            }
            if (serverNotFound) continue;
            break;
        }
        if (serverNotFound) {
            if (lastException == null) {
                throw new AuthenticationException("AuthenticationServer." + op.getName(), 4, "authentication.EX_NO_SERVER_AVAILABLE");
            }
            throw new AuthenticationException("AuthenticationServer." + op.getName(), 4, "authentication.EX_AUTHENTICATION_FAILED_LAST_ERROR", lastException);
        }
    }

    private class AuthenticationExceptionProcessor
    implements AuthenticationExceptionVisitor {
        private final Authentication authentication;
        private final AuthenticationCredential credential;
        private boolean continueAuthentication = true;
        private final String operation;

        public AuthenticationExceptionProcessor(String authOperation, Authentication authentication, AuthenticationCredential credential) {
            this.operation = authOperation;
            this.authentication = authentication;
            this.credential = credential;
        }

        public boolean processAuthenticationException(AuthenticationException ex) throws AuthenticationException {
            ex.accept(this);
            return this.continueAuthentication;
        }

        @Override
        public void visit(AuthenticationBadCredentialException ex) throws AuthenticationException {
            if (AuthenticationServer.this.fallbackMode.equals("none") || AuthenticationServer.this.fallbackMode.equals("ifNotRejected")) {
                throw ex;
            }
            SilverTrace.info(AuthenticationServer.module, "AuthenticationServer." + this.operation, "authentication.EX_AUTHENTICATION_BAD_CREDENTIAL", "Auth server=" + this.authentication.getServerName() + ";User=" + this.credential.getLogin(), ex);
            this.continueAuthentication = true;
        }

        @Override
        public void visit(AuthenticationHostException ex) throws AuthenticationException {
            if (AuthenticationServer.this.fallbackMode.equals("none")) {
                throw ex;
            }
            SilverTrace.info(AuthenticationServer.module, "AuthenticationServer." + this.operation, "authentication.EX_AUTHENTICATION_HOST_ERROR", "Auth server=" + this.authentication.getServerName() + ";User=" + this.credential.getLogin(), ex);
            this.continueAuthentication = true;
        }

        @Override
        public void visit(AuthenticationException ex) throws AuthenticationException {
            if (AuthenticationServer.this.fallbackMode.equals("none")) {
                throw ex;
            }
            SilverTrace.info(AuthenticationServer.module, "AuthenticationServer." + this.operation, "authentication.EX_AUTHENTICATION_REJECTED_BY_SERVER", "Auth server=" + this.authentication.getServerName() + ";User=" + this.credential.getLogin(), ex);
            this.continueAuthentication = true;
        }

        @Override
        public void visit(AuthenticationPwdNotAvailException ex) throws AuthenticationException {
            SilverTrace.info(AuthenticationServer.module, "AuthenticationServer." + this.operation, "authentication.EX_PWD_NOT_AVAILABLE", "Auth server=" + this.authentication.getServerName() + ";User=" + this.credential.getLogin(), ex);
            this.continueAuthentication = true;
        }

        @Override
        public void visit(AuthenticationPasswordAboutToExpireException ex) throws AuthenticationException {
            this.credential.getCapabilities().put("Svp_Pwd_About_To_Expire", Boolean.TRUE);
            this.continueAuthentication = false;
        }

        @Override
        public void visit(AuthenticationPwdChangeNotAvailException ex) throws AuthenticationException {
            SilverTrace.info(AuthenticationServer.module, "AuthenticationServer." + this.operation, "authentication.EX_PASSWD_CHANGE_NOTAVAILABLE", "Auth server=" + this.authentication.getServerName() + ";User=" + this.credential.getLogin(), ex);
            this.continueAuthentication = true;
        }
    }

    private abstract class SecurityOperation {
        public static final String AUTHENTICATION = "authenticate";
        public static final String PASSWORD_CHANGE = "changePassword";
        public static final String PASSWORD_RESET = "resetPassword";
        private String name;
        private AuthenticationCredential credential;

        public SecurityOperation(String operationName, AuthenticationCredential credential) {
            this.credential = credential;
            this.name = operationName;
        }

        public String getName() {
            return this.name;
        }

        public AuthenticationCredential getAuthenticationCredential() {
            return this.credential;
        }

        public abstract void performWith(Authentication var1) throws AuthenticationException;
    }
}

