/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication.encryption;

import org.silverpeas.authentication.encryption.PasswordEncryption;
import org.silverpeas.authentication.encryption.UnixDESEncryption;
import org.silverpeas.authentication.encryption.UnixMD5Encryption;
import org.silverpeas.authentication.encryption.UnixSHA512Encryption;

public class PasswordEncryptionFactory {
    private static PasswordEncryptionFactory instance = new PasswordEncryptionFactory();
    private final PasswordEncryption currentEncryption = new UnixSHA512Encryption();

    public static PasswordEncryptionFactory getFactory() {
        return instance;
    }

    public PasswordEncryption getDefaultPasswordEncryption() {
        return this.currentEncryption;
    }

    public PasswordEncryption getPasswordEncryption(String digest) throws IllegalArgumentException {
        PasswordEncryption[] availableEncryption = new PasswordEncryption[]{this.currentEncryption, new UnixMD5Encryption(), new UnixDESEncryption()};
        PasswordEncryption encryption = null;
        for (PasswordEncryption crypt : availableEncryption) {
            if (!crypt.doUnderstandDigest(digest)) continue;
            encryption = crypt;
            break;
        }
        if (encryption == null) {
            throw new IllegalArgumentException("Digest '" + digest + "' not understand by any of the" + "available encryption in Silverpeas");
        }
        return encryption;
    }
}

