/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication.encryption;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Random;
import org.silverpeas.authentication.encryption.PasswordEncryption;

public class UnixMD5Encryption
implements PasswordEncryption {
    private static final String MAGIC = "$1$";
    private static final byte[] ITOA64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".getBytes();

    private static void to64(StringBuilder sb, int n, int nCount) {
        while (--nCount >= 0) {
            sb.append((char)ITOA64[n & 0x3F]);
            n >>= 6;
        }
    }

    private static String crypt(String strPassword) {
        Random random = new Random();
        byte[] salt = new byte[]{ITOA64[random.nextInt(64)], ITOA64[random.nextInt(64)], ITOA64[random.nextInt(64)], ITOA64[random.nextInt(64)], ITOA64[random.nextInt(64)], ITOA64[random.nextInt(64)]};
        return UnixMD5Encryption.crypt(salt, strPassword);
    }

    private static String crypt(byte[] abySalt, String strPassword) {
        String retVal = null;
        try {
            byte[] abyPassword = strPassword.getBytes();
            MessageDigest _md = MessageDigest.getInstance("MD5");
            _md.update(abyPassword);
            _md.update(MAGIC.getBytes());
            _md.update(abySalt);
            MessageDigest md2 = MessageDigest.getInstance("MD5");
            md2.update(abyPassword);
            md2.update(abySalt);
            md2.update(abyPassword);
            byte[] abyFinal = md2.digest();
            for (int n = abyPassword.length; n > 0; n -= 16) {
                _md.update(abyFinal, 0, n > 16 ? 16 : n);
            }
            abyFinal = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            int j = 0;
            for (int i = abyPassword.length; i != 0; i >>>= 1) {
                if ((i & 1) == 1) {
                    _md.update(abyFinal, j, 1);
                    continue;
                }
                _md.update(abyPassword, j, 1);
            }
            StringBuilder sbPasswd = new StringBuilder();
            sbPasswd.append(MAGIC);
            sbPasswd.append(new String(abySalt));
            sbPasswd.append('$');
            abyFinal = _md.digest();
            for (int n = 0; n < 1000; ++n) {
                MessageDigest md3 = MessageDigest.getInstance("MD5");
                if ((n & 1) != 0) {
                    md3.update(abyPassword);
                } else {
                    md3.update(abyFinal);
                }
                if (n % 3 != 0) {
                    md3.update(abySalt);
                }
                if (n % 7 != 0) {
                    md3.update(abyPassword);
                }
                if ((n & 1) != 0) {
                    md3.update(abyFinal);
                } else {
                    md3.update(abyPassword);
                }
                abyFinal = md3.digest();
            }
            int[] anFinal = new int[]{abyFinal[0] & 0x7F | abyFinal[0] & 0x80, abyFinal[1] & 0x7F | abyFinal[1] & 0x80, abyFinal[2] & 0x7F | abyFinal[2] & 0x80, abyFinal[3] & 0x7F | abyFinal[3] & 0x80, abyFinal[4] & 0x7F | abyFinal[4] & 0x80, abyFinal[5] & 0x7F | abyFinal[5] & 0x80, abyFinal[6] & 0x7F | abyFinal[6] & 0x80, abyFinal[7] & 0x7F | abyFinal[7] & 0x80, abyFinal[8] & 0x7F | abyFinal[8] & 0x80, abyFinal[9] & 0x7F | abyFinal[9] & 0x80, abyFinal[10] & 0x7F | abyFinal[10] & 0x80, abyFinal[11] & 0x7F | abyFinal[11] & 0x80, abyFinal[12] & 0x7F | abyFinal[12] & 0x80, abyFinal[13] & 0x7F | abyFinal[13] & 0x80, abyFinal[14] & 0x7F | abyFinal[14] & 0x80, abyFinal[15] & 0x7F | abyFinal[15] & 0x80};
            UnixMD5Encryption.to64(sbPasswd, anFinal[0] << 16 | anFinal[6] << 8 | anFinal[12], 4);
            UnixMD5Encryption.to64(sbPasswd, anFinal[1] << 16 | anFinal[7] << 8 | anFinal[13], 4);
            UnixMD5Encryption.to64(sbPasswd, anFinal[2] << 16 | anFinal[8] << 8 | anFinal[14], 4);
            UnixMD5Encryption.to64(sbPasswd, anFinal[3] << 16 | anFinal[9] << 8 | anFinal[15], 4);
            UnixMD5Encryption.to64(sbPasswd, anFinal[4] << 16 | anFinal[10] << 8 | anFinal[5], 4);
            UnixMD5Encryption.to64(sbPasswd, anFinal[11], 2);
            retVal = sbPasswd.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public String encrypt(String password) {
        return UnixMD5Encryption.crypt(password);
    }

    @Override
    public String encrypt(String password, byte[] salt) {
        if (salt == null || salt.length == 0) {
            return UnixMD5Encryption.crypt(password);
        }
        return UnixMD5Encryption.crypt(salt, password);
    }

    @Override
    public void check(String password, String digest) throws AssertionError {
        String encryptedPassword = UnixMD5Encryption.crypt(this.getSaltUsedInDigest(digest), password);
        if (!encryptedPassword.equals(digest)) {
            throw new AssertionError((Object)MessageFormat.format("The password \"{0}\" doesn''t match the digest \"{1}\"", password, digest));
        }
    }

    @Override
    public byte[] getSaltUsedInDigest(String digest) {
        String[] parts;
        String salt = "";
        if (this.doUnderstandDigest(digest) && (parts = digest.split("\\$")).length >= 3) {
            salt = parts[2];
        }
        return salt.getBytes();
    }

    @Override
    public boolean doUnderstandDigest(String digest) {
        return digest.matches("\\$1\\$[a-zA-Z0-9/.]{0,8}\\$[a-zA-Z0-9/.]{22}");
    }
}

