/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.authentication.verifier;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.UserDetail;
import org.silverpeas.authentication.exception.AuthenticationBadCredentialException;
import org.silverpeas.authentication.exception.AuthenticationException;
import org.silverpeas.authentication.exception.AuthenticationUserAccountBlockedException;
import org.silverpeas.authentication.exception.AuthenticationUserAccountDeactivatedException;
import org.silverpeas.authentication.verifier.AbstractAuthenticationVerifier;

public class UserCanLoginVerifier
extends AbstractAuthenticationVerifier {
    public static final String ERROR_INCORRECT_LOGIN_PWD = "1";
    public static final String ERROR_INCORRECT_LOGIN_PWD_DOMAIN = "6";
    public static final String ERROR_USER_ACCOUNT_BLOCKED = "Error_UserAccountBlocked";
    public static final String ERROR_USER_ACCOUNT_DEACTIVATED = "Error_UserAccountDeactivated";

    protected UserCanLoginVerifier(UserDetail user) {
        super(user);
    }

    public String getErrorDestination() {
        String errorDest = "/Login.jsp?ErrorCode=";
        Domain[] tabDomains = null;
        try {
            tabDomains = AdminReference.getAdminService().getAllDomains();
        }
        catch (AdminException e) {
            SilverTrace.error("authentication", "UserCanLoginVerifier.getErrorDestination()", "authentication.EX_VERIFY_USER_CAN_LOGIN", e);
        }
        if (this.getUser() == null || StringUtil.isNotDefined(this.getUser().getId())) {
            errorDest = tabDomains != null && tabDomains.length > 1 ? errorDest + ERROR_INCORRECT_LOGIN_PWD_DOMAIN : errorDest + ERROR_INCORRECT_LOGIN_PWD;
        } else if (!this.isUserStateValid()) {
            errorDest = this.getUser().isDeactivatedState() ? errorDest + ERROR_USER_ACCOUNT_DEACTIVATED : errorDest + ERROR_USER_ACCOUNT_BLOCKED;
        }
        return errorDest;
    }

    public void verify() throws AuthenticationException {
        if (this.getUser() == null) {
            throw new AuthenticationBadCredentialException("UserCanLoginVerifier.verify()", 4, "authentication.EX_VERIFY_USER_CAN_LOGIN");
        }
        if (!this.isUserStateValid()) {
            if (this.getUser().isDeactivatedState()) {
                throw new AuthenticationUserAccountDeactivatedException("UserCanLoginVerifier.verify()", 4, "authentication.EX_VERIFY_USER_CAN_LOGIN", "Login=" + this.getUser().getLogin());
            }
            throw new AuthenticationUserAccountBlockedException("UserCanLoginVerifier.verify()", 4, "authentication.EX_VERIFY_USER_CAN_LOGIN", "Login=" + this.getUser().getLogin());
        }
    }

    private boolean isUserStateValid() {
        return this.getUser() != null && this.getUser().isValidState();
    }
}

