/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.cache.service;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.silverpeas.cache.service.AbstractCacheService;

public final class EhCacheService
extends AbstractCacheService {
    private static final String CACHE_NAME = "SILVERPEAS_COMMON_EH_CACHE";
    private final CacheManager cacheManager = CacheManager.getInstance();

    EhCacheService(int nbMaxElements) {
        if (!this.cacheManager.cacheExists(CACHE_NAME)) {
            this.cacheManager.addCache(new Cache(new CacheConfiguration(CACHE_NAME, nbMaxElements)));
        } else {
            this.getCache().getCacheConfiguration().setMaxEntriesLocalHeap((long)nbMaxElements);
        }
    }

    Cache getCache() {
        return this.cacheManager.getCache(CACHE_NAME);
    }

    @Override
    public void clear() {
        Cache cache = this.getCache();
        for (Object key : cache.getKeys()) {
            cache.remove(key);
        }
    }

    @Override
    public Object get(Object key) {
        Element element = this.getCache().get(key);
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    @Override
    public Object remove(Object key) {
        Object value = this.get(key);
        if (value != null) {
            this.getCache().remove(key);
        }
        return value;
    }

    @Override
    public <T> T remove(Object key, Class<T> classType) {
        T value = this.get(key, classType);
        if (value != null) {
            this.getCache().remove(key);
        }
        return value;
    }

    @Override
    public void put(Object key, Object value, int timeToLive, int timeToIdle) {
        Element element = new Element(key, value);
        element.setTimeToLive(timeToLive);
        element.setTimeToIdle(timeToIdle);
        this.getCache().put(element);
    }
}

