/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.cache.service;

import java.util.HashMap;
import java.util.Map;
import org.silverpeas.cache.service.AbstractSimpleCacheService;

public class ThreadCacheService
extends AbstractSimpleCacheService {
    private final ThreadLocal<Map<Object, Object>> cache = new ThreadLocal();

    protected Map<Object, Object> getCache() {
        Map<Object, Object> threadCache = this.cache.get();
        if (threadCache == null) {
            threadCache = new HashMap<Object, Object>();
            this.cache.set(threadCache);
        }
        return threadCache;
    }

    @Override
    public void clear() {
        this.cache.set(null);
    }

    @Override
    public Object get(Object key) {
        return this.getCache().get(key);
    }

    @Override
    public Object remove(Object key) {
        Object value = this.get(key);
        if (value != null) {
            this.getCache().remove(key);
        }
        return value;
    }

    @Override
    public <T> T remove(Object key, Class<T> classType) {
        T value = this.get(key, classType);
        if (value != null) {
            this.getCache().remove(key);
        }
        return value;
    }

    @Override
    public void put(Object key, Object value) {
        this.getCache().put(key, value);
    }
}

