/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.chart;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.silverpeas.chart.AbstractAxisChartItem;
import org.silverpeas.chart.AbstractChart;
import org.silverpeas.chart.ChartAxis;

public abstract class AbstractAxisChart<XAXIS_DATA_TYPE, YAXIS_DATA_TYPE, ITEM_TYPE extends AbstractAxisChartItem<XAXIS_DATA_TYPE, YAXIS_DATA_TYPE, ITEM_TYPE>>
extends AbstractChart<ITEM_TYPE> {
    private ChartAxis x = new ChartAxis();
    private ChartAxis y = new ChartAxis();
    private Map<XAXIS_DATA_TYPE, ITEM_TYPE> itemIndexedByX = new HashMap<XAXIS_DATA_TYPE, ITEM_TYPE>();

    public ChartAxis getAxisX() {
        return this.x;
    }

    public ChartAxis getAxisY() {
        return this.y;
    }

    @Override
    protected void computeExtraDataAsJson(JSONObject jsonChart) {
        super.computeExtraDataAsJson(jsonChart);
        jsonChart.put("axis", (Object)new JSONObject().put("x", (Object)this.getAxisX().asJson()).put("y", (Object)this.getAxisY().asJson()));
    }

    protected ITEM_TYPE getItemFrom(XAXIS_DATA_TYPE xValue) {
        return (ITEM_TYPE)((AbstractAxisChartItem)this.itemIndexedByX.get(xValue));
    }

    @Override
    protected <T extends AbstractChart<ITEM_TYPE>> T add(ITEM_TYPE item) {
        this.itemIndexedByX.put(((AbstractAxisChartItem)item).getX(), item);
        return super.add(item);
    }

    private ITEM_TYPE createFor(XAXIS_DATA_TYPE x) {
        try {
            Class xClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            Class itemClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[2];
            Constructor constructor = itemClass.getDeclaredConstructor(xClass);
            constructor.setAccessible(true);
            return (ITEM_TYPE)((AbstractAxisChartItem)constructor.newInstance(x));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ITEM_TYPE forX(XAXIS_DATA_TYPE xValue) {
        ITEM_TYPE item = this.getItemFrom(xValue);
        if (item == null) {
            item = this.createFor(xValue);
            this.add(item);
        }
        return item;
    }
}

