/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.chart;

import com.silverpeas.util.StringUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.silverpeas.chart.Chart;
import org.silverpeas.chart.ChartItem;

public abstract class AbstractChart<CHART_ITEM_TYPE extends ChartItem>
implements Chart<CHART_ITEM_TYPE> {
    private String title = "";
    private List<CHART_ITEM_TYPE> items = new ArrayList<CHART_ITEM_TYPE>();
    private Map<String, Object> extra = null;

    @Override
    public String getTitle() {
        return this.title;
    }

    public <T extends AbstractChart<CHART_ITEM_TYPE>> T addExtra(String key, Object value) {
        if (this.extra == null) {
            this.extra = new LinkedHashMap<String, Object>();
        }
        this.extra.put(key, value);
        return (T)this;
    }

    public Object getExtra(String key) {
        return this.extra == null ? null : this.extra.get(key);
    }

    public final <T extends AbstractChart<CHART_ITEM_TYPE>> T withTitle(String title) {
        this.title = StringUtil.defaultStringIfNotDefined(title);
        return (T)this;
    }

    @Override
    public final String asJson() {
        JSONArray dataAsJson = new JSONArray();
        for (ChartItem data : this.getItems()) {
            try {
                dataAsJson.put((Object)new JSONObject(new JSONTokener(data.asJson())));
            }
            catch (ParseException ignore) {}
        }
        JSONObject jsonChart = new JSONObject();
        jsonChart.put("chartType", (Object)this.getType().name());
        jsonChart.put("title", (Object)this.getTitle());
        jsonChart.put("items", (Object)dataAsJson);
        if (this.extra != null) {
            JSONObject jsonExtra = new JSONObject();
            for (Map.Entry<String, Object> entry : this.extra.entrySet()) {
                jsonExtra.put(entry.getKey(), entry.getValue());
            }
            jsonChart.put("extra", (Object)jsonExtra);
        }
        this.computeExtraDataAsJson(jsonChart);
        return jsonChart.toString();
    }

    protected void computeExtraDataAsJson(JSONObject jsonChart) {
    }

    @Override
    public final List<CHART_ITEM_TYPE> getItems() {
        return this.items;
    }

    protected <T extends AbstractChart<CHART_ITEM_TYPE>> T add(CHART_ITEM_TYPE item) {
        this.items.add(item);
        return (T)this;
    }
}

