/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.exec;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.IOUtils;
import org.silverpeas.exec.ExternalExecutionException;
import org.silverpeas.viewer.util.CollectingLogOutputStream;

public class ExternalExecution {
    public static List<String> exec(CommandLine commandLine) throws ExternalExecutionException {
        return ExternalExecution.exec(commandLine, Config.init());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> exec(CommandLine commandLine, Config config) throws ExternalExecutionException {
        SilverTrace.info("util", "ExternalExecution.exec", "Command " + commandLine);
        final LinkedList<String> result = new LinkedList<String>();
        final LinkedList<String> errors = new LinkedList<String>();
        CollectingLogOutputStream logErrors = new CollectingLogOutputStream(errors);
        try {
            final Process process = Runtime.getRuntime().exec(commandLine.toStrings());
            Thread errEater = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        errors.addAll(IOUtils.readLines((InputStream)process.getErrorStream()));
                    }
                    catch (IOException e) {
                        throw new ExternalExecutionException(e);
                    }
                }
            });
            errEater.start();
            Thread outEater = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        result.addAll(IOUtils.readLines((InputStream)process.getInputStream()));
                    }
                    catch (IOException e) {
                        throw new ExternalExecutionException(e);
                    }
                }
            });
            outEater.start();
            process.waitFor();
            int exitStatus = process.exitValue();
            if (exitStatus != config.getSuccessfulExitStatusValue()) {
                throw new RuntimeException("Exit error status : " + exitStatus + " " + logErrors.getMessage());
            }
        }
        catch (IOException e) {
            ExternalExecution.performExternalExecutionException(config, e);
        }
        catch (InterruptedException e) {
            ExternalExecution.performExternalExecutionException(config, e);
        }
        catch (RuntimeException e) {
            ExternalExecution.performExternalExecutionException(config, e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)((Object)logErrors));
        }
        return result;
    }

    private static void performExternalExecutionException(Config config, Exception e) {
        if (config.isDisplayErrorTraceEnabled()) {
            SilverTrace.error("util", "ExternalExecution.exec", "Command execution error", e);
        }
        throw new ExternalExecutionException(e);
    }

    public static class Config {
        private int successfulExitStatusValue = 0;
        private boolean displayErrorTrace = true;

        public static Config init() {
            return new Config();
        }

        private Config() {
        }

        public Config successfulExitStatusValueIs(int successfulExitStatusValue) {
            this.successfulExitStatusValue = successfulExitStatusValue;
            return this;
        }

        public int getSuccessfulExitStatusValue() {
            return this.successfulExitStatusValue;
        }

        public Config doNotDisplayErrorTrace() {
            this.displayErrorTrace = false;
            return this;
        }

        public boolean isDisplayErrorTraceEnabled() {
            return this.displayErrorTrace;
        }
    }
}

