/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.file;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.silverpeas.file.ImageResizingProcessor;

class ImageCache {
    private static final String IMAGE_CACHE_TABLE = ImageResizingProcessor.IMAGE_CACHE_PATH + File.separatorChar + ".data";

    ImageCache() {
    }

    protected static void putImage(String originalImagePath, String resizedImagePath) {
        String entryName = ImageCache.hash(originalImagePath);
        File entry = new File(IMAGE_CACHE_TABLE, entryName);
        try {
            ArrayList<String> lines = new ArrayList<String>();
            if (!entry.exists()) {
                lines.add(originalImagePath);
            }
            lines.add(resizedImagePath);
            FileUtils.writeLines((File)entry, lines, (boolean)true);
        }
        catch (IOException ex) {
            Logger.getLogger(ImageCache.class.getSimpleName()).log(Level.SEVERE, "Cannot write the cache entry {0} with value {1}. Cause: {2}", new String[]{entry.getAbsolutePath(), resizedImagePath, ex.getMessage()});
        }
    }

    protected static void removeImages(String ... originalImagePaths) {
        for (String anOriginalImage : originalImagePaths) {
            String entryName = ImageCache.hash(anOriginalImage);
            File entry = new File(IMAGE_CACHE_TABLE, entryName);
            if (!entry.exists()) continue;
            try {
                List lines = FileUtils.readLines((File)entry);
                for (String resizedImagePath : lines.subList(1, lines.size())) {
                    File resizedImage = new File(resizedImagePath);
                    if (!resizedImage.exists() || resizedImage.delete()) continue;
                    Logger.getLogger(ImageCache.class.getSimpleName()).log(Level.WARNING, "Cannot remove {0} from the cache entry {1}", new String[]{resizedImage.getAbsolutePath(), entry.getAbsolutePath()});
                }
                if (entry.delete()) continue;
                Logger.getLogger(ImageCache.class.getSimpleName()).log(Level.WARNING, "Cannot delete the cache entry {0}", entry.getAbsolutePath());
            }
            catch (IOException ex) {
                Logger.getLogger(ImageCache.class.getSimpleName()).log(Level.SEVERE, ex.getMessage());
            }
        }
    }

    protected static List<String> getImages(String originalImagePath) {
        String entryName = ImageCache.hash(originalImagePath);
        File entry = new File(IMAGE_CACHE_TABLE, entryName);
        if (entry.exists()) {
            try {
                List lines = FileUtils.readLines((File)entry);
                if (!lines.isEmpty()) {
                    return lines.subList(1, lines.size());
                }
            }
            catch (IOException ex) {
                Logger.getLogger(ImageCache.class.getSimpleName()).log(Level.SEVERE, ex.getMessage());
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected static List<String> getAllImageEntries() {
        ArrayList<String> originalImagePaths = new ArrayList<String>();
        File entries = new File(IMAGE_CACHE_TABLE);
        for (File anEntry : entries.listFiles()) {
            try {
                List resizedImagePaths = FileUtils.readLines((File)anEntry);
                originalImagePaths.add((String)resizedImagePaths.get(0));
            }
            catch (IOException ex) {
                Logger.getLogger(ImageCache.class.getSimpleName()).log(Level.SEVERE, ex.getMessage());
            }
        }
        return originalImagePaths;
    }

    private static String hash(String name) {
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(name.getBytes(), 0, name.length());
            return new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.getLogger(ImageCache.class.getSimpleName()).log(Level.WARNING, e.getMessage());
            return String.valueOf(name.hashCode());
        }
    }
}

