/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.image;

import com.silverpeas.util.CollectionUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.silverpeas.image.ImageTool;
import org.silverpeas.image.ImageToolDirective;
import org.silverpeas.image.ImageToolException;
import org.silverpeas.image.option.AbstractImageToolOption;

public abstract class AbstractImageTool
implements ImageTool {
    protected abstract void convert(File var1, File var2, Map<Class<AbstractImageToolOption>, AbstractImageToolOption> var3, Set<ImageToolDirective> var4) throws Exception;

    @Override
    public void convert(File source, File destination, ImageToolDirective ... directives) {
        this.centralizedConvert(source, destination, null, directives);
    }

    @Override
    public void convert(File source, File destination, AbstractImageToolOption option, ImageToolDirective ... directives) {
        this.centralizedConvert(source, destination, Collections.singleton(option), directives);
    }

    @Override
    public void convert(File source, File destination, Set<AbstractImageToolOption> options, ImageToolDirective ... directives) {
        this.centralizedConvert(source, destination, options, directives);
    }

    private void centralizedConvert(File source, File destination, Set<AbstractImageToolOption> options, ImageToolDirective ... directives) {
        if (source.exists()) {
            if (destination == null) {
                destination = source;
            }
            try {
                this.convert(source, destination, this.toMap(options), this.toSet(directives));
            }
            catch (Exception e) {
                throw new ImageToolException(e);
            }
        }
    }

    protected <T extends AbstractImageToolOption> T getOption(Map<?, ?> options, Class<T> key) {
        return (T)((AbstractImageToolOption)options.get(key));
    }

    private <T extends AbstractImageToolOption> Map<Class<T>, AbstractImageToolOption> toMap(Set<AbstractImageToolOption> options) {
        HashMap<Class<T>, AbstractImageToolOption> mappedOptions;
        if (options != null) {
            mappedOptions = new HashMap<Class<T>, AbstractImageToolOption>();
            for (AbstractImageToolOption option : options) {
                mappedOptions.put(option.getClass(), option);
            }
        } else {
            mappedOptions = new HashMap(0);
        }
        return mappedOptions;
    }

    private <T> Set<T> toSet(T ... items) {
        if (items == null) {
            return new HashSet(0);
        }
        return CollectionUtil.asSet(items);
    }
}

