/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.jdbc;

import com.silverpeas.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.silverpeas.jdbc.JdbcSqlExecutorProvider;
import org.silverpeas.jdbc.SelectResultRowProcess;

public class JdbcSqlQuery {
    private final Configuration configuration = new Configuration();
    private final StringBuilder sqlQuery = new StringBuilder();
    private final Collection<Object> allParameters = new ArrayList<Object>();

    public static boolean isSqlDefined(String sqlValue) {
        return StringUtil.isDefined(sqlValue) && !sqlValue.trim().equals("-1") && !sqlValue.trim().equals("unknown");
    }

    public static <ENTITY> ENTITY unique(List<ENTITY> entities) {
        if (entities.isEmpty()) {
            return null;
        }
        if (entities.size() == 1) {
            return entities.get(0);
        }
        throw new IllegalArgumentException("wanted to get a unique entity from a list that contains more than one...");
    }

    public static JdbcSqlQuery create(String sqlPart, Object ... paramValue) {
        return new JdbcSqlQuery().addSqlPart(sqlPart, paramValue);
    }

    public static JdbcSqlQuery create(String sqlPart, Collection<?> paramValue) {
        return new JdbcSqlQuery().addSqlPart(sqlPart, paramValue);
    }

    public static JdbcSqlQuery createSelect(String sqlPart, Object ... paramValue) {
        return new JdbcSqlQuery().addSqlPart("select", new Object[0]).addSqlPart(sqlPart, paramValue);
    }

    public static JdbcSqlQuery createSelect(String sqlPart, Collection<?> paramValue) {
        return new JdbcSqlQuery().addSqlPart("select", new Object[0]).addSqlPart(sqlPart, paramValue);
    }

    public static JdbcSqlQuery createCountFor(String tableName) {
        return new JdbcSqlQuery().addSqlPart("select count(*) from", new Object[0]).addSqlPart(tableName, new Object[0]);
    }

    public static JdbcSqlQuery createTable(String tableName) {
        return new JdbcSqlQuery().addSqlPart("create table", new Object[0]).addSqlPart(tableName, new Object[0]).addSqlPart(" (", new Object[0]);
    }

    public static JdbcSqlQuery createInsertFor(String tableName) {
        return new JdbcSqlQuery().addSqlPart("insert into", new Object[0]).addSqlPart(tableName, new Object[0]).addSqlPart(" (", new Object[0]);
    }

    public static JdbcSqlQuery createUpdateFor(String tableName) {
        return new JdbcSqlQuery().addSqlPart("update ", new Object[0]).addSqlPart(tableName, new Object[0]).addSqlPart(" set", new Object[0]);
    }

    public static JdbcSqlQuery createDeleteFor(String tableName) {
        return new JdbcSqlQuery().addSqlPart("delete from", new Object[0]).addSqlPart(tableName, new Object[0]);
    }

    public static JdbcSqlQuery createDropFor(String tableName) {
        return new JdbcSqlQuery().addSqlPart("drop table", new Object[0]).addSqlPart(tableName, new Object[0]);
    }

    private JdbcSqlQuery() {
    }

    public String getSqlQuery() {
        return this.sqlQuery.toString();
    }

    public Collection<?> getParameters() {
        return this.allParameters;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public JdbcSqlQuery addField(String fieldName, String definition) {
        if (this.sqlQuery.charAt(this.sqlQuery.length() - 2) != ' ' && this.sqlQuery.charAt(this.sqlQuery.length() - 1) != '(') {
            this.sqlQuery.append(", ");
        }
        return this.addSqlPart(fieldName, new Object[0]).addSqlPart(definition, new Object[0]);
    }

    public JdbcSqlQuery where(String sqlPart, Object ... paramValue) {
        return this.where(sqlPart, Arrays.asList(paramValue));
    }

    public JdbcSqlQuery where(String sqlPart, Collection<?> paramValues) {
        return this.addSqlPart("where " + sqlPart, paramValues);
    }

    public JdbcSqlQuery and(String sqlPart, Object ... paramValue) {
        return this.and(sqlPart, Arrays.asList(paramValue));
    }

    public JdbcSqlQuery and(String sqlPart, Collection<?> paramValues) {
        return this.addSqlPart("and " + sqlPart, paramValues);
    }

    public JdbcSqlQuery or(String sqlPart, Object ... paramValue) {
        return this.or(sqlPart, Arrays.asList(paramValue));
    }

    public JdbcSqlQuery or(String sqlPart, Collection<?> paramValues) {
        return this.addSqlPart("or " + sqlPart, paramValues);
    }

    public JdbcSqlQuery addSqlPart(String sqlPart, Object ... paramValue) {
        return this.addSqlPart(sqlPart, Arrays.asList(paramValue));
    }

    public JdbcSqlQuery addSqlPart(String sqlPart, Collection<?> paramValues) {
        char lastChar;
        this.allParameters.addAll(paramValues);
        if (this.sqlQuery.length() > 0 && (lastChar = this.sqlQuery.charAt(this.sqlQuery.length() - 1)) != ' ' && lastChar != '(') {
            this.sqlQuery.append(" ");
        }
        this.sqlQuery.append(sqlPart.trim().replaceAll("[ ]+", " "));
        return this;
    }

    public JdbcSqlQuery in(Collection<?> parameters) {
        this.sqlQuery.append(" in");
        this.addListOfParameters(parameters, true);
        return this;
    }

    public JdbcSqlQuery in(Object ... parameters) {
        this.sqlQuery.append(" in");
        this.addListOfParameters(Arrays.asList(parameters), true);
        return this;
    }

    private JdbcSqlQuery valuesForInsert() {
        this.sqlQuery.append(") values");
        this.addListOfParameters(this.allParameters, false);
        return this;
    }

    private JdbcSqlQuery finalizeTableCreation() {
        this.sqlQuery.append(")");
        return this;
    }

    private JdbcSqlQuery addListOfParameters(Collection<?> parameters, boolean addToParameters) {
        StringBuilder params = new StringBuilder();
        if (parameters != null) {
            for (Object ignored : parameters) {
                if (params.length() > 0) {
                    params.append(",");
                }
                params.append("?");
            }
            if (addToParameters) {
                this.allParameters.addAll(parameters);
            }
        }
        this.sqlQuery.append(" (").append(params.toString()).append(")");
        return this;
    }

    public JdbcSqlQuery addInsertParam(String paramName, Object paramValue) {
        return this.addSaveParam(paramName, paramValue, true);
    }

    public JdbcSqlQuery addUpdateParam(String paramName, Object paramValue) {
        return this.addSaveParam(paramName, paramValue, false);
    }

    public JdbcSqlQuery addSaveParam(String paramName, Object paramValue, boolean isInsert) {
        if (this.allParameters.size() > 0) {
            this.sqlQuery.append(", ");
        } else if (!isInsert) {
            this.sqlQuery.append(" ");
        }
        this.sqlQuery.append(paramName.trim());
        if (!isInsert) {
            this.sqlQuery.append(" = ?");
        }
        this.allParameters.add(paramValue);
        return this;
    }

    public <ROW_ENTITY> List<ROW_ENTITY> execute(SelectResultRowProcess<ROW_ENTITY> process) throws SQLException {
        return JdbcSqlExecutorProvider.getJdbcSqlExecutor().select(this, process);
    }

    public <ROW_ENTITY> ROW_ENTITY executeUnique(SelectResultRowProcess<ROW_ENTITY> process) throws SQLException {
        return JdbcSqlQuery.unique(this.execute(process));
    }

    void finalizeBeforeExecution() {
        String computedSqlQuery = this.getSqlQuery();
        if (computedSqlQuery.startsWith("insert into ")) {
            this.valuesForInsert();
        } else if (computedSqlQuery.startsWith("create table ")) {
            this.finalizeTableCreation();
        }
    }

    public long execute() throws SQLException {
        String sqlQuery = this.getSqlQuery();
        if (sqlQuery.startsWith("select count(*)")) {
            return JdbcSqlExecutorProvider.getJdbcSqlExecutor().selectCount(this);
        }
        return JdbcSqlExecutorProvider.getJdbcSqlExecutor().executeModify(Collections.singletonList(this));
    }

    public static class Configuration {
        private int limit = 0;

        int getResultLimit() {
            return this.limit;
        }

        public Configuration withResultLimit(int limit) {
            this.limit = limit;
            return this;
        }
    }
}

