/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.media.video.ffmpeg;

import com.silverpeas.util.MetaData;
import com.silverpeas.util.MetadataExtractor;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.File;
import javax.inject.Named;
import org.silverpeas.media.video.ThumbnailPeriod;
import org.silverpeas.media.video.VideoThumbnailExtractor;
import org.silverpeas.media.video.ffmpeg.FFmpegUtil;
import org.silverpeas.util.time.TimeData;

@Named(value="videoThumbnailExtractor")
public class FFmpegThumbnailExtractor
implements VideoThumbnailExtractor {
    private static final FFmpegThumbnailExtractor instance = new FFmpegThumbnailExtractor();

    public static FFmpegThumbnailExtractor getInstance() {
        return instance;
    }

    @Override
    public boolean isActivated() {
        return FFmpegUtil.isActivated();
    }

    @Override
    public void generateThumbnailsFrom(File video) {
        if (video.exists() && video.isFile()) {
            MetaData metadata = MetadataExtractor.getInstance().extractMetadata(video);
            this.generateThumbnailsFrom(metadata, video);
        }
    }

    @Override
    public void generateThumbnailsFrom(MetaData metaData, File video) {
        TimeData timeData = metaData.getDuration();
        if (timeData != null) {
            File thumbnailDir = video.getParentFile();
            for (ThumbnailPeriod thumbPeriod : ThumbnailPeriod.ALL_VALIDS) {
                double timePeriod = thumbPeriod.getPercent() * (double)timeData.getTimeAsLong().longValue() / 1000.0;
                FFmpegUtil.extractVideoThumbnail(video, new File(thumbnailDir, thumbPeriod.getFilename()), (int)timePeriod);
            }
        } else {
            SilverTrace.warn("VideoTool", this.getClass().getSimpleName(), "Problem to retrieve video duration, process video thumbnails has failed");
        }
    }

    private FFmpegThumbnailExtractor() {
    }
}

