/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.password.rule;

import com.silverpeas.util.StringUtil;
import org.silverpeas.password.constant.PasswordRuleType;
import org.silverpeas.password.rule.AbstractPasswordRule;

public class AtLeastXDigitPasswordRule
extends AbstractPasswordRule {
    private Integer value;
    private boolean required = settings.getBoolean(this.getType().getSettingKey(), false);
    private boolean combined;

    public AtLeastXDigitPasswordRule() {
        super(PasswordRuleType.AT_LEAST_X_DIGIT);
        this.value = this.getIntegerFromSettings(this.getType().getSettingKey() + ".X", 0);
        this.combined = settings.getBoolean(this.getType().getSettingKey() + ".combined", false);
        if (this.value == 0) {
            this.required = false;
            this.combined = false;
        }
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isCombined() {
        return this.combined;
    }

    public Integer getValue() {
        return this.value;
    }

    @Override
    public boolean check(String password) {
        return StringUtil.isDefined(password) && this.countRegexOccur(password, "[0-9]") >= this.value;
    }

    @Override
    public String random() {
        StringBuilder random = new StringBuilder();
        for (int i = 0; i < this.value; ++i) {
            random.append((char)(48 + this.random(10)));
        }
        return random.toString();
    }
}

