/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.persistence.model.jpa;

import com.silverpeas.util.StringUtil;
import java.lang.reflect.ParameterizedType;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.silverpeas.persistence.model.AbstractEntity;
import org.silverpeas.persistence.model.Entity;
import org.silverpeas.persistence.model.EntityIdentifier;

@MappedSuperclass
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
public abstract class AbstractJpaEntity<ENTITY extends Entity<ENTITY, IDENTIFIER_TYPE>, IDENTIFIER_TYPE extends EntityIdentifier>
extends AbstractEntity<ENTITY, IDENTIFIER_TYPE> {
    private static final long serialVersionUID = 5862667014447543891L;
    @Transient
    private String tableName;
    @Transient
    private Class<IDENTIFIER_TYPE> entityIdentifierClass;
    @EmbeddedId
    private IDENTIFIER_TYPE id;
    @Column(name="createdBy", nullable=false, insertable=true, updatable=false, length=40)
    private String createdBy;
    @Column(name="createDate", nullable=false, insertable=true, updatable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createDate;
    @Column(name="lastUpdatedBy", nullable=false, length=40)
    private String lastUpdatedBy;
    @Column(name="lastUpdateDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastUpdateDate;
    @Version
    @Column(name="version", nullable=false)
    private Long version = 0L;

    protected Class<IDENTIFIER_TYPE> getEntityIdentifierClass() {
        this.initializeEntityClasses();
        return this.entityIdentifierClass;
    }

    private void initializeEntityClasses() {
        if (this.entityIdentifierClass == null) {
            try {
                this.entityIdentifierClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
                this.tableName = this.getClass().getAnnotation(Table.class).name();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public boolean isPersisted() {
        return super.isPersisted() && StringUtil.isDefined(this.getId());
    }

    @Override
    public String getId() {
        return this.id == null ? null : this.id.asString();
    }

    protected IDENTIFIER_TYPE newIdentifierInstance() {
        try {
            return (IDENTIFIER_TYPE)((EntityIdentifier)this.getEntityIdentifierClass().newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected ENTITY setId(String id) {
        if (StringUtil.isDefined(id)) {
            try {
                this.id = this.newIdentifierInstance();
                this.id.fromString(id);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            this.id = null;
        }
        return (ENTITY)this;
    }

    @PrePersist
    private void beforePersist() {
        this.id = this.newIdentifierInstance().generateNewId(this.tableName, "id");
        this.performBeforePersist();
    }

    @PreUpdate
    private void beforeUpdate() {
        this.performBeforeUpdate();
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public ENTITY setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return (ENTITY)this;
    }

    @Override
    public Date getCreateDate() {
        return this.createDate;
    }

    @Override
    protected ENTITY setCreateDate(Date createDate) {
        this.createDate = createDate;
        return (ENTITY)this;
    }

    @Override
    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    @Override
    protected ENTITY setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
        return (ENTITY)this;
    }

    @Override
    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    @Override
    public ENTITY setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
        return (ENTITY)this;
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    @Override
    protected ENTITY setVersion(Long version) {
        this.version = version;
        return (ENTITY)this;
    }

    @Override
    public void markAsModified() {
        if (this.getLastUpdateDate() != null) {
            this.setLastUpdateDate(new Date(this.getLastUpdateDate().getTime() + 1L));
        }
    }
}

