/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.process.annotation;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ActionType;
import com.stratelia.webactiv.util.WAPrimaryKey;
import com.stratelia.webactiv.util.annotation.Action;
import com.stratelia.webactiv.util.annotation.AnnotationUtil;
import com.stratelia.webactiv.util.annotation.Language;
import com.stratelia.webactiv.util.annotation.SourcePK;
import com.stratelia.webactiv.util.annotation.TargetObject;
import com.stratelia.webactiv.util.annotation.TargetPK;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.cache.service.CacheServiceFactory;
import org.silverpeas.process.ProcessFactory;
import org.silverpeas.process.annotation.SimulationActionProcess;
import org.silverpeas.process.annotation.SimulationElement;
import org.silverpeas.process.annotation.SimulationElementConversionProcess;
import org.silverpeas.process.annotation.SimulationElementLister;
import org.silverpeas.process.management.ProcessExecutionContext;

public abstract class AbstractSimulationActionProcessAnnotationInterceptor<C> {
    protected static final String SIMULATION_PROCESS_PERFORMED = "SIMULATION_PROCESS_PERFORMED";

    protected Object perform(C context, Map<Class<Annotation>, Annotation> methodAnnotations, Map<Class<Annotation>, List<Object>> annotedParametersValues) throws Exception {
        if (CacheServiceFactory.getRequestCacheService().get(SIMULATION_PROCESS_PERFORMED) == null) {
            try {
                SimulationActionProcess simulationActionProcess = (SimulationActionProcess)methodAnnotations.get(SimulationActionProcess.class);
                if (simulationActionProcess == null) {
                    throw new AssertionError((Object)"simulationActionProcess is null (SimulationActionProcess annotation must be specified on the method)");
                }
                Action actionType = (Action)methodAnnotations.get(Action.class);
                if (actionType == null) {
                    throw new AssertionError((Object)"actionType is null (Action annotation must be specified on the method)");
                }
                List<Object> languages = AnnotationUtil.getAnnotedValues(annotedParametersValues, Language.class);
                String language = languages.isEmpty() ? null : (String)languages.get(0);
                List<Object> sourcePKs = AnnotationUtil.getAnnotedValues(annotedParametersValues, SourcePK.class);
                List<Object> targetPKs = AnnotationUtil.getAnnotedValues(annotedParametersValues, TargetPK.class);
                List<Object> targetObjects = AnnotationUtil.getAnnotedValues(annotedParametersValues, TargetObject.class);
                if (!(sourcePKs.isEmpty() && targetObjects.isEmpty() || targetPKs.isEmpty())) {
                    HashMap<Class<SimulationElement>, List<SimulationElement>> elements = new HashMap<Class<SimulationElement>, List<SimulationElement>>();
                    for (WAPrimaryKey wAPrimaryKey : targetPKs) {
                        SimulationElementLister elementLister = simulationActionProcess.elementLister().newInstance();
                        elementLister.setActionType(actionType.value());
                        elementLister.setElements(elements);
                        for (WAPrimaryKey wAPrimaryKey2 : sourcePKs) {
                            if (ActionType.MOVE == actionType.value() && wAPrimaryKey2.getInstanceId().equals(wAPrimaryKey.getInstanceId())) continue;
                            elementLister.listElements(wAPrimaryKey2, language);
                        }
                        for (Object object : targetObjects) {
                            elementLister.listElements(object, language, wAPrimaryKey);
                        }
                        ProcessFactory.getProcessManagement().execute(new SimulationElementConversionProcess(elements, wAPrimaryKey, actionType.value()), new ProcessExecutionContext(wAPrimaryKey.getInstanceId()));
                    }
                    CacheServiceFactory.getRequestCacheService().put(SIMULATION_PROCESS_PERFORMED, true);
                }
                Object object = this.proceed(context);
                return object;
            }
            catch (Exception e) {
                SilverTrace.error("Process", "SimulationActionProcessAnnotationEJBInterceptor.process()", "process.EXCEPTION_FROM_ACTION_PROCESS_SERVICE", e);
                throw e;
            }
            finally {
                CacheServiceFactory.getRequestCacheService().remove(SIMULATION_PROCESS_PERFORMED);
            }
        }
        return this.proceed(context);
    }

    protected abstract Object proceed(C var1) throws Exception;
}

