/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.process.management;

import com.silverpeas.annotation.Service;
import com.silverpeas.util.CollectionUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.LinkedList;
import java.util.Map;
import org.silverpeas.process.SilverpeasProcess;
import org.silverpeas.process.check.ProcessCheck;
import org.silverpeas.process.management.InternalContext;
import org.silverpeas.process.management.ProcessCheckRegistration;
import org.silverpeas.process.management.ProcessErrorType;
import org.silverpeas.process.management.ProcessExecutionContext;
import org.silverpeas.process.management.ProcessManagement;
import org.silverpeas.process.management.ProcessMonitoring;
import org.silverpeas.process.session.ProcessSession;
import org.silverpeas.process.util.ProcessList;

@Service
public class DefaultProcessManagement
implements ProcessManagement {
    private final ThreadLocal<LinkedList<InternalContext<?>>> parentFileTransactions = new ThreadLocal();

    @Override
    public <C extends ProcessExecutionContext> void execute(SilverpeasProcess<C> process, C processExecutionContext) throws Exception {
        this.execute(new ProcessList(process), processExecutionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <C extends ProcessExecutionContext> void execute(ProcessList<C> processes, C processExecutionContext) throws Exception {
        block16: {
            if (processes.isNotEmpty()) {
                InternalContext<C> context = null;
                LinkedList<InternalContext<Object>> internalParentContexts = this.parentFileTransactions.get();
                try {
                    if (internalParentContexts != null && !processExecutionContext.requiresNewFileTransaction()) {
                        context = new InternalContext<C>(internalParentContexts.peekLast().getLast(), processExecutionContext);
                    } else {
                        if (internalParentContexts == null) {
                            internalParentContexts = new LinkedList();
                            this.parentFileTransactions.set(internalParentContexts);
                        }
                        context = new InternalContext<C>(processExecutionContext);
                        processExecutionContext.setFileHandler(new FileHandler(context.getSession()));
                        internalParentContexts.add(context);
                    }
                    for (Map.Entry<String, Object> entry : processes.getSessionParameters().entrySet()) {
                        context.getSession().setAttribute(entry.getKey(), entry.getValue());
                    }
                    for (SilverpeasProcess silverpeasProcess : processes.getList()) {
                        if (context.isFileTransactionInError()) break;
                        context.update(silverpeasProcess);
                        this.processing(silverpeasProcess, context);
                    }
                    if (!context.isOpeningFileTransaction() || context.isFileTransactionInError()) break block16;
                    this.checks(context);
                    if (context.isFileTransactionInError()) break block16;
                    try {
                        for (InternalContext<ProcessExecutionContext> curContext = context.getLast(); curContext != null; curContext = curContext.getPrevious()) {
                            for (SilverpeasProcess<ProcessExecutionContext> process : curContext.getOnSuccessfulProcesses()) {
                                this.onSuccessful(process, curContext);
                            }
                        }
                    }
                    finally {
                        this.commit(context);
                    }
                }
                finally {
                    if (context != null && context.isOpeningFileTransaction()) {
                        internalParentContexts.pollLast();
                        if (CollectionUtil.isEmpty(internalParentContexts)) {
                            this.parentFileTransactions.remove();
                        }
                    }
                }
            }
        }
    }

    private <C extends ProcessExecutionContext> void processing(SilverpeasProcess<C> process, InternalContext<C> context) throws Exception {
        try {
            process.process(context.getProcessExecutionContext(), context.getSession());
            SilverTrace.debug("Process", "processManagement.processFiles()", "processManagement.MAIN_PROCESSING_DONE", "SessionId = " + context.getSession().getId());
        }
        catch (Exception exception) {
            this.handleError(context, ProcessErrorType.DURING_MAIN_PROCESSING, exception, process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checks(InternalContext<?> context) throws Exception {
        Object object = ProcessMonitoring.SYNCHRONIZE;
        synchronized (object) {
            try {
                for (ProcessCheck check : ProcessCheckRegistration.getChecks()) {
                    if (!context.getCheckTypesToProcess().contains((Object)check.getType())) continue;
                    check.check((ProcessExecutionContext)context.getProcessExecutionContext());
                }
                SilverTrace.debug("Process", "ProcessManagement.checks()", "checks.CHECKS_DONE", "SessionId = " + context.getSession().getId());
            }
            catch (Exception exception) {
                this.handleError(context, ProcessErrorType.DURING_CHECKS_PROCESSING, exception, null);
            }
        }
    }

    private void onSuccessful(SilverpeasProcess<?> process, InternalContext<?> context) throws Exception {
        try {
            process.onSuccessful();
            SilverTrace.debug("Process", "processManagement.onSuccessful()", "processManagement.ON_SUCCESSFUL_DONE", "SessionId = " + context.getSession().getId());
        }
        catch (Throwable throwable) {
            SilverTrace.error("Process", "processManagement.onSuccessful()", "processManagement.ON_SUCCESSFUL_ERROR", "SessionId = " + context.getSession().getId(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(InternalContext<?> context, ProcessErrorType errorType, Exception exception, SilverpeasProcess<?> fromProcess) throws Exception {
        block10: {
            if (!context.isFileTransactionInError()) {
                context.setFileTransactionInError(errorType, exception, fromProcess);
            }
            if (context.isOpeningFileTransaction()) {
                try {
                    errorType = context.getErrorType();
                    exception = context.getException();
                    fromProcess = context.getProcessInError();
                    SilverTrace.error("Process", "processManagement.onFailure()", "processManagement.EX_PROCESS_FAILURE", "SessionId = " + context.getSession().getId() + ", ioErrorType = " + errorType.name() + ", exceptionClassName = " + exception.getClass().getName(), exception);
                    Exception continueException = null;
                    for (InternalContext<ProcessExecutionContext> curContext = context.getLast(); curContext != null; curContext = curContext.getPrevious()) {
                        for (SilverpeasProcess<ProcessExecutionContext> processStarted : curContext.getOnFailureProcesses()) {
                            try {
                                processStarted.onFailure(ProcessErrorType.DURING_CHECKS_PROCESSING.equals((Object)errorType) || processStarted == fromProcess ? errorType : ProcessErrorType.OTHER_PROCESS_FAILED, exception);
                            }
                            catch (Exception e) {
                                if (continueException != null) continue;
                                continueException = e;
                            }
                        }
                    }
                    if (continueException != null) {
                        throw continueException;
                    }
                    break block10;
                }
                finally {
                    this.rollback(context);
                }
            }
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(InternalContext<?> context) throws Exception {
        Object object = ProcessMonitoring.SYNCHRONIZE;
        synchronized (object) {
            try {
                ((FileHandler)((ProcessExecutionContext)context.getProcessExecutionContext()).getFileHandler()).checkinSessionWorkingPath();
                SilverTrace.debug("Process", "processManagement.commit()", "processManagement.COMMIT_FILES_DONE", "SessionId = " + context.getSession().getId());
            }
            finally {
                this.clearSession(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback(InternalContext<?> context) {
        if (context.isOpeningFileTransaction()) {
            Object object = ProcessMonitoring.SYNCHRONIZE;
            synchronized (object) {
                try {
                    SilverTrace.debug("Process", "processManagement.rollback()", "processManagement.ROLLBACK_FILES_DONE", "SessionId = " + context.getSession().getId());
                }
                finally {
                    this.clearSession(context);
                }
            }
        }
    }

    private void clearSession(InternalContext<?> context) {
        if (context.isOpeningFileTransaction()) {
            ((FileHandler)((ProcessExecutionContext)context.getProcessExecutionContext()).getFileHandler()).deleteSessionWorkingPath();
            SilverTrace.debug("Process", "processManagement.clearSession()", "processManagement.SESSION_CLEARED", "SessionId = " + context.getSession().getId());
        }
    }

    private final class FileHandler
    extends org.silverpeas.process.io.file.FileHandler {
        protected FileHandler(ProcessSession session) {
            super(session);
        }

        @Override
        public void deleteSessionWorkingPath() {
            super.deleteSessionWorkingPath();
        }

        @Override
        public void checkinSessionWorkingPath() throws Exception {
            super.checkinSessionWorkingPath();
        }
    }
}

