/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine;

import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silverpeasinitialize.IInitialize;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.GeneralPropertiesManager;
import java.io.File;

public class IndexEngineInitialize
implements IInitialize {
    @Override
    public boolean Initialize() {
        String indexPath = GeneralPropertiesManager.getString("uploadsIndexPath");
        String removeLocks = GeneralPropertiesManager.getString("removeLocksOnInit", "");
        if (StringUtil.getBooleanValue(removeLocks)) {
            String property = System.getProperty("java.io.tmpdir");
            SilverTrace.debug("indexEngine", "IndexEngineInitialize.Initialize()", "Removing Locks...(" + property + ")");
            this.removeLockFiles(new File(property));
            this.removeLockFiles(new File(indexPath));
            SilverTrace.debug("indexEngine", "IndexEngineInitialize.Initialize()", "Locks removed !");
        }
        return true;
    }

    protected void removeLockFiles(File theFile) {
        if (theFile.isDirectory()) {
            File[] list = theFile.listFiles();
            int i = 0;
            while (list != null && i < list.length) {
                this.removeLockFiles(list[i++]);
            }
        } else if (theFile.isFile() && this.isLockFile(theFile.getName())) {
            if (!theFile.delete()) {
                SilverTrace.error("indexEngine", "IndexEngineInitialize.removeLockFiles", "util.EX_DELETE_FILE_ERROR", theFile.getPath());
            } else {
                SilverTrace.debug("indexEngine", "IndexEngineInitialize.removeLockFiles", "Lock " + theFile.getPath() + " removed.");
            }
        }
    }

    protected boolean isLockFile(String fileName) {
        return fileName.startsWith("lucene-") || "write.lock".equalsIgnoreCase(fileName);
    }
}

