/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.search.indexEngine.model;

import com.silverpeas.util.i18n.I18NHelper;
import java.io.File;
import java.io.Serializable;

public class FileDescription
implements Serializable {
    private static final long serialVersionUID = 6095740867318623417L;
    private final String path;
    private final String encoding;
    private final String format;
    private final String lang;

    public FileDescription(String path, String encoding, String format, String lang) {
        this.path = path.replace('\\', File.separatorChar);
        this.encoding = encoding;
        this.format = format;
        this.lang = I18NHelper.checkLanguage(lang);
    }

    public String getPath() {
        return this.path;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFormat() {
        return this.format;
    }

    public String getLang() {
        return this.lang;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileDescription that = (FileDescription)o;
        if (this.format != null ? !this.format.equals(that.format) : that.format != null) {
            return false;
        }
        if (this.lang != null ? !this.lang.equals(that.lang) : that.lang != null) {
            return false;
        }
        return this.path.equals(that.path);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.lang != null ? this.lang.hashCode() : 0);
        return result;
    }
}

